.\" $Xorg: xset.man,v 1.4 2001/02/09 02:05:59 xorgcvs Exp $
.\" Copyright 1988, 1998  The Open Group
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\" 
.\" $XFree86: xc/programs/xset/xset.man,v 3.14 2001/12/14 20:02:22 dawes Exp $
.\" 
.TH XSET 1 __xorgversion__
.SH NAME
xset - user preference utility for X
.SH SYNOPSIS
.B xset
[-display \fIdisplay\fP]
.br
[-b] [b {on|off}] [b [\fIvolume\fP [\fIpitch\fP [\fIduration\fP]]]]
.br
[-bc] [bc]
.br
[-c] [c {on|off}] [c [\fIvolume\fP]]
.br
[+dpms] [-dpms]
.br
	[dpms \fIstandby\fP [\fI suspend\fP [\fI off\fP]]] 
	[dpms force {standby|suspend|off|on}]
.br
[fp=\fIpathlist\fP] 
[-fp=\fIpathlist\fP] 
[+fp=\fIpathlist\fP] 
[fp-\fIpathlist\fP] 
[fp+\fIpathlist\fP] 
.br
[fp default] [fp rehash]
.br
[-led [\fIinteger\fP|named \fIindicator\fP]]
[led [\fIinteger\fP|named \fIindicator\fP]]
.br 
[led {on|off}]
.br
[mouse [\fIaccel_mult\fP[/\fIaccel_div\fP] [\fIthreshold\fP]]] [mouse default]
.br
[p \fIpixel\fP \fIcolor\fP]
.br
[-r [keycode]]  [r [keycode]] 
[r {on|off}] [r rate \fIdelay\fP [\fIrate\fP]]
.br
[s [\fIlength\fP [\fIperiod\fP]]] [s {blank|noblank}]
[s {expose|noexpose}] [s {on|off}] [s default] [s activate] [s reset]
.br
[q]
.SH DESCRIPTION
This program is used to set various user preference options of the display.
.SH OPTIONS
.PP
.TP 8
.B \-display \fIdisplay\fP
This option specifies the server to use; see \fIX(__miscmansuffix__)\fP.
.PP
.TP 8
.B b
The \fBb\fP option controls bell volume, pitch and duration.
This option accepts up to three numerical parameters, a preceding
dash(-), or a 'on/off' flag.  If no parameters are
given, or the 'on' flag is used, the system defaults will be used.
If the dash or 'off' are given, the bell will be turned
off.
If only one numerical parameter is given, the
bell volume will be set to that value, as a percentage of its maximum.
Likewise, the second numerical
parameter specifies the bell pitch, in hertz, and
the third numerical parameter
specifies the duration in milliseconds.  Note that not
all hardware can vary the bell characteristics.  The X server will set
the characteristics of the bell as closely as it can to the user's
specifications.
.PP
.TP 8
.B bc
The \fBbc\fP option controls \fIbug compatibility\fP mode in the server,
if possible; a preceding dash(-) disables the mode, otherwise the mode
is enabled.  Various pre-R4 clients pass illegal values in some
protocol requests, and pre-R4 servers did not correctly generate
errors in these cases.  Such clients, when run against an R4 server,
will terminate abnormally or otherwise fail to operate correctly.
Bug compatibility mode explicitly reintroduces certain bugs into the
X server, so that many such clients can still be run.  This mode should be
used with care; new application development should be done with this mode
disabled.  The server must support the MIT-SUNDRY-NONSTANDARD
protocol extension in order for this option to work.
.TP 8
.B c
The \fBc\fP option controls key click.
This option can take an optional value, a preceding dash(-),
or an 'on/off' flag.
If no parameter or the 'on' flag is given, the system defaults
will be used. If the dash or 'off' flag is used, keyclick will be
disabled.
If a value from 0 to 100 is given, it is used to
indicate volume, as a percentage of the maximum.
The X server will set
the volume to the nearest value that the hardware can support.
.PP
.TP 8
.B \-dpms
The \fB\-dpms\fP option disables DPMS (Energy Star) features.
.TP 8
.B +dpms
The \fB+dpms\fP option enables DPMS (Energy Star) features.
.TP 8
.B dpms \fIflags...\fP
The \fBdpms\fP option allows the DPMS (Energy Star) parameters to be
set.  The option can take up to three numerical values, or the `force'
flag followed by a DPMS state.  The `force' flags forces the server
to immediately switch to the DPMS state specified.  The DPMS state can
be one of `standby', `suspend', `off', or `on'.  When numerical values are
given, they set the inactivity period
(in units of seconds)
before the three modes are activated.
The first value given is for the `standby' mode, the second is for the
`suspend' mode, and the third is for the `off' mode.  Setting these
values implicitly enables the DPMS features.  A value of zero disables
a particular mode.
.TP 8
.B fp= \fIpath,...\fP
The \fBfp=\fP sets the font path to the entries given in the path argument.
The entries are interpreted by the server, not by the client.
Typically they are directory names or font server names, but the
interpretation is server-dependent.
.TP 8
.B fp \fBdefault\fP
The \fBdefault\fP argument causes the font path to be reset to the server's
default.
.TP 8
.B fp \fBrehash\fP
The \fBrehash\fP argument resets the font path to its current value,
causing the server to reread the font databases in
the current font path.  This is generally only used when adding new fonts to
a font directory (after running \fImkfontdir\fP to recreate the font database).
.PP
.TP 8
.B "\-fp \fRor\fP fp\-"
The \fB\-fp\fP and \fBfp\-\fP options remove elements from the current
font path.  They must be followed by a comma-separated list of entries.
.PP
.TP 8
.B "\+fp \fRor\fP fp\+"
This \fB\+fp\fP and \fBfp\+\fP options prepend and append elements to the 
current font path, respectively.  They must be followed by a comma-separated 
list of entries.
.PP
.TP 8
.B led
The \fBled\fP option controls the keyboard LEDs.
This controls the turning on or off of one or all of the LEDs.
It accepts an optional integer, a preceding dash(-) or an 'on/off' flag.
If no parameter or the 'on' flag is given, all LEDs are turned on.
If a preceding dash or the flag 'off' is given, all LEDs are turned off.
If a value between 1 and 32 is given, that LED will be turned on or off
depending on the existence of a preceding dash.
``xset led 3'' would turn led #3 on.  ``xset -led 3'' would turn it off.
The particular LED values may refer to different LEDs on different
hardware.
If the X server supports the XKEYBOARD (XKB) extension, leds may be
referenced by the XKB indicator name by specifying the `named' keyword
and the indicator name.   For example, to turn on the Scroll Lock LED:
.IP
xset led named "Scroll Lock"
.PP
.TP 8
.B mouse
The \fBm\fP option controls the mouse parameters; it may be
abbreviated to 'm'.
The parameters for the mouse are `acceleration' and `threshold'.
The acceleration can be specified as an integer, or as a simple
fraction.
The mouse, or whatever pointer the machine is connected to,
will go `acceleration' times as fast when it travels more than `threshold'
pixels in a short time.  This way, the mouse can be used for precise
alignment when it is moved slowly, yet it can be set to travel across
the screen in a flick of the wrist when desired.  One or both
parameters for the 
.B m
option can be omitted, but if only one is
given, it will be interpreted as the acceleration.
If no parameters or the flag 'default' is used, the system defaults will
be set.

If the `threshold' parameter is provided and 0, the `acceleration'
parameter will be used in the exponent of a more natural and continuous
formula, giving precise control for slow motion but big reach for fast
motion, and a progressive transition for motions in between.
Recommended `acceleration' value in this case is 3/2 to 2, but not
limited to that range.
.PP
.TP 8
.B p
The \fBp\fP option controls pixel color values.
The parameters are the color map entry number in decimal,
and a color specification.  The root background colors may be changed
on some servers by altering the entries for BlackPixel and WhitePixel.
Although these are often 0 and 1, they need not be.  Also, a server may
choose to allocate those colors privately, in which case an error will
be generated.  The map entry must not be a read-only color,
or an error will result.
.PP
.TP 8
.B r
The \fBr\fP option controls the autorepeat.
Invoking with "\fB-r\fP", or "\fBr\ off\fP", will disable autorepeat, whereas
"\fBr\fP", or "\fBr\ on\fP" will enable autorepeat.
Following the "\fB-r\fP" or "\fBr\fP" option with an integer keycode between 0 and
255 will disable or enable autorepeat on that key respectively, but only
if it makes sense for the particular keycode.  Keycodes below 8 are
not typically valid for this command.  Example: "\fBxset\ -r\ 10\fP" will
disable autorepeat for the "1" key on the top row of an IBM PC keyboard.

If the server supports the XFree86-Misc extension, or the XKB extension, 
then a parameter
of 'rate' is accepted and should be followed by zero, one or two numeric
values. The first specifies the delay before autorepeat starts and
the second specifies the repeat rate.  In the case that the server
supports the XKB extension, the delay is the number of milliseconds
before autorepeat starts, and the rate is the number of repeats
per second.  If the rate or delay is not given, it will be set 
to the default value.
.PP
.TP 8
.B s
The \fBs\fP option lets you set the screen saver parameters.
This option accepts up to two numerical parameters, a 'blank/noblank'
flag, an 'expose/noexpose' flag, an 'on/off' flag, an 'activate/reset' flag,
or the 'default' flag.
If no parameters or the 'default' flag is used, the system will be set
to its default screen saver characteristics.
The 'on/off' flags simply turn the screen saver functions on or off.
The 'activate' flag forces activation of screen saver even if the screen
saver had been turned off.
The 'reset' flag forces deactivation of screen saver if it is active.
The 'blank' flag sets the
preference to blank the video (if the hardware can do so) rather than
display a background pattern, while 'noblank' sets the
preference to display a pattern rather than blank the video.
The 'expose' flag sets the
preference to allow window exposures (the server can freely discard
window contents), while 'noexpose' sets the preference to disable
screen saver unless the server can regenerate the screens without
causing exposure events.
The length and period
parameters for the screen saver function determines how long the
server must be inactive for screen saving to activate, and the period
to change the background pattern to avoid burn in.
The arguments are specified in seconds.
If only one numerical parameter is given, it will be used for the length.
.PP
.TP 8
.B q
The \fBq\fP option gives you information on the current settings.
.PP
These settings will be reset to default values when you log out.
.PP
Note that not all X implementations are guaranteed to honor all of these
options.
.SH "SEE ALSO"
X(__miscmansuffix__), Xserver(1), xmodmap(1), xrdb(1), xsetroot(1)
.SH AUTHOR
Bob Scheifler, MIT Laboratory for Computer Science
.br
David Krikorian, MIT Project Athena (X11 version)
.br
XFree86-Misc support added by David Dawes and Joe Moss
.br
Manpage updates added by Mike A. Harris <mharris@redhat.com>
