/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.repository.explore;

import java.beans.PropertyEditor;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openrdf.http.webclient.properties.ResourcePropertyEditor;
import org.openrdf.http.webclient.repository.explore.ExplorationResource;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.http.HTTPRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractCommandController;

public class ExploreResourceController
extends AbstractCommandController {
    final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String view;

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = view;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        HttpSession session = request.getSession();
        HTTPRepository repo = (HTTPRepository)session.getAttribute("openrdf-repository");
        binder.registerCustomEditor(Resource.class, (PropertyEditor)new ResourcePropertyEditor(repo.getValueFactory()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        ExplorationResource exploration = (ExplorationResource)command;
        Resource resource = exploration.getResource();
        Map model = errors.getModel();
        model.put(this.getCommandName(), exploration);
        if (resource != null) {
            HttpSession session = request.getSession();
            Repository repo = (Repository)session.getAttribute("openrdf-repository");
            try {
                RepositoryConnection con = repo.getConnection();
                try {
                    model.put("asSubject", con.getStatements(resource, null, null, true, new Resource[0]).asList());
                    if (resource instanceof URI) {
                        model.put("asPredicate", con.getStatements(null, (URI)resource, null, true, new Resource[0]).asList());
                    }
                    model.put("asObject", con.getStatements(null, null, resource, true, new Resource[0]).asList());
                }
                finally {
                    con.close();
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return new ModelAndView(this.getView(), model);
    }
}

