/***************************************************************************
                            KScriptManager.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

	This class is the base for all script engines.

 See {@link KScriptManagerSignals} for signals emitted by KScriptManager.

 

 @author Ian Reinhart Geiser <geiseri@kde.org>

 @short *
	This class is the base for all script engines.
*/
public class KScriptManager extends KScriptClientInterface {
	protected KScriptManager(Class dummy){super((Class) null);}

	private native void newKScriptManager( QObject parent, String name);

/** 
	Create a new instance of the script engine.
		
*/
	public KScriptManager( QObject parent, String name) {
		super((Class) null);
		newKScriptManager( parent, name);
	}

/** 
	Destroy the current script engine.
		
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
	Add a new script instance to the script engine.
	This should be the full name and path to the desktop
	file.
		
*/
	public native boolean addScript( String scriptDesktopFile);

/** 
	Remove a script instance from the script engine.

*/
	public native boolean removeScript( String scriptName);

/** 
	Access the names of script instances from the script engine.

*/
	public native ArrayList scripts();

/** 
	Clear all script intstances in memory
		
*/
	public native void clear();

/** 
	This function will allow the main application of any errors
	that have occured during processing of the script.
		
*/
	public native void error( String msg);

/** 
	This function will allow the main application of any warnings
	that have occured during the processing of the script.
		
*/
	public native void warning( String msg);

/** 
	This function will allow the main application of any normal
	output that has occured during the processing of the script.
		
*/
	public native void output( String msg);

/** 
	This function will allow feedback to any progress bars in the main
	application as to how far along the script is.  This is very useful when
	a script is processing files or doing some long operation that is of a
	known duration.
		
*/
	public native void progress( int percent);

/** 
	This function will allow feedback on completion of the script.
	It turns the result as a {@link KScriptInteface#Result}, and a return
	value as a {@link QVariant}
		
*/
	public native void done( int result, QVariant returned);

/** 
	Run the selected script
		
*/
	public native void runScript( String scriptName, QObject context, QVariant arg);
	public native void runScript( String scriptName);
}
