#ifndef _PROC_VMSTAT_H
#define _PROC_VMSTAT_H

struct vmstat {
	unsigned long cpu_user;		/* user processor time */
	unsigned long cpu_nice;		/* niced processor time */
	unsigned long cpu_system;	/* system processor time */
	unsigned long cpu_idle;		/* idle processor time */
	unsigned long cpu_iowait;	/* I/O wait processor time */
	unsigned long block_in;		/* blocks read */
	unsigned long block_out;	/* blocks written */
	unsigned long swap_in;		/* pages swapped in */
	unsigned long swap_out;		/* pages swapped out */
	unsigned long interrupts;	/* interrupts received */
	unsigned long ctxt;		/* context switches */
	unsigned long running;		/* TASK_RUNNING processes */
	unsigned long blocked;		/* TASK_UNINTERRUPTIBLE processes */
};

#define VMSTAT_ZERO	{ cpu_user: 0 }

extern int get_vmstats(struct vmstat *);

#endif /* _PROC_VMSTAT_H */
