/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.BooleanType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Mirror;
import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.VoidType;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.tools.jdi.ArrayReferenceImpl;
import com.sun.tools.jdi.ArrayTypeImpl;
import com.sun.tools.jdi.BooleanTypeImpl;
import com.sun.tools.jdi.BooleanValueImpl;
import com.sun.tools.jdi.ByteTypeImpl;
import com.sun.tools.jdi.ByteValueImpl;
import com.sun.tools.jdi.CharTypeImpl;
import com.sun.tools.jdi.CharValueImpl;
import com.sun.tools.jdi.ClassLoaderReferenceImpl;
import com.sun.tools.jdi.ClassObjectReferenceImpl;
import com.sun.tools.jdi.ClassTypeImpl;
import com.sun.tools.jdi.CommandSender;
import com.sun.tools.jdi.ConnectionService;
import com.sun.tools.jdi.DoubleTypeImpl;
import com.sun.tools.jdi.DoubleValueImpl;
import com.sun.tools.jdi.EventQueueImpl;
import com.sun.tools.jdi.EventRequestManagerImpl;
import com.sun.tools.jdi.FloatTypeImpl;
import com.sun.tools.jdi.FloatValueImpl;
import com.sun.tools.jdi.IntegerTypeImpl;
import com.sun.tools.jdi.IntegerValueImpl;
import com.sun.tools.jdi.InterfaceTypeImpl;
import com.sun.tools.jdi.InternalEventHandler;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.LongTypeImpl;
import com.sun.tools.jdi.LongValueImpl;
import com.sun.tools.jdi.MirrorImpl;
import com.sun.tools.jdi.ObjectReferenceImpl;
import com.sun.tools.jdi.Packet;
import com.sun.tools.jdi.PacketStream;
import com.sun.tools.jdi.ReferenceTypeImpl;
import com.sun.tools.jdi.ShortTypeImpl;
import com.sun.tools.jdi.ShortValueImpl;
import com.sun.tools.jdi.StringReferenceImpl;
import com.sun.tools.jdi.TargetVM;
import com.sun.tools.jdi.ThreadAction;
import com.sun.tools.jdi.ThreadGroupReferenceImpl;
import com.sun.tools.jdi.ThreadListener;
import com.sun.tools.jdi.ThreadReferenceImpl;
import com.sun.tools.jdi.VMState;
import com.sun.tools.jdi.VirtualMachineManagerImpl;
import com.sun.tools.jdi.VoidTypeImpl;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

class VirtualMachineImpl
extends MirrorImpl
implements PathSearchingVirtualMachine,
ThreadListener {
    public final int sizeofFieldRef;
    public final int sizeofMethodRef;
    public final int sizeofObjectRef;
    public final int sizeofClassRef;
    public final int sizeofFrameRef;
    final int sequenceNumber;
    private final TargetVM target;
    private final EventQueueImpl eventQueue;
    private final EventRequestManagerImpl eventRequestManager;
    final VirtualMachineManagerImpl vmManager;
    private final ThreadGroup threadGroupForJDI;
    int traceFlags = 0;
    static int TRACE_RAW_SENDS = 0x1000000;
    static int TRACE_RAW_RECEIVES = 0x2000000;
    boolean traceReceives = false;
    private Map typesByID;
    private TreeSet typesBySignature;
    private boolean retrievedAllTypes = false;
    private String defaultStratum = null;
    private final Map objectsByID = new HashMap();
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private static final int DISPOSE_THRESHOLD = 50;
    private final List batchedDisposeRequests = Collections.synchronizedList(new ArrayList(60));
    private JDWP.VirtualMachine.Version versionInfo;
    private JDWP.VirtualMachine.ClassPaths pathInfo;
    private JDWP.VirtualMachine.Capabilities capabilities = null;
    private JDWP.VirtualMachine.CapabilitiesNew capabilitiesNew = null;
    private BooleanType theBooleanType;
    private ByteType theByteType;
    private CharType theCharType;
    private ShortType theShortType;
    private IntegerType theIntegerType;
    private LongType theLongType;
    private FloatType theFloatType;
    private DoubleType theDoubleType;
    private VoidType theVoidType;
    private Process process;
    private VMState state = new VMState(this);
    private Object initMonitor = new Object();
    private boolean initComplete = false;
    private boolean shutdown = false;

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public void dispose() {
        this.validateVM();
        this.shutdown = true;
        try {
            JDWP.VirtualMachine.Dispose.process(this.vm);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        this.target.stopListening();
    }

    private void initReferenceTypes() {
        this.typesByID = new HashMap(300);
        this.typesBySignature = new TreeSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInitCompletion() {
        Object object = this.initMonitor;
        synchronized (object) {
            this.initComplete = true;
            this.initMonitor.notifyAll();
        }
    }

    void notifySuspend() {
        this.state.freeze();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBatchedDisposes() {
        if (this.shutdown) {
            return;
        }
        JDWP.VirtualMachine.DisposeObjects.Request[] requestArray = null;
        List list = this.batchedDisposeRequests;
        synchronized (list) {
            int n = this.batchedDisposeRequests.size();
            if (n >= 50) {
                if ((this.traceFlags & 0x10) != 0) {
                    this.printTrace("Dispose threashold reached. Will dispose " + n + " object references...");
                }
                requestArray = new JDWP.VirtualMachine.DisposeObjects.Request[n];
                for (int i = 0; i < requestArray.length; ++i) {
                    SoftObjectReference softObjectReference = (SoftObjectReference)this.batchedDisposeRequests.get(i);
                    if ((this.traceFlags & 0x10) != 0) {
                        this.printTrace("Disposing object " + softObjectReference.key() + " (ref count = " + softObjectReference.count() + ")");
                    }
                    requestArray[i] = new JDWP.VirtualMachine.DisposeObjects.Request(new ObjectReferenceImpl(this, softObjectReference.key()), softObjectReference.count());
                }
                this.batchedDisposeRequests.clear();
            }
        }
        if (requestArray != null) {
            try {
                JDWP.VirtualMachine.DisposeObjects.process(this.vm, requestArray);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
    }

    private void processQueue() {
        Reference reference;
        while ((reference = this.referenceQueue.poll()) != null) {
            SoftObjectReference softObjectReference = (SoftObjectReference)reference;
            this.removeObjectMirror(softObjectReference);
            this.batchForDispose(softObjectReference);
        }
    }

    public void resume() {
        this.validateVM();
        CommandSender commandSender = new CommandSender(){

            public PacketStream send() {
                return JDWP.VirtualMachine.Resume.enqueueCommand(VirtualMachineImpl.this.vm);
            }
        };
        try {
            PacketStream packetStream = this.state.thawCommand(commandSender);
            JDWP.VirtualMachine.Resume.waitForReply(this.vm, packetStream);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 112: {
                    return;
                }
            }
            throw jDWPException.toJDIException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveAllClasses() {
        JDWP.VirtualMachine.AllClasses.ClassInfo[] classInfoArray;
        if ((this.vm.traceFlags & 8) != 0) {
            this.vm.printTrace("Retrieving all ReferenceTypes");
        }
        try {
            classInfoArray = JDWP.VirtualMachine.AllClasses.process((VirtualMachineImpl)this.vm).classes;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (!this.retrievedAllTypes) {
                int n = classInfoArray.length;
                for (int i = 0; i < n; ++i) {
                    JDWP.VirtualMachine.AllClasses.ClassInfo classInfo = classInfoArray[i];
                    ReferenceTypeImpl referenceTypeImpl = this.referenceType(classInfo.typeID, classInfo.refTypeTag, classInfo.signature);
                    referenceTypeImpl.setStatus(classInfo.status);
                }
                this.retrievedAllTypes = true;
            }
        }
    }

    public void suspend() {
        this.validateVM();
        try {
            JDWP.VirtualMachine.Suspend.process(this.vm);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        this.notifySuspend();
    }

    void validateVM() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitInitCompletion() {
        Object object = this.initMonitor;
        synchronized (object) {
            while (!this.initComplete) {
                try {
                    this.initMonitor.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean canAddMethod() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canAddMethod;
    }

    public boolean canGetBytecodes() {
        this.validateVM();
        return this.capabilities().canGetBytecodes;
    }

    public boolean canGetCurrentContendedMonitor() {
        this.validateVM();
        return this.capabilities().canGetCurrentContendedMonitor;
    }

    public boolean canGetMonitorInfo() {
        this.validateVM();
        return this.capabilities().canGetMonitorInfo;
    }

    public boolean canGetOwnedMonitorInfo() {
        this.validateVM();
        return this.capabilities().canGetOwnedMonitorInfo;
    }

    public boolean canGetSourceDebugExtension() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canGetSourceDebugExtension;
    }

    public boolean canGetSyntheticAttribute() {
        this.validateVM();
        return this.capabilities().canGetSyntheticAttribute;
    }

    public boolean canPopFrames() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canPopFrames;
    }

    public boolean canRedefineClasses() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canRedefineClasses;
    }

    public boolean canRequestVMDeathEvent() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canRequestVMDeathEvent;
    }

    public boolean canUnrestrictedlyRedefineClasses() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canUnrestrictedlyRedefineClasses;
    }

    public boolean canUseInstanceFilters() {
        this.validateVM();
        return this.hasNewCapabilities() && this.capabilitiesNew().canUseInstanceFilters;
    }

    public boolean canWatchFieldAccess() {
        this.validateVM();
        return this.capabilities().canWatchFieldAccess;
    }

    public boolean canWatchFieldModification() {
        this.validateVM();
        return this.capabilities().canWatchFieldModification;
    }

    private boolean hasNewCapabilities() {
        return this.versionInfo().jdwpMajor > 1 || this.versionInfo().jdwpMinor >= 4;
    }

    public void exit(int n) {
        this.validateVM();
        this.shutdown = true;
        try {
            JDWP.VirtualMachine.Exit.process(this.vm, n);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        this.target.stopListening();
    }

    public void setDebugTraceMode(int n) {
        this.validateVM();
        this.traceFlags = n;
        this.traceReceives = (n & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BooleanType theBooleanType() {
        if (this.theBooleanType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theBooleanType == null) {
                    this.theBooleanType = new BooleanTypeImpl(this);
                }
            }
        }
        return this.theBooleanType;
    }

    public BooleanValue mirrorOf(boolean bl) {
        this.validateVM();
        return new BooleanValueImpl(this, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteType theByteType() {
        if (this.theByteType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theByteType == null) {
                    this.theByteType = new ByteTypeImpl(this);
                }
            }
        }
        return this.theByteType;
    }

    public ByteValue mirrorOf(byte by) {
        this.validateVM();
        return new ByteValueImpl(this, by);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharType theCharType() {
        if (this.theCharType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theCharType == null) {
                    this.theCharType = new CharTypeImpl(this);
                }
            }
        }
        return this.theCharType;
    }

    public CharValue mirrorOf(char c) {
        this.validateVM();
        return new CharValueImpl(this, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DoubleType theDoubleType() {
        if (this.theDoubleType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theDoubleType == null) {
                    this.theDoubleType = new DoubleTypeImpl(this);
                }
            }
        }
        return this.theDoubleType;
    }

    public DoubleValue mirrorOf(double d) {
        this.validateVM();
        return new DoubleValueImpl(this, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FloatType theFloatType() {
        if (this.theFloatType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theFloatType == null) {
                    this.theFloatType = new FloatTypeImpl(this);
                }
            }
        }
        return this.theFloatType;
    }

    public FloatValue mirrorOf(float f) {
        this.validateVM();
        return new FloatValueImpl(this, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IntegerType theIntegerType() {
        if (this.theIntegerType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theIntegerType == null) {
                    this.theIntegerType = new IntegerTypeImpl(this);
                }
            }
        }
        return this.theIntegerType;
    }

    public IntegerValue mirrorOf(int n) {
        this.validateVM();
        return new IntegerValueImpl(this, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LongType theLongType() {
        if (this.theLongType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theLongType == null) {
                    this.theLongType = new LongTypeImpl(this);
                }
            }
        }
        return this.theLongType;
    }

    public LongValue mirrorOf(long l) {
        this.validateVM();
        return new LongValueImpl(this, l);
    }

    PrimitiveType primitiveTypeMirror(byte by) {
        switch (by) {
            case 90: {
                return this.theBooleanType();
            }
            case 66: {
                return this.theByteType();
            }
            case 67: {
                return this.theCharType();
            }
            case 83: {
                return this.theShortType();
            }
            case 73: {
                return this.theIntegerType();
            }
            case 74: {
                return this.theLongType();
            }
            case 70: {
                return this.theFloatType();
            }
            case 68: {
                return this.theDoubleType();
            }
        }
        throw new IllegalArgumentException("Unrecognized primitive tag " + by);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ShortType theShortType() {
        if (this.theShortType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theShortType == null) {
                    this.theShortType = new ShortTypeImpl(this);
                }
            }
        }
        return this.theShortType;
    }

    public ShortValue mirrorOf(short s) {
        this.validateVM();
        return new ShortValueImpl(this, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VoidType theVoidType() {
        if (this.theVoidType == null) {
            VirtualMachineImpl virtualMachineImpl = this;
            synchronized (virtualMachineImpl) {
                if (this.theVoidType == null) {
                    this.theVoidType = new VoidTypeImpl(this);
                }
            }
        }
        return this.theVoidType;
    }

    public EventQueue eventQueue() {
        return this.eventQueue;
    }

    public EventRequestManager eventRequestManager() {
        this.validateVM();
        return this.eventRequestManager;
    }

    ArrayReferenceImpl arrayMirror(long l) {
        return (ArrayReferenceImpl)this.objectMirror(l, 91);
    }

    ArrayTypeImpl arrayType(long l) {
        return (ArrayTypeImpl)this.referenceType(l, 3, null);
    }

    ClassLoaderReferenceImpl classLoaderMirror(long l) {
        return (ClassLoaderReferenceImpl)this.objectMirror(l, 108);
    }

    ClassObjectReferenceImpl classObjectMirror(long l) {
        return (ClassObjectReferenceImpl)this.objectMirror(l, 99);
    }

    ClassTypeImpl classType(long l) {
        return (ClassTypeImpl)this.referenceType(l, 1, null);
    }

    EventRequestManagerImpl eventRequestManagerImpl() {
        return this.eventRequestManager;
    }

    InterfaceTypeImpl interfaceType(long l) {
        return (InterfaceTypeImpl)this.referenceType(l, 2, null);
    }

    private JDWP.VirtualMachine.Capabilities capabilities() {
        if (this.capabilities == null) {
            try {
                this.capabilities = JDWP.VirtualMachine.Capabilities.process(this.vm);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.capabilities;
    }

    private JDWP.VirtualMachine.CapabilitiesNew capabilitiesNew() {
        if (this.capabilitiesNew == null) {
            try {
                this.capabilitiesNew = JDWP.VirtualMachine.CapabilitiesNew.process(this.vm);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.capabilitiesNew;
    }

    private JDWP.VirtualMachine.ClassPaths getClasspath() {
        if (this.pathInfo == null) {
            try {
                this.pathInfo = JDWP.VirtualMachine.ClassPaths.process(this.vm);
            }
            catch (JDWPException jDWPException) {
                throw jDWPException.toJDIException();
            }
        }
        return this.pathInfo;
    }

    private JDWP.VirtualMachine.Version versionInfo() {
        try {
            if (this.versionInfo == null) {
                this.versionInfo = JDWP.VirtualMachine.Version.process(this.vm);
            }
            return this.versionInfo;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    ObjectReferenceImpl objectMirror(long l) {
        return this.objectMirror(l, 76);
    }

    synchronized ObjectReferenceImpl objectMirror(long l, int n) {
        this.processQueue();
        if (l == 0L) {
            return null;
        }
        ObjectReferenceImpl objectReferenceImpl = null;
        Long l2 = new Long(l);
        SoftObjectReference softObjectReference = (SoftObjectReference)this.objectsByID.get(l2);
        if (softObjectReference != null) {
            objectReferenceImpl = softObjectReference.object();
        }
        if (objectReferenceImpl == null) {
            switch (n) {
                case 76: {
                    objectReferenceImpl = new ObjectReferenceImpl(this.vm, l);
                    break;
                }
                case 115: {
                    objectReferenceImpl = new StringReferenceImpl(this.vm, l);
                    break;
                }
                case 91: {
                    objectReferenceImpl = new ArrayReferenceImpl(this.vm, l);
                    break;
                }
                case 116: {
                    ThreadReferenceImpl threadReferenceImpl = new ThreadReferenceImpl(this.vm, l);
                    threadReferenceImpl.addListener(this);
                    objectReferenceImpl = threadReferenceImpl;
                    break;
                }
                case 103: {
                    objectReferenceImpl = new ThreadGroupReferenceImpl(this.vm, l);
                    break;
                }
                case 108: {
                    objectReferenceImpl = new ClassLoaderReferenceImpl(this.vm, l);
                    break;
                }
                case 99: {
                    objectReferenceImpl = new ClassObjectReferenceImpl(this.vm, l);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid object tag: " + n);
                }
            }
            softObjectReference = new SoftObjectReference(l2, objectReferenceImpl, this.referenceQueue);
            this.objectsByID.put(l2, softObjectReference);
            if ((this.traceFlags & 0x10) != 0) {
                this.printTrace("Creating new " + objectReferenceImpl.getClass().getName() + " (id = " + l + ")");
            }
        } else {
            softObjectReference.incrementCount();
        }
        return objectReferenceImpl;
    }

    synchronized void removeObjectMirror(ObjectReferenceImpl objectReferenceImpl) {
        this.processQueue();
        SoftObjectReference softObjectReference = (SoftObjectReference)this.objectsByID.remove(new Long(objectReferenceImpl.ref()));
        if (softObjectReference == null) {
            throw new InternalException("ObjectReference " + objectReferenceImpl.ref() + " not found in object cache");
        }
        this.batchForDispose(softObjectReference);
    }

    void sendToTarget(Packet packet) {
        this.target.send(packet);
    }

    void waitForTargetReply(Packet packet) {
        this.target.waitForReply(packet);
        this.processBatchedDisposes();
    }

    ReferenceTypeImpl referenceType(long l, byte by) {
        return this.referenceType(l, by, null);
    }

    StringReferenceImpl stringMirror(long l) {
        return (StringReferenceImpl)this.objectMirror(l, 115);
    }

    public boolean threadResumable(ThreadAction threadAction) {
        this.state.thaw();
        return true;
    }

    ThreadGroupReferenceImpl threadGroupMirror(long l) {
        return (ThreadGroupReferenceImpl)this.objectMirror(l, 103);
    }

    ThreadReferenceImpl threadMirror(long l) {
        return (ThreadReferenceImpl)this.objectMirror(l, 116);
    }

    VMState state() {
        return this.state;
    }

    private void batchForDispose(SoftObjectReference softObjectReference) {
        if ((this.traceFlags & 0x10) != 0) {
            this.printTrace("Batching object " + softObjectReference.key() + " for dispose (ref count = " + softObjectReference.count() + ")");
        }
        this.batchedDisposeRequests.add(softObjectReference);
    }

    synchronized void removeObjectMirror(SoftObjectReference softObjectReference) {
        this.objectsByID.remove(softObjectReference.key());
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public Process process() {
        this.validateVM();
        return this.process;
    }

    public String baseDirectory() {
        return this.getClasspath().baseDir;
    }

    public String description() {
        Object[] objectArray = new String[]{"" + this.vmManager.majorInterfaceVersion(), "" + this.vmManager.minorInterfaceVersion(), this.versionInfo().description};
        this.validateVM();
        return MessageFormat.format(this.vmManager.getString("version_format"), objectArray);
    }

    public String getDefaultStratum() {
        return this.defaultStratum;
    }

    public String name() {
        this.validateVM();
        return this.versionInfo().vmName;
    }

    public String version() {
        this.validateVM();
        return this.versionInfo().vmVersion;
    }

    void printReceiveTrace(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer("Receiving:");
        for (int i = n; i > 0; --i) {
            stringBuffer.append("    ");
        }
        stringBuffer.append(string);
        this.printTrace(stringBuffer.toString());
    }

    void printTrace(String string) {
        System.err.println("[JDI: " + string + "]");
    }

    synchronized void removeReferenceType(String string) {
        if (this.typesByID == null) {
            return;
        }
        Iterator iterator = this.typesBySignature.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)iterator.next();
            int n2 = string.compareTo(referenceTypeImpl.signature());
            if (n2 != 0) continue;
            ++n;
            iterator.remove();
            this.typesByID.remove(new Long(referenceTypeImpl.ref()));
            if ((this.vm.traceFlags & 8) == 0) continue;
            this.vm.printTrace("Uncaching ReferenceType, sig=" + string + ", id=" + referenceTypeImpl.ref());
        }
        if (n > 1) {
            this.retrieveClassesBySignature(string);
        }
    }

    public void setDefaultStratum(String string) {
        this.defaultStratum = string;
        if (string == null) {
            string = "";
        }
        try {
            JDWP.VirtualMachine.SetDefaultStratum.process(this.vm, string);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    ThreadGroup threadGroupForJDI() {
        return this.threadGroupForJDI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List allClasses() {
        ArrayList arrayList;
        this.validateVM();
        if (!this.retrievedAllTypes) {
            this.retrieveAllClasses();
        }
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            arrayList = new ArrayList(this.typesBySignature);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List allThreads() {
        this.validateVM();
        return this.state.allThreads();
    }

    public List bootClassPath() {
        return Arrays.asList(this.getClasspath().bootclasspaths);
    }

    public List classPath() {
        return Arrays.asList(this.getClasspath().classpaths);
    }

    public List topLevelThreadGroups() {
        this.validateVM();
        return this.state.topLevelThreadGroups();
    }

    public void redefineClasses(Map map) {
        Mirror mirror;
        Object object;
        int n = map.size();
        JDWP.VirtualMachine.RedefineClasses.ClassDef[] classDefArray = new JDWP.VirtualMachine.RedefineClasses.ClassDef[n];
        this.validateVM();
        if (!this.canRedefineClasses()) {
            throw new UnsupportedOperationException();
        }
        Iterator iterator = map.entrySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            classDefArray[n2] = new JDWP.VirtualMachine.RedefineClasses.ClassDef((ReferenceTypeImpl)object.getKey(), (byte[])object.getValue());
            ++n2;
        }
        this.vm.state().thaw();
        try {
            JDWP.VirtualMachine.RedefineClasses.process(this.vm, classDefArray);
        }
        catch (JDWPException jDWPException) {
            switch (jDWPException.errorCode()) {
                case 60: {
                    throw new ClassFormatError("class not in class file format");
                }
                case 61: {
                    throw new ClassCircularityError("circularity has been detected while initializing a class");
                }
                case 62: {
                    throw new VerifyError("verifier detected internal inconsistency or security problem");
                }
                case 68: {
                    throw new UnsupportedClassVersionError("version numbers of class are not supported");
                }
                case 63: {
                    throw new UnsupportedOperationException("add method not implemented");
                }
                case 64: {
                    throw new UnsupportedOperationException("schema change not implemented");
                }
                case 66: {
                    throw new UnsupportedOperationException("hierarchy change not implemented");
                }
                case 67: {
                    throw new UnsupportedOperationException("delete method not implemented");
                }
                case 70: {
                    throw new UnsupportedOperationException("changes to class modifiers not implemented");
                }
                case 71: {
                    throw new UnsupportedOperationException("changes to method modifiers not implemented");
                }
                case 69: {
                    throw new NoClassDefFoundError("class names do not match");
                }
            }
            throw jDWPException.toJDIException();
        }
        ArrayList<BreakpointRequest> arrayList = new ArrayList<BreakpointRequest>();
        object = this.eventRequestManager();
        iterator = object.breakpointRequests().iterator();
        while (iterator.hasNext()) {
            mirror = (BreakpointRequest)((Object)iterator.next());
            if (!map.containsKey(mirror.location().declaringType())) continue;
            arrayList.add((BreakpointRequest)mirror);
        }
        object.deleteEventRequests(arrayList);
        iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            mirror = (ReferenceTypeImpl)((Object)iterator.next());
            ((ReferenceTypeImpl)mirror).noticeRedefineClass();
        }
    }

    public StringReference mirrorOf(String string) {
        this.validateVM();
        try {
            return JDWP.VirtualMachine.CreateString.process((VirtualMachineImpl)this.vm, (String)string).stringObject;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
    }

    Type findBootType(String string) throws ClassNotLoadedException {
        Object object;
        List list = this.allClasses();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (ReferenceType)iterator.next();
            if (object.classLoader() != null || !object.signature().equals(string)) continue;
            return object;
        }
        object = new JNITypeParser(string);
        throw new ClassNotLoadedException(((JNITypeParser)object).typeName(), "Type " + ((JNITypeParser)object).typeName() + " not loaded");
    }

    PacketStream sendResumingCommand(CommandSender commandSender) {
        return this.state.thawCommand(commandSender);
    }

    private synchronized ReferenceTypeImpl addReferenceType(long l, int n, String string) {
        if (this.typesByID == null) {
            this.initReferenceTypes();
        }
        ReferenceTypeImpl referenceTypeImpl = null;
        switch (n) {
            case 1: {
                referenceTypeImpl = new ClassTypeImpl(this.vm, l);
                break;
            }
            case 2: {
                referenceTypeImpl = new InterfaceTypeImpl(this.vm, l);
                break;
            }
            case 3: {
                referenceTypeImpl = new ArrayTypeImpl(this.vm, l);
                break;
            }
            default: {
                throw new InternalException("Invalid reference type tag");
            }
        }
        if (string != null) {
            referenceTypeImpl.setSignature(string);
        }
        this.typesByID.put(new Long(l), referenceTypeImpl);
        this.typesBySignature.add(referenceTypeImpl);
        if ((this.vm.traceFlags & 8) != 0) {
            this.vm.printTrace("Caching new ReferenceType, sig=" + string + ", id=" + l);
        }
        return referenceTypeImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceTypeImpl referenceType(long l, int n, String string) {
        Comparable<StringBuffer> comparable;
        if ((this.vm.traceFlags & 8) != 0) {
            comparable = new StringBuffer();
            ((StringBuffer)comparable).append("Looking up ");
            if (n == 1) {
                ((StringBuffer)comparable).append("Class");
            } else if (n == 2) {
                ((StringBuffer)comparable).append("Interface");
            } else if (n == 3) {
                ((StringBuffer)comparable).append("ArrayType");
            } else {
                ((StringBuffer)comparable).append("UNKNOWN TAG: " + n);
            }
            if (string != null) {
                ((StringBuffer)comparable).append(", signature='" + string + "'");
            }
            ((StringBuffer)comparable).append(", id=" + l);
            this.vm.printTrace(((StringBuffer)comparable).toString());
        }
        if (l == 0L) {
            return null;
        }
        comparable = null;
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            if (this.typesByID != null) {
                comparable = (ReferenceTypeImpl)this.typesByID.get(new Long(l));
            }
            if (comparable == null) {
                comparable = this.addReferenceType(l, n, string);
            }
        }
        return comparable;
    }

    public List classesByName(String string) {
        this.validateVM();
        String string2 = JNITypeParser.typeNameToSignature(string);
        List list = this.retrievedAllTypes ? this.findReferenceTypes(string2) : this.retrieveClassesBySignature(string2);
        return Collections.unmodifiableList(list);
    }

    private synchronized List findReferenceTypes(String string) {
        if (this.typesByID == null) {
            return new ArrayList(0);
        }
        Iterator iterator = this.typesBySignature.iterator();
        ArrayList<ReferenceTypeImpl> arrayList = new ArrayList<ReferenceTypeImpl>();
        while (iterator.hasNext()) {
            ReferenceTypeImpl referenceTypeImpl = (ReferenceTypeImpl)iterator.next();
            int n = string.compareTo(referenceTypeImpl.signature());
            if (n != 0) continue;
            arrayList.add(referenceTypeImpl);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List retrieveClassesBySignature(String string) {
        JDWP.VirtualMachine.ClassesBySignature.ClassInfo[] classInfoArray;
        if ((this.vm.traceFlags & 8) != 0) {
            this.vm.printTrace("Retrieving matching ReferenceTypes, sig=" + string);
        }
        try {
            classInfoArray = JDWP.VirtualMachine.ClassesBySignature.process((VirtualMachineImpl)this.vm, (String)string).classes;
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        int n = classInfoArray.length;
        ArrayList<ReferenceTypeImpl> arrayList = new ArrayList<ReferenceTypeImpl>(n);
        VirtualMachineImpl virtualMachineImpl = this;
        synchronized (virtualMachineImpl) {
            for (int i = 0; i < n; ++i) {
                JDWP.VirtualMachine.ClassesBySignature.ClassInfo classInfo = classInfoArray[i];
                ReferenceTypeImpl referenceTypeImpl = this.referenceType(classInfo.typeID, classInfo.refTypeTag, string);
                referenceTypeImpl.setStatus(classInfo.status);
                arrayList.add(referenceTypeImpl);
            }
        }
        return arrayList;
    }

    VirtualMachineImpl(VirtualMachineManager virtualMachineManager, ConnectionService connectionService, Process process, int n) {
        super(null);
        JDWP.VirtualMachine.IDSizes iDSizes;
        this.vm = this;
        this.vmManager = (VirtualMachineManagerImpl)virtualMachineManager;
        this.process = process;
        this.sequenceNumber = n;
        this.threadGroupForJDI = new ThreadGroup(this.vmManager.mainGroupForJDI(), "JDI [" + this.hashCode() + "]");
        this.target = new TargetVM(this, connectionService);
        EventQueueImpl eventQueueImpl = new EventQueueImpl(this, this.target);
        new InternalEventHandler(this, eventQueueImpl);
        this.eventQueue = new EventQueueImpl(this, this.target);
        this.eventRequestManager = new EventRequestManagerImpl(this);
        this.target.start();
        try {
            iDSizes = JDWP.VirtualMachine.IDSizes.process(this.vm);
        }
        catch (JDWPException jDWPException) {
            throw jDWPException.toJDIException();
        }
        this.sizeofFieldRef = iDSizes.fieldIDSize;
        this.sizeofMethodRef = iDSizes.methodIDSize;
        this.sizeofObjectRef = iDSizes.objectIDSize;
        this.sizeofClassRef = iDSizes.referenceTypeIDSize;
        this.sizeofFrameRef = iDSizes.frameIDSize;
        EventRequestManagerImpl eventRequestManagerImpl = new EventRequestManagerImpl(this);
        EventRequest eventRequest = eventRequestManagerImpl.createClassPrepareRequest();
        eventRequest.setSuspendPolicy(0);
        eventRequest.enable();
        eventRequest = eventRequestManagerImpl.createClassUnloadRequest();
        eventRequest.setSuspendPolicy(0);
        eventRequest.enable();
        this.notifyInitCompletion();
    }

    private static class SoftObjectReference
    extends SoftReference {
        int count = 1;
        Long key;

        int count() {
            return this.count;
        }

        void incrementCount() {
            ++this.count;
        }

        ObjectReferenceImpl object() {
            return (ObjectReferenceImpl)this.get();
        }

        Long key() {
            return this.key;
        }

        SoftObjectReference(Long l, ObjectReferenceImpl objectReferenceImpl, ReferenceQueue referenceQueue) {
            super(objectReferenceImpl, referenceQueue);
            this.key = l;
        }
    }
}

