#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include "ptt.h"

static int pttfd = -1;
static int pttinv = 0;
static int pttarg = TIOCM_RTS | TIOCM_DTR;

void init_ptt(const char *path, int inverted, int mode)
{
	// fprintf(stderr, "init_ptt(path=%s, inv=%d, mode=%d\n",
	//	path, inverted, mode);

	if (pttfd != -1) {
		set_ptt(0);
		close(pttfd);
		pttfd = -1;
	}

	pttinv = inverted;

	switch (mode) {
	case 0:
		pttarg = TIOCM_RTS;
		break;
	case 1:
		pttarg = TIOCM_DTR;
		break;
	case 2:
		pttarg = TIOCM_RTS | TIOCM_DTR;
		break;
	}

	if (!strcasecmp(path, "none"))
		return;

	if ((pttfd = open(path, O_RDWR, 0)) < 0) {
		fprintf(stderr, "Cannot open PTT device '%s': %s\n",
			path, strerror(errno));
		return;
	}

	set_ptt(0);
}

void set_ptt(int ptt)
{
	int arg = pttarg;

	if (pttfd == -1)
		return;

	if (pttinv)
		ptt = !ptt;

	if (ioctl(pttfd, ptt ? TIOCMBIS : TIOCMBIC, &arg) < 0)
		perror("ptt: ioctl");
}

