#include <stdlib.h>
#include <stdio.h>

#include "trx.h"
#include "feld.h"
#include "filter.h"
#include "fftfilt.h"

static void feld_txinit(struct trx *trx)
{
	struct feld *s = (struct feld *) trx->modem;

	s->preamble = 3;
	s->postamble = 3;
	return;
}

static void feld_rxinit(struct trx *trx)
{
	struct feld *s = (struct feld *) trx->modem;
	int i;

	for (i = 0; i < ColumnLen; i++)
		s->sndbuf[i] = 0.0;

	s->agc = 1.0;

	return;
}

static void feld_free(struct feld *s)
{
        if (s) {
                filter_free(s->hilbert);
		fftfilt_free(s->fftfilt);
                free(s);
        }
}

static void feld_destructor(struct trx *trx)
{
	struct feld *s = (struct feld *) trx->modem;

	feld_free(s);

        trx->modem = NULL;
        trx->txinit = NULL;
        trx->rxinit = NULL;
        trx->txprocess = NULL;
        trx->rxprocess = NULL;
        trx->destructor = NULL;
}

void feld_init(struct trx *trx)
{
        GdkColor color;
        GdkColormap *cmap;
	struct feld *s;
	double flo, fhi;

	if ((s = calloc(1, sizeof(struct feld))) == NULL)
		return;

	s->bw = BandWidth;

	flo = (CenterFreq - s->bw / 2) / SampleRate;
	fhi = (CenterFreq + s->bw / 2) / SampleRate;

        if ((s->hilbert = filter_init_hilbert(37)) == NULL) {
                feld_free(s);
                return;
        }

#if 0
        if ((s->txfilt = filter_init(0.0, 0.025)) == NULL) {
                feld_free(s);
                return;
        }
#endif

        if ((s->fftfilt = fftfilt_init(flo, fhi, 1024)) == NULL) {
                feld_free(s);
                return;
        }

        cmap = gdk_colormap_get_system();

	s->pixmap = gdk_pixmap_new(NULL, 14, 14, 8);

	s->gc_black = gdk_gc_new(s->pixmap);
	gdk_color_black(cmap, &color);
        gdk_gc_set_foreground(s->gc_black, &color);

	s->gc_white = gdk_gc_new(s->pixmap);
	gdk_color_white(cmap, &color);
        gdk_gc_set_foreground(s->gc_white, &color);

        trx->modem = s;

	trx->txinit = feld_txinit;
	trx->rxinit = feld_rxinit;

	trx->txprocess = feld_txprocess;
	trx->rxprocess = feld_rxprocess;

	trx->destructor = feld_destructor;

	trx->samplerate = SampleRate;
	trx->bandwidth = s->bw;
}
