/*-
 * sigList.c --
 *	Signal mapping table
 *
 * Copyright (c) 1982 Regents of the University of California.
 * Copyright (c) 1992 by Andreas Stolcke
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * and Andreas Stolcke make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 */
#ifndef lint
static char *rcsid =
"$Id: sigList.c,v 1.2 1998/04/04 15:36:57 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    <sys/signal.h>

#include    "customs.h"

struct signal {
    int	signo;			/* OS specific signal number */
    char *name;			/* short signal name */
} signalList[] = {
    { 0,	"" },		/* Probe for process */
    { SIGHUP,	"HUP" },	/* hangup */
    { SIGINT,	"INT" },	/* interrupt */
    { SIGQUIT,	"QUIT" },	/* quit */
    { SIGILL,	"ILL" },	/* illegal instruction */
    { SIGTRAP,	"TRAP" },	/* trace trap */
#ifdef SIGIOT
    { SIGIOT,	"IOT" },	/* IOT instruction */
#else
    { SIGABRT,	"ABRT" },	/* Process abort signal */
#endif
#ifdef SIGEMT
    { SIGEMT,	"EMT" },	/* EMT instruction */
#else
    { 99,	"" },		/* undefined */
#endif
    { SIGFPE,	"FPE" },	/* floating point exception */
    { SIGKILL,	"KILL" },	/* kill (cannot be caught or ignored) */
    { SIGBUS,	"BUS" },	/* bus error */
    { SIGSEGV,	"SEGV" },	/* segmentation violation */
#ifdef SIGSYS
    { SIGSYS,	"SYS" },	/* bad argument to system call */
#else
    { 99,	"" },		/* undefined */
#endif
    { SIGPIPE,	"PIPE" },	/* write on a pipe with no one to read it */
    { SIGALRM,	"ALRM" },	/* alarm clock */
    { SIGTERM,	"TERM" },	/* software termination signal from kill */
    { SIGURG,	"URG" },	/* urgent condition on IO channel */
    { SIGSTOP,	"STOP" },	/* sendable stop signal not from tty */
    { SIGTSTP,	"TSTP" },	/* stop signal from tty */
    { SIGCONT,	"CONT" },	/* continue a stopped process */
#ifdef SYSV
    { SIGCLD,	"CLD" },	/* to parent on child stop or exit */
#else
    { SIGCHLD,	"CHLD" },	/* to parent on child stop or exit */
#endif
    { SIGTTIN,	"TTIN" },	/* to readers pgrp upon background tty read */
    { SIGTTOU,	"TTOU" },	/* like TTIN for output with LTOSTOP flag */
#ifdef SYSV
    { SIGPOLL,	"POLL" },	/* input/output possible signal */
#else
    { SIGIO,	"IO" },		/* input/output possible signal */
#endif
#ifdef SIGXCPU
    { SIGXCPU,	"XCPU" },	/* exceeded CPU time limit */
#else
    { 99,	"" },		/* undefined */
#endif
#ifdef SIGXFSZ
    { SIGXFSZ,	"XFSZ" },	/* exceeded file size limit */
#else
    { 99,	"" },		/* undefined */
#endif
    { SIGVTALRM,"VTALRM" },	/* virtual time alarm */
    { SIGPROF,	"PROF" },	/* profiling time alarm */
#ifdef SIGWINCH
    { SIGWINCH, "WINCH" },	/* window changed */
#else
    { 99,	"" },		/* window changed */
#endif
#ifdef SIGLOST
    { SIGLOST,	"LOST" },	/* resource lost (eg, record-lock lost) */
#else
    { 99,	"" },		/* undefined */
#endif
    { SIGUSR1,	"USR1" },	/* user defined signal 1 */
    { SIGUSR2,	"USR2" },	/* user defined signal 2 */
    { 99,	"invalid" }	/* Undefined on this system */
};

