/***************************************************************************
                          distance.cpp  -  description
                             -------------------
    begin                : Thu Jul 26 2001
    copyright            : (C) 2001 by Marc Bartsch
    email                : marc.bartsch@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "distance.h"

Distance::Distance() : GeoMeasure()
{
	ID = ID_distance;
  identificator = "Distance";

	int temp[] = { ID_geoPoint, 2, -1 };
	convertParams( temp, sizeof( temp ) / sizeof( temp[0] ) );
	pic = QPixmap( UserIcon( "distance" ) );
	picRect  = QRect( 2, 2, 20, 20 );
}

Distance::~Distance()
{
}

void Distance::move()
{
	Coordinates coord1, coord2, coord3, coord4;

	coord1 = parents.at( 0 )->getCoordinates();
	coord2 = parents.at( 1 )->getCoordinates();

	// Figure out anchorPoint.
  coord3 = coord1 - coord2;
	coord3 /= 2;
	coord3 += coord2;

	anchorPoint = QPoint( coord3.getI_X(), coord3.getI_Y() );

	MetricsCenter::mapCanvasToGrid( coord1 );
	MetricsCenter::mapCanvasToGrid( coord2 );

	// Calculate distance and store it in value.
	double myValue = coord1.getDistance( coord2 );

  value = QString().setNum( myValue,'f',4 );

	if ( textRect.height() == 0 )
	{
  	textRect.moveCenter( anchorPoint );
	}

	coords = Coordinates( textRect.center() );
}
