#include <stream.h>


#include <qpainter.h>


#include <klocale.h>

#include "lmousetester.h"


LMouseTester::LMouseTester(QWidget *parent, const char *name)
  : QWidget(parent, name)
{
  state = NoButton;
  wheelOffset = 0;
  _wheels=0;
  _buttons=3;
  setMaximumWidth(200);
}


LMouseTester::~LMouseTester()
{
}


void LMouseTester::paintState(bool onlyWheel)
{

  int bw = width()/3;
  int bh = height()*2/5;

  QRect left( 0, 0, bw, bh );
  QRect mid( bw, 0, bw, bh );
  QRect right( 2*bw, 0, bw, bh );
  QRect wheel( width()/2 - bw/4, bh/4, bw/2, bh/2 );
  QRect body( 0, bh, 3*bw, height()-bh-1 );

  QPainter p(this);

  if (!onlyWheel) {
    p.setBrush( state & LeftButton ? black : white );
    p.drawRect( left );

    p.setBrush( state & MidButton ? black : white );
    p.drawRect( mid );

    p.setBrush( state & RightButton ? black : white );
    p.drawRect( right);

    p.setBrush( white );
    p.drawRect( body );

    p.drawText(body, AlignCenter, i18n("Test mouse here!"));
  }

  if (_wheels > 0) {
    p.drawRect( wheel.x()-1, wheel.y()-1, wheel.width()+2, wheel.height()+2);
    p.fillRect( wheel.x(), wheel.y(), wheel.width(), wheel.height(), white );
    p.setBrush( HorPattern );
    p.setBrushOrigin( 0, wheelOffset );
    p.drawRect( wheel );
  }
}


/*bool LMouseTester::x11Event(XEvent *ev)
{
  if (ev->type == ButtonPress)
    cout << "ButtonPress: " << ((XButtonEvent*)ev)->button << endl;

  return false;
}
*/


void LMouseTester::paintEvent(QPaintEvent *)
{
  paintState();
}


bool LMouseTester::eventFilter(QObject *, QEvent * e)
{
  if (e->type() == QEvent::MouseButtonPress || e->type() == QEvent::MouseButtonRelease) {
    state = ( (QMouseEvent*) e)->stateAfter();
    repaint (FALSE );
  }
  else if (e->type() == QEvent::Wheel ) {
    if ( ((QWheelEvent*) e)->delta() < 0 )
      wheelOffset++;
    else
      wheelOffset--;
    paintState ( TRUE );
  }
  return FALSE;
}


void LMouseTester::setMouseConfig(int buttons, int wheels)
{
  _buttons = buttons;
  _wheels = wheels;
  resetState();
}


void LMouseTester::resetState()
{
  state = (ButtonState) 0 ;
  repaint( TRUE );
}


void LMouseTester::mouseMoveEvent(QMouseEvent *)
{
  setFocus();
}

#include "lmousetester.moc"



