
/*
 *	(c) Copyright 1990, Kim Fabricius Storm.  All rights reserved.
 *	(c) Copyright 2001, Michael T Pins.  All rights reserved.
 *
 *	Response handling.
 */

/* aux.c */

#include "config.h"
#include "chset.h"

extern char    *temp_file;
extern int      ed_line;

import int      novice;
import char     delayed_msg[];
import char    *pager;
import char    *inews_program;
import int      inews_pipe_input;
import int      use_mmdf_folders;
import int      data_bits;
import int      append_sig_post;
import char    *home_directory;

export int      empty_answer_check = 1;	/* reject replies that are not edited */
export int      query_signature = 1;	/* query user */
export char    *editor_program = NULL;
export char    *spell_checker = NULL;
export char    *mail_alias_expander = NULL;
export char    *mailer_program = REC_MAIL;
export int      mailer_pipe_input = 1;
export int      response_check_pause = 0;	/* time to wait for
						 * background cmds */
export char    *response_dflt_answer = "send";

#ifndef NNTP
/*
 * invoke aux shell script with suitable arguments
 *
 * WARNING: record may be NULL, so it must be the last argument!!
 */

static void     aux_param_bool(f, name, on)
    FILE           *f;
    char           *name;
    int             on;
{
    fprintf(f, "%s=%s\n", name, on ? "true" : "false");
}

static void     aux_param_str(f, name, str)
    FILE           *f;
    char           *name, *str;
{
    int             xport = (*name == '*');

    if (xport)
	name++;
    fprintf(f, "%s='%s'\n", name, str != NULL ? str : "");
    if (xport)
	fprintf(f, "export %s\n", name);
}

static void     aux_param_int(f, name, i)
    FILE           *f;
    char           *name;
    int             i;
{
    fprintf(f, "%s=%d\n", name, i);
}

int             aux_sh(article_header * ah, char *script, char *prog, char *action, char *record, char *sent_fmt, int append_sig)
{
    FILE           *param;
    char           *args[10], *fn;
    char            route[512], *poster;
    register char **ap = args;

    if (strcmp(prog, "COMPLETE") == 0)
	goto no_params;

    param = open_file(relative(nn_directory, ".param"), OPEN_CREATE);
    if (param == NULL) {
	strcpy(delayed_msg, "cannot create .param file for aux script");
	return 1;
    }
    if (getenv("LOGNAME") == NULL)
	aux_param_str(param, "*LOGNAME", user_name());

    /*
     * with the nn-directory variable, the aux script needs to know where to
     * find the .param file, can't always look in $HOME/.nn
     */
    if (!getenv("NNDIR")) {
	char            ebuf[FILENAME + 8];
	sprintf(ebuf, "NNDIR=%s", nn_directory);
	putenv(ebuf);
    }
    if (strcmp(prog, "cancel") == 0) {
	aux_param_str(param, "ART_ID", action);	/* article id for cancel */
	aux_param_str(param, "GROUP", record);	/* group name for cancel */
	if (news.ng_dist)
	    aux_param_str(param, "DIST", news.ng_dist);	/* dist for cancel */
	else
	    aux_param_str(param, "DIST", "none");	/* dist for cancel */
    } else {
	aux_param_str(param, "FIRST_ACTION", action);
	aux_param_str(param, "RECORD", record);
	aux_param_str(param, "WORK", temp_file);
	aux_param_int(param, "ED_LINE", ed_line);

	aux_param_bool(param, "NOVICE", novice);
	aux_param_bool(param, "EMPTY_CHECK", empty_answer_check);
	aux_param_bool(param, "APPEND_SIG", append_sig);
	aux_param_bool(param, "QUERY_SIG", append_sig && query_signature);

	if (editor_program != NULL)
	    aux_param_str(param, "EDITOR", editor_program);
	aux_param_str(param, "SPELL_CHECKER", spell_checker);
	aux_param_str(param, "ALIAS_EXPANDER", mail_alias_expander);
	aux_param_str(param, "PAGER", pager);
	aux_param_str(param, "MAILER", mailer_program);
	aux_param_bool(param, "MAILER_PIPE", mailer_pipe_input);
	aux_param_int(param, "WAIT_PERIOD", response_check_pause);
	aux_param_str(param, "DFLT_ANSW", response_dflt_answer);
	aux_param_str(param, "POST", inews_program);
	aux_param_bool(param, "POST_PIPE", inews_pipe_input);
	aux_param_str(param, "MMDF_SEP", use_mmdf_folders ? "\1\1\1\1" : "");

	aux_param_str(param, "CHSET_NAME", curchset->cs_name);
	if (curchset->cs_width != 0)
	    aux_param_int(param, "CHSET_WIDTH", curchset->cs_width);
	else
	    aux_param_int(param, "CHSET_WIDTH", data_bits);

	if (current_group != NULL) {
	    aux_param_str(param, "*G", current_group->group_name);
	    if (ah == NULL)
		fn = NULL;
	    else
		fn = group_path_name;
	    aux_param_str(param, "*A", fn != NULL ? fn : "");
	}
	poster = NULL;
	if (ah != NULL && strcmp(prog, "follow") == 0) {
	    poster = news.ng_reply != NULL ? news.ng_reply : news.ng_from;
	    if (poster && reroute(route, poster))
		poster = route;
	    else
		poster = NULL;
	}
	aux_param_str(param, "POSTER_ADR", poster);
    }

    fclose(param);

no_params:
    stop_usage();

    /* OBS: relative() returns ptr to static data below */
    *ap++ = "nnaux";
    *ap++ = script != NULL ? script : relative(lib_directory, "aux");
    *ap++ = prog;
    *ap++ = temp_file;
    *ap++ = NULL;

    if (execute(SHELL, args, 1)) {
	sprintf(delayed_msg, sent_fmt, " not");
	return 1;
    }
    sprintf(delayed_msg, sent_fmt, "");
    return 0;
}

#else

#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#include "nn_term.h"

int             nntp_post(char *);

static char    *tempsuffix(char *name, char *suffix)
{
    static char     concat_name[FILENAME];

    sprintf(concat_name, "%s%s", name, suffix);
    return concat_name;
}

#define MAX_SIGNATURE   4

static void     append_signature()
{
    char            line[256], sigfile[256];
    char           *cp;
    struct passwd  *passwd;
    FILE           *fp;
    int             count = 0;
    char           *dotdir;
    FILE           *temp;

    temp = open_file(temp_file, OPEN_APPEND);

#ifdef DEBUG
    if (temp)
	fprintf(stderr, "temp = %s\n", temp_file);
    else
	fprintf(stderr, "temp = NULL\n");
#endif

    passwd = getpwuid(getuid());
    if (passwd == NULL)
	return;
    dotdir = passwd->pw_dir;

    if (dotdir[0] == '~') {
	(void) strcpy(sigfile, passwd->pw_dir);
	(void) strcat(sigfile, &dotdir[1]);
    } else {
	(void) strcpy(sigfile, dotdir);
    }
    (void) strcat(sigfile, "/");
    (void) strcat(sigfile, ".signature");

#ifdef DEBUG
    fprintf(stderr, "sigfile = '%s'\n", sigfile);
    sleep(2);
#endif

    fp = fopen(sigfile, "r");
    if (fp == NULL)
	return;

#ifdef DEBUG
    fprintf(stderr, "sigfile opened OK\n");
    sleep(2);
#endif

    fprintf(temp, "-- \n");
    while (fgets(line, sizeof(line), fp)) {
	count++;
	if (count > MAX_SIGNATURE) {
	    fprintf(stderr, "Warning: .signature files should be no longer than %d lines.\n", MAX_SIGNATURE);
	    fprintf(stderr, "(Only %d lines of your .signature were posted.)\n", MAX_SIGNATURE);
	    break;
	}
	if ((cp = strchr(line, '\n')))
	    *cp = '\0';
	fprintf(temp, "%s\n", line);
    }
    (void) fclose(fp);
    (void) fclose(temp);

#ifdef DEBUG
    printf(".signature appended (from %s)\n", sigfile);
    sleep(10);
#endif
}


/*
 * return codes:	0 post succeeded
 *			1 post failed
 *			22 aborted
 *			   unable to stat temp file
 *			   original and copy identical
 *			   hold response
 */

int             aux_sh(article_header * ah, char *script, char *prog, char *action, char *record, char *sent_fmt, int append_sig)
{
    FILE           *temp, *tempf;
    char            final[FILENAME], copy[FILENAME];
    char            hdrs[FILENAME], bdy[FILENAME], sgn[FILENAME];
    char           *args[10];
    char            route[512], *poster = NULL;
    register char **ap = args;
    int             loop = 1, prmpt = 0;
    char            cc[256], pr[80], pr1[80], fname[FILENAME], buf[80];
    char            lookfor[16], send[8], sent[8], sendpr[8], message[8];
    int             x, act = response_dflt_answer[0];
    struct stat     statb;

    if (strcmp(prog, "COMPLETE") != 0) {
	poster = NULL;
	if (ah != NULL && strcmp(prog, "follow") == 0) {
	    poster = news.ng_reply != NULL ? news.ng_reply : news.ng_from;
	    if (poster && reroute(route, poster))
		poster = route;
	    else
		poster = NULL;
	}
    }
    stop_usage();

    cc[0] = CR;

    if (strcmp(prog, "COMPLETE") == 0) {
	empty_answer_check = 0;
	action = "edit";
	prog = "post";
	copy_file(relative(nn_directory, "hold.work"), temp_file, 0);
	unlink(relative(nn_directory, "hold.work"));
    }
    temp = open_file(temp_file, OPEN_APPEND);

    if (strcmp(prog, "cancel") == 0) {
	fprintf(temp, "Newsgroups: %s\n", record);
	fprintf(temp, "Subject: cmsg cancel %s\n", action);
	fprintf(temp, "Control: cancel %s\n", action);
	if (news.ng_dist)
	    fprintf(temp, "Distribution: %s\n", news.ng_dist);
	fprintf(temp, "\n");
	fprintf(temp, "cancel %s in newsgroup %s\n", action, record);
	fprintf(temp, "\n");
	fprintf(temp, "This article was cancelled from within %s\n", version_id);
	fprintf(temp, "\n");
	fclose(temp);
	x = (nntp_post(temp_file));
	if (x != 0)
	    msg("Unable to cancel article");
	unlink(temp_file);
	return (x);
    } else if (strcmp(prog, "post") == 0 || strcmp(prog, "follow") == 0) {
	strcpy(lookfor, "Newsgroups:");
	strcpy(send, "post ");
	strcpy(sent, "posted ");
	strcpy(sendpr, "p)ost ");
	strcpy(message, "article");
    } else {
	strcpy(lookfor, "To:");
	strcpy(send, "send ");
	strcpy(sent, "sent ");
	strcpy(sendpr, "s)end ");
	strcpy(message, "letter");
    }

    if (action != "send") {
	strcpy(copy, tempsuffix(temp_file, "C"));
	copy_file(temp_file, copy, 0);
    }
    strcpy(pr, "a)bort ");

    if (poster)
	strcat(pr, "c)c ");

    strcat(pr, "e)dit h)old ");

    if (spell_checker)
	strcat(pr, "i)spell ");

    strcat(pr, "m)ail ");

    if (strcmp(prog, "post") == 0 || strcmp(prog, "follow") == 0)
	strcat(pr, "p)ost ");

    strcat(pr, "r)eedit ");

    if (strcmp(prog, "post") != 0 && strcmp(prog, "follow") != 0)
	strcat(pr, "s)end ");

    strcat(pr, "v)iew w)rite S)ign ");

    if (response_dflt_answer) {
	if (strncmp(response_dflt_answer, "p", 1) || strncmp(response_dflt_answer, "s", 1)) {
	    strcpy(pr1, send);
	    strcat(pr1, message);
	} else {
	    strcpy(pr1, response_dflt_answer);
	}
    } else {
	strcpy(pr1, "");
    }


    while (loop) {
	if (action != NULL) {
	    act = action[0];
	    action = NULL;
	} else if (prmpt) {
	    prompt_line = Lines - 1;
	    prompt("%s\r\nAction: (%s) ", pr, pr1);
	    act = get_c();
	    if (act == CR)
		act = response_dflt_answer[0];
	}
	prmpt = 1;

	switch (act) {
	    case 'a':
		prompt_line = Lines - 1;
		prompt("Confirm abort: (y) ");
		switch (get_c()) {
		    case CR:
		    case 'y':
		    case 'Y':
			unlink(temp_file);
			unlink(copy);
			return (22);
		}
		break;

	    case 'c':
		if (poster) {
		    prompt_line = Lines - 1;
		    prompt("CC: %s (y)", poster);
		    switch (get_c()) {
			case CR:
			case 'y':
			case 'Y':
			    msg("Sending copy to poster....");
			    strcpy(cc, poster);
			    break;
		    }
		} else
		    msg("Not doing follow-up");
		break;

	    case 'e':
		if (!editor_program)
		    editor_program = getenv("EDITOR");

		if (!editor_program)
		    editor_program = "vi";

		ap = args;
		*ap++ = editor_program;
		*ap++ = temp_file;
		*ap++ = NULL;
		execute(editor_program, args, 1);

		if (stat(temp_file, &statb) < 0 || statb.st_size == 0) {
		    sprintf(delayed_msg, sent_fmt, " not");
		    unlink(temp_file);
		    unlink(copy);
		    return (22);
		}
		if (empty_answer_check)
		    if (cmp_file(temp_file, copy) != 1) {
			sprintf(delayed_msg, sent_fmt, " not");
			unlink(temp_file);
			unlink(copy);
			return (22);
		    }
		if (lookfor);	/* grep for lookfor */

		break;

	    case 'h':
		prompt_line = Lines - 1;
		prompt("Complete response later: (y) ");
		switch (get_c()) {
		    case CR:
		    case 'y':
		    case 'Y':
			link(temp_file, relative(nn_directory, "hold.work"));
			unlink(temp_file);
			unlink(copy);
			return (22);
		}
		break;

	    case 'i':
		unset_raw();
		if (spell_checker) {
		    clrdisp();
		    gotoxy(0, 1);
		    ap = args;
		    *ap++ = spell_checker;
		    *ap++ = temp_file;
		    *ap++ = NULL;
		    execute(spell_checker, args, 1);
		} else {
		    msg("spell-checker not defined");
		    user_delay(2);
		}
		nn_raw();
		break;

	    case 'm':
		prompt_line = Lines - 1;
		prompt("To: ");
		unset_raw();
		if (getline(&cc[0], sizeof(cc)) == 0)
		    cc[0] = CR;
		nn_raw();
		if (cc[0] != CR)
		    msg("Sending copy....");
		break;

	    case 'n':
		act = 'a';
		prmpt = 0;
		break;

	    case 'p':
	    case 's':
		loop = 0;
		break;

	    case 'r':
		prompt_line = Lines - 1;
		prompt("Undo all changes? (n) ");
		switch (get_c()) {
		    case 'y':
		    case 'Y':
			copy_file(copy, temp_file, 0);
		}
		action = "edit";
		break;

	    case 'v':
		clrdisp();
		gotoxy(0, 1);
		if (!pager)
		    pager = getenv("PAGER");
		if (!pager)
		    pager = "cat";
		ap = args;
		*ap++ = pager;
		*ap++ = temp_file;
		*ap++ = NULL;
		execute(pager, args, 1);
		break;

	    case 'w':
		prompt_line = Lines - 1;
		prompt("Append %s to file: ", message);
		strcpy(fname, get_s((char *) NULL, (char *) NULL, (char *) NULL, NULL_FCT));
		if (fname)
		    copy_file(temp_file, fname, 1);
		break;

	    case 'y':
		act = response_dflt_answer[0];
		prmpt = 0;
		break;

	    case 'S':
		strcpy(hdrs, tempsuffix(temp_file, "H"));
		strcpy(bdy, tempsuffix(temp_file, "B"));
		strcpy(sgn, tempsuffix(temp_file, "S"));
		sprintf(buf, "sed -e \'/^$/q\' < %s > %s", temp_file, hdrs);
		system(buf);
		sprintf(buf, "awk \'{if (S== 1) print $0; if ($0 == \"\") S=1}\' < %s > %s", temp_file, bdy);
		system(buf);
		sprintf(buf, "pgp -stfaw < %s > %s", bdy, sgn);
		system(buf);
		sprintf(buf, "cat %s %s > %s", hdrs, sgn, temp_file);
		system(buf);
		unlink(hdrs);
		unlink(bdy);
		unlink(sgn);
		break;
	}

	if (cc[0] != CR) {
	    strcpy(final, tempsuffix(temp_file, "F"));
	    tempf = open_file(final, OPEN_CREATE);
	    x = fprintf(tempf, "To: %s\n", cc);
	    fclose(tempf);
	    sprintf(buf, "sed -e \"s/^To:/X-To:/\" -e \"/^Orig-To:/d\" %s >> %s",
		    temp_file, final);
	    system(buf);
	    if (mailer_pipe_input) {
		sprintf(buf, "%s < %s", mailer_program, final);
		x = system(buf);
	    } else {
		ap = args;
		*ap++ = mailer_program;
		*ap++ = final;
		*ap++ = NULL;
		x = execute(mailer_program, args, 1);
	    }
	    if (!x)
		msg("Done");
	    else
		msg("%s failed", mailer_program);
	    cc[0] = CR;
	}
    }

    if (append_sig && query_signature) {
	prompt_line = Lines - 1;
	prompt("Append .signature? (y) ");
	switch (get_c()) {
	    case CR:
	    case 'y':
	    case 'Y':
		append_signature();
		break;

	    default:
		append_sig = 0;
	}
    }
    if (!strcmp("post", prog) || !strcmp("follow", prog))
	if (novice) {
	    msg("Be patient! Your new %s will not show up immediately.", message);
	    if (response_check_pause < 2)
		user_delay(2);
	    else
		user_delay(response_check_pause);
	}
/* trap signals 1 2 3 here */

    if (record) {
	FILE           *rec;
	char           *logname;
	time_t          t;

	rec = open_file(record, OPEN_APPEND);
	if (rec != NULL) {
	    if (use_mmdf_folders)
		fprintf(rec, "\001\001\001\001\n");
	    logname = getenv("LOGNAME");
	    if (!logname)
		logname = user_name();
	    time(&t);
	    fprintf(rec, "From %s %s", logname, ctime(&t));
	    fprintf(rec, "From: %s\n", logname);
	    fclose(rec);
	    sprintf(buf, "cat %s >> %s", temp_file, record);
	    system(buf);
	}
    }
    if (!strcmp("reply", prog) || !strcmp("forward", prog) || !strcmp("mail", prog)) {
	if (mail_alias_expander) {
	    ap = args;
	    *ap++ = mail_alias_expander;
	    *ap++ = temp_file;
	    *ap++ = NULL;
	    execute(mail_alias_expander, args, 1);
	}
	if (mailer_pipe_input) {
	    sprintf(buf, "%s < %s", mailer_program, temp_file);
	    x = system(buf);
	} else {
	    ap = args;
	    *ap++ = mailer_program;
	    *ap++ = temp_file;
	    *ap++ = NULL;
	    x = execute(mailer_program, args, 1);
	}
	if (x)
	    msg("%s failed", mailer_program);
    } else if (!strcmp("post", prog) || !strcmp("follow", prog)) {
	if (nntp_post(temp_file)) {
	    copy_file(temp_file, relative(home_directory, "dead.letter"), 1);
	    msg("failed post saved in dead.letter");
	    user_delay(2);
	    return (1);
	}
    } else {
	msg("Invalid operation: %s -- help", prog);
	user_delay(2);
    }

    /* onfail copy to dead.letter and email user */

    unlink(temp_file);
    unlink(copy);
    unlink(final);
    sprintf(delayed_msg, sent_fmt, "");
    return (0);
}

#endif
