/*
 * itstime.c is part of Statnet  NOW dispdata.c for NETWATCH
 */
/*
 * Statnet is protected under the GNU Public License (GPL2). 
 * Author: Jeroen Baekelandt (jeroenb@igwe.vub.ac.be)       
 * 27DEC95: Scot E. Wilcoxon (sewilco@fieldday.mn.org)      
 * DISPDATA.C is part of NETWATCH  which like Statnet is under GPL2 
 */
#include "config.h"

#include "netwatch.h"
#include "curs.h"
#include <sys/time.h>

#ifdef NEWCURSES_SUPP
#include <ncurses/curses.h>
#else
#ifdef NEWCURSESROOT_SUPP
#include <ncurses.h>
#else
#include <curses.h>
#endif
#endif

#include <signal.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

void clearnetresolv();
void startnetresolv();

#define MAXREFRESH 15
#define ROUTERSTATSMAX 60
#define TOPUPDATE 30
extern long int timezone;
extern time_t wakeup_reload;
extern int wakeup_state;
extern time_t reload_timer_start;
extern int reload_timer_sec;
extern int reload_active;
extern int freezedisplay;
extern int lastfreeze;

extern FILE *fpspeclog;
extern int speclog;
extern int printtospeclog;
extern char speclogfile[];
extern int speclogext;

extern int curskeyspot;
extern int curskeyval;
extern int cursllockout;
extern int cursrlockout;
extern int curslines;
extern int curshosttrim;
extern int cursproto;
extern int cursdest;

extern int scrmid;
extern struct itimerval oldtm, newtm;
extern int selecthost;
extern int numselect;
extern int selectside;
extern int selectchange;
extern int selectside;
extern char progtitle[60];
extern int ignoredomain;
extern int bluedie;
extern int selprob;
extern int selcode;
extern int sREDTIME,sYELLOWTIME,sGREENTIME;

extern long int ethcnt;
extern int keycnt;
extern int probcnt;
extern int intrcnt;

extern int nokeys;

extern int topflag;
extern HOSTINFO *toplocal;
extern HOSTINFO *topremote;
extern HOSTINFO tldummy, trdummy;

#define MAGNABUFSIZE 2048
struct magrec
  {
    int len;
    char dir;
    unsigned char buf[MAGNABUFSIZE];
  };

#define MAGNAMAX 400
#define MAGNAOFFS 40
extern struct magrec magna[MAGNAMAX];
extern int magnacnt;
extern int magnaoffs;
extern char magnamatch[RESOLVE_MAX];
extern HOSTINFO *magnaspot;
extern u_int32_t magnakey;
extern int magnaphys;
extern int magnafirst;
extern int magnafull;
extern HOSTINFO *magnacomhost;
extern u_int32_t magnacomkey;


unsigned char *ttp;

char *
  servicenm (char *s, int port)
{
  static char sn[80];
  if (s)
    return (s);
  sprintf (sn, "UNK %d", port);
  return (sn);
}

void makeaddr (char naddr[], char ascii[]);

void
  cleancol (int col, int strow, int finrow)
{
  int i;

  for (i = strow; i <= finrow; i++)
    mvaddch (i, col, ' ');
}

void
  displaybuf (struct magrec b, int y, int x, int recnum)
{
  int i, len;
  int scrmid = (MCOLS >> 1) - 8;
  char *p;

  if (magnafull)
    {
      scrmid = MCOLS - 8;
      x = 3;
    }
  if (b.len<0) return;
  len = b.len - magnaoffs + 1;
  p = &b.buf[magnaoffs];
  move (y, x);
  printw("%03d:",recnum);
  if (len > 0)
    {
      if (b.dir)
	{
	  attron (col1);
	  addch ('>');
	  attron (col4);
	}
      else
	{
	  attron (col2);
	  addch ('<');
	  attron (col4);
	}
      for (i = 4; i < len && i < scrmid; i++, p++)
	{
	  if (isprint (*p))
	    addch (*p);
	  else
	    addch ('.');
	}
    }
}

void addtlist(HOSTINFO *rec, HOSTINFO *start)
{
	HOSTINFO *current, *previous;

	previous = start;
	current = start->tflink;
	while (current!=start && current->timelastbytes>rec->timebytes)
	{
		previous = current;
		current = current->tflink;
	}
	previous->tflink = rec;
	rec->tflink = current;
		
}

void
  dispdata (int errnum)
{

  int xleft = 1;		/*
				 * Offset for Local Info 
				 */
  int xright;
  int y;
  static char tmpbuf[80];
  static int refreshscr = 0;
  static int routerstats = 0;
  extern double maxburst;
  static time_t bursttime;
  static char burst[80];
  static time_t routertime;
  static unsigned long int oldrouteruse = 0;
  static unsigned long int oldrouterto = 0;
  static unsigned long int oldrouterfrom = 0;
  unsigned long int tfuse;
  unsigned long int ttuse;
  unsigned long int ttotal;
  static unsigned long int minfuse;
  static unsigned long int mintuse;
  static unsigned long int sec;
  static unsigned long int use;
  double fuse;
  extern unsigned long int routeruse;

  int lcnt = 0;
  int rcnt = 0;
  static char ttt[260];
  static char thost[60];
  static int statsonce = FALSE;
  static int disableburst = FALSE;
  int yact;
  unsigned char *pc;
  extern int help;
  extern int watch;
  extern int llockout;
  extern int rlockout;
  extern int lydisp;
  extern int rydisp;
  extern int localkey;
  extern int localupdate;
  extern int remoteupdate;
  extern int refreshloc;
  extern int refreshrem;
  extern int poschange;
  extern int disprouterstats;
  extern unsigned long routerto;
  extern unsigned long routerfrom;
  extern unsigned long routeruse;
  static unsigned long orouterto = 0;
  static unsigned long orouterfrom = 0;
  int localbypass = FALSE;
  int remotebypass = FALSE;
  time_t mnew;
  extern time_t starttime;
  extern int dispopt;		/*
				 * TXRC IPPROTO OTHER 
				 */
  int updaterest = 0;
  int xoff;
  int ii, ij;
  int dispsize, stmag;

  time_t colred, colyel, colgreen, testt;
  extern HOSTINFO *lfirst;
  extern HOSTINFO *rfirst;
  HOSTINFO *current;
  HOSTINFO *pwork;
  char *tmpservice;
  static char emptystr[] = "";
  static time_t toptime;
  int dotop =0;
  int topupdate=FALSE;
  int oldk;

  mnew = time (0);
  if (mnew>toptime)
  {
	topupdate = TRUE;
	toptime = mnew + TOPUPDATE;
	if (topflag)
		dotop = TRUE;
  }
  if (printtospeclog && speclog)
    {
      strcpy(tmpbuf,ctime(&mnew));
      fprintf (fpspeclog, "\nStatistics\tfrom %s\t\t  to %s\n\n",
	       ctime (&starttime), tmpbuf);
    }
  localbypass = (!localkey && (watch || help));
  remotebypass = (localkey && (watch || help));
  colred = mnew - sREDTIME;		/*
				 * 1 min 
				 */
  colyel = mnew - sYELLOWTIME;		/*
				 * 5 min 
				 */
  colgreen = mnew - sGREENTIME;	/*
				 * 30 min 
				 */
  scrmid = MCOLS >> 1;
  xright = scrmid + 1;
  signal (SIGALRM, dispdata);
  newtm.it_value.tv_sec = 1;
  newtm.it_value.tv_usec = 0;
  setitimer (ITIMER_REAL, &newtm, &oldtm);	/*
						 * first screen update in
						 * 1 sec (exact) 
						 */
/* mvprintw(2,5,"STATE=%d  RELOAD=%ld  CURRENT=%ld  TZ=%ld",wakeup_state,wakeup_reload,
		mnew,timezone); */
 if (!llockout && !rlockout && wakeup_state && wakeup_reload<mnew)
 {	
	wakeup_state = FALSE;
	reload_active = TRUE;
 }
	
	
  if (reload_active)
  {
	if (!llockout && !rlockout && mnew>=reload_timer_start+reload_timer_sec)
	{
		reload_timer_start = mnew;
		reload_active++;
		nokeys = TRUE;
		dokeyin('l');
		dokeyin('c');
		oldk = localkey;
		localkey = FALSE;
		clearnetresolv();
		dokeyin('n');
		startnetresolv();
		nokeys = FALSE;
		localkey = oldk;
	}
  }
  if (poschange)
    lcnt = 0;
  if (!routerstats)
    routertime = mnew;
  routerstats++;
  if (routerstats == ROUTERSTATSMAX)
    {
      statsonce++;
      sec = mnew - routertime;
      use = routeruse - oldrouteruse;
      mintuse = routerto - oldrouterto;
      minfuse = routerfrom - oldrouterfrom;
      routertime = mnew;
      oldrouteruse = routeruse;
      oldrouterto = routerto;
      oldrouterfrom = routerfrom;
      /*
       * CALC STATS for ROUTER  use = # of bytes thru router in "sec"
       * seconds 
       */
      fuse = (double) (use >> 7) / sec;
      if (!freezedisplay) mvprintw (MLINES - 1, scrmid - 12, " ROUTER %13.3g kbits/sec ", fuse);
      routerstats = 0;
    }
  xoff = 1;
  tfuse = routerfrom - orouterfrom;
  ttuse = routerto - orouterto;
  ttotal = tfuse + ttuse;
  fuse = (double) (ttotal >> 7);
  if (!lastfreeze && !disableburst && fuse > maxburst)
    {
      maxburst = fuse;
      bursttime = mnew;
      strcpy (burst, ctime (&bursttime));
      burst[strlen (burst) - 1] = 0;
    }
  if (disableburst)
    disableburst = FALSE;

  if (freezedisplay)
  {
	lastfreeze = TRUE;
	return;
  }
  lastfreeze = FALSE;
  if (rewrite_labels || (printtospeclog && speclog))
    {				/*
				 * if
				 * rewrite_labels 
				 */

      clrportion (1, 1, 4, MCOLS - 1);
      mvprintw (0, (MCOLS / 2) - 10, "%s", progtitle);
      mvprintw (1, MCOLS - (MCOLS) / 3, "REMOTE NETWORK");
      mvprintw (1, (MCOLS - 22) / 4, "LOCAL NETWORK");
      switch (dispopt)
	{
	case DISP_TX_RC:
	  mvprintw (2, (xright + 5), "HOST          (PKTS)     X      R");
	  mvprintw (2, (xleft + 5), "HOST          (PKTS)     X      R");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST          (PKTS)     X      R\n\n");
	  break;
	case DISP_IPPROTO:
	case DISP_IPPROTON:
	  mvprintw (2, (xright + 5), "HOST             IP      SERVICE");
	  mvprintw (2, (xleft + 5), "HOST             IP      SERVICE");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST             IP      SERVICE\n\n");
	  break;
	case DISP_DEST2:
	case DISP_DEST1:
	  mvprintw (2, (xright + 5), "HOST                TALKING TO");
	  mvprintw (2, (xleft + 5), "HOST                TALKING TO");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST                TALKING TO\n\n");
	  break;
	case DISP_ACCT:
	  mvprintw (2, (xright + 5), "HOST     (BYTES)    X          R ");
	  mvprintw (2, (xleft + 5), "HOST      (BYTES)    X          R ");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST      (BYTES)    X          R\n\n");
	  break;
	case DISP_INTTXRCP:
	  mvprintw (2, (xright + 5), "HOST      LOCAL PKTS     X      R");
	  mvprintw (2, (xleft + 5), "HOST      LOCAL PKTS     X      R");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST      LOCAL PKTS     X      R\n\n");
	  break;
	case DISP_EXTTXRCP:
	  mvprintw (2, (xright + 5), "HOST       REM. PKTS     X      R");
	  mvprintw (2, (xleft + 5), "HOST       REM. PKTS     X      R");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST       REM. PKTS     X      R\n\n");
	  break;
	case DISP_INTTXRC:
	  mvprintw (2, (xright + 5), "HOST    LOCAL BYTES X          R ");
	  mvprintw (2, (xleft + 5), "HOST    LOCAL BYTES  X          R ");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST    LOCAL BYTES  X          R\n\n");
	  break;
	case DISP_EXTTXRC:
	  mvprintw (2, (xright + 5), "HOST    REM. BYTES  X          R ");
	  mvprintw (2, (xleft + 5), "HOST    REM. BYTES   X          R ");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST    REM. BYTES   X          R\n\n");
	  break;
	case DISP_MAC:
	  mvprintw (2, (xright + 5), "HOST            MAC ADDRESS      ");
	  mvprintw (2, (xleft + 5), "HOST            MAC ADDRESS      ");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST            MAC ADDRESS \n\n");
	  break;
	case DISP_BADMAC:
	  mvprintw (2, (xright + 5), "HOST           BAD MAC ADDRESS      ");
	  mvprintw (2, (xleft + 5), "HOST            BAD MAC ADDRESS      ");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST            MAC ADDRESS \n\n");
	  break;
	case DISP_SERVER:
	  mvprintw (2, (xright + 5), "HOST            HTTP SERVER      ");
	  mvprintw (2, (xleft + 5), "HOST            HTTP SERVER      ");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST            HTTP SERVER\n\n");
	  break;
	case DISP_FTPSERVER:
	  mvprintw (2, (xright + 5), "HOST            FTP SERVER      ");
	  mvprintw (2, (xleft + 5), "HOST            FTP SERVER      ");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST            FTP SERVER\n\n");
	  break;
	case DISP_LASTINTERVAL:
	  mvprintw (2, (xright + 5), "HOST            INTERVAL BYTES  ");
	  mvprintw (2, (xleft + 5), "HOST            INTERVAL BYTES  ");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST            INTERVAL BYTES\n\n");
	  break;
	case DISP_LASTLIVEINT:
	  mvprintw (2, (xright + 5), "HOST           LIVE INT. BYTES  ");
	  mvprintw (2, (xleft + 5), "HOST           LIVE INT. BYTES  ");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST            LIVE INT. BYTES\n\n");
	  break;
	case DISP_LASTGET:
	  mvprintw (2, (xright + 5), "HOST            LAST GET         ");
	  mvprintw (2, (xleft + 5), "HOST            LAST GET         ");
	  if (printtospeclog && speclog)
	    fprintf (fpspeclog, "HOST            LAST GET\n\n");
	  break;


	}
      refresh ();
      rewrite_labels = 0;
    }
  mvprintw (MLINES - 1, MCOLS - 15, " Eth:%8ld ", ethcnt);
  if (localkey)
    {
      attron (col2);
      mvprintw (1, 1, "KEY");
      attron (col4);
      mvprintw (1, curskeyval, "   ");
    }
  else
    {
      attron (col4);
      mvprintw (1, 1, "   ");
      attron (col2);
      mvprintw (1, curskeyval, "KEY");
      attron (col4);
    }
  mvprintw (0, curslines, "LINE %3d ", rydisp);
  mvprintw (0, 2, "LINE %3d ", lydisp);
  if (watch)
    {
      if (disprouterstats)
	{
	  if (localkey)
	    xoff = scrmid + 1;
	  mvprintw (6, xoff + 10, "ROUTER STATS BYTES");
	  mvprintw (8, xoff + 3, "Over 1 second period:");
	  mvprintw (13, xoff + 3, "Over 1 minute period:");
	  mvprintw (9, xoff + 3, " Incoming: %8lu", tfuse);
	  mvprintw (10, xoff + 3, " Outgoing: %8lu", ttuse);
	  mvprintw (11, xoff + 3, " Total:    %8lu", ttotal);
	  mvprintw (11, xoff + 22, "(%5.1f kbps)", fuse);

	  if (statsonce)
	    {
	      mvprintw (14, xoff + 3, " Incoming: %8lu", minfuse);
	      mvprintw (15, xoff + 3, " Outgoing: %8lu", mintuse);
	      mvprintw (16, xoff + 3, " Total:    %8lu", use);
	    }
	  else
	    mvprintw (15, xoff + 3, " N/A");
	  if (maxburst > 1.0)
	    {
	      mvprintw (18, xoff + 3, " MAX. BURST:    %5.1f kbps", maxburst);
	      mvprintw (19, xoff + 3, " at %s", burst);
	    }
	}
      else if (selecthost)
	{
	  if (magnafull)
	    {
	      xoff = 1;
	      clrportion (6, xoff + 3, MLINES - 4, MCOLS - 3);
	    }
	  else
	    {
	      if (localkey)
		{
		  xoff = scrmid + 1;
		  clrportion (6, xoff + 3, MLINES - 4, MCOLS - 3);
		}
	      else
		{
		  xoff = 1;
		  clrportion (6, xoff + 3, MLINES - 4, scrmid - 3);
		}
	    }
	  mvprintw (6, xoff + 4, "TRACE %s", magnamatch);
	  mvprintw (7, xoff + 10, "Offset = %3d", magnaoffs);
	  if (magnafull)
	    {
	      if (magnacomhost == NULL)
		{
		  pc = (unsigned char *) magnaspot->othaddr;
		  mvprintw (7, MCOLS - 50, "Communicating with %u.%u.%u.%u",
			    pc[0], pc[1], pc[2], pc[3]);
		  mvprintw (6, MCOLS - 40, "SERVICES LOC %s",
		       servicenm (magnaspot->servicename, magnaspot->port));

		}
	      else
		{
		  mvprintw (7, MCOLS - 50, "Communicating with %s",
			    magnacomhost->name);
		  mvprintw (6, MCOLS - 40, "SERVICES LOC %s  REM %s",
			servicenm (magnaspot->servicename, magnaspot->port),
		  servicenm (magnacomhost->servicename, magnacomhost->port));

		}


	    }
	  dispsize = MLINES - 13;
	  if (dispsize>0)
          {
	  stmag = magnaphys - dispsize + 1;
          if (stmag<0) stmag += MAGNAMAX; 
	  for (ii = 0, ij = stmag; ii < dispsize; ii++)
	    {
	      displaybuf (magna[ij], 9 + ii, xoff + 2,ij);
	      ij++;
	      if (ij == MAGNAMAX)
		ij = 0;
	    }
          }

	}
    }
  orouterfrom = routerfrom;
  orouterto = routerto;
  refreshscr++;
  if (refreshscr > MAXREFRESH)
    {
      poschange = 1;
      refreshscr = 0;
    }
  if (printtospeclog)
    {
      if (localkey)
	{
	  refreshloc = TRUE;
	  refreshrem = FALSE;
	}
      else
	{
	  refreshrem = TRUE;
	  refreshloc = FALSE;
	}
    }
  if (poschange)
    {
      refreshloc = refreshrem = TRUE;
    }
  if (bluedie == 1)
    {
      refreshloc = refreshrem = TRUE;
      bluedie += 2;
    }
  if (ignoredomain == 1)
    {
      refreshrem = TRUE;
      ignoredomain += 2;
    }
  if (magnafull)
    {
      localbypass = remotebypass = TRUE;
    }
  if (refreshloc && !localbypass)
    clrportion (4, 1, MLINES - 1, scrmid);
  if (refreshrem && !remotebypass)
    clrportion (4, scrmid + 1, MLINES - 1, MCOLS - 1);
  if (!magnafull && (selectchange || refreshloc || refreshrem))
    {
      cleancol (xright - 1, 4, MLINES - 2);
      if (selectside)
	mvaddch (numselect + 4, xright - 1, ACS_LARROW);
      else
	mvaddch (numselect + 4, xright - 1, ACS_RARROW);
    }
/* Construct the List of HEAVY HITTERS for 2 minute periods */
  if (dotop||topupdate)
  {
	dotop = FALSE;
	toplocal = &tldummy;
	toplocal->tflink = toplocal;
	current = lfirst->flink;
	while (current!=lfirst)
	{
		if (current->tstamp>colred)
			addtlist(current,toplocal);
		current->timelastbytes = current->timebytes;
		current->timebytes = 0;
		current = current->flink;
	}		
	topremote = &trdummy;
	topremote->tflink = topremote;
	current = rfirst->flink;
	while (current!=rfirst)
	{
		if (current->tstamp>colred)
			addtlist(current,topremote);
		current->timelastbytes = current->timebytes;
		current->timebytes = 0;
		current = current->flink;
	}		

  }
  if (!localbypass && !llockout && (localupdate || refreshloc))
    {
      mvaddch (3, 0, ACS_VLINE);
      lcnt = 0;
      current = lfirst->flink;
      pwork = lfirst;
      if (topflag)
      {
	current = toplocal->tflink; 
        pwork = toplocal;
      }
      if (magnaspot == NULL)
	magnaspot = current;
      while (current != pwork)
	{
	  y = lcnt;
	  if ((current->tstamp < colgreen && bluedie))
	    {
	      if (topflag)
		current = current->tflink;
	      else
	        current = current->flink;
	      continue;
	    }
	  lcnt++;
	  yact = y - lydisp;
	  if (yact >= 0 && yact < MLINES - 5 || printtospeclog)
	    {
	      if (!printtospeclog)
		yact += 4;
	      if (refreshloc || updaterest || current->update)
		{
		  strncpy (thost, current->name, curshosttrim);
		  if (selectchange && selecthost && numselect + 4 == yact )
		    {
		      magnakey = *((u_int32_t *) current->addr);
		      strncpy (magnamatch, current->name, RESOLVE_MAX);
		      magnaspot = current;
		      magnacomhost = NULL;
		      magnacomkey = *((u_int32_t *) current->othaddr);
		      magnafirst = TRUE;
		      selectchange = FALSE;
		    }
		  thost[curshosttrim] = 0;
		  testt = current->tstamp;
		  if (testt > colred)
		    {
		      attron (col1);
		      if (current->telnet_in)
			attron (col5);
		      if (current->update == 3)
			{
			  ttp = current->badmac;
			  sprintf (ttt, "IP %s with BAD MAC = %02x:%02x:%02x:%02x:%02x:%02x",
				   thost,
			    ttp[0], ttp[1], ttp[2], ttp[3], ttp[4], ttp[5]);
			  mvprintw (MLINES - 1, 2, ttt);
			  attron (col5);
			}
		    }
		  else
		    {
		      current->telnet_in = 0;
		      if (testt > colyel)
			attron (col2);
		      else if (testt > colgreen)
			attron (col3);
		      else
			attron (col4);
		    }
		  switch (dispopt)
		    {
		    case DISP_TX_RC:
		      sprintf (ttt, "%*s %6ld %6ld", -curshosttrim - 1, thost,
			       current->pktcntsend, current->pktcntrec);
		      break;
		    case DISP_INTTXRCP:
		      sprintf (ttt, "%*s %6ld %6ld", -curshosttrim - 1, thost,
			     current->intpktcntsend, current->intpktcntrec);
		      break;
		    case DISP_EXTTXRCP:
		      sprintf (ttt, "%*s %6ld %6ld", -curshosttrim - 1, thost,
			     current->extpktcntsend, current->extpktcntrec);
		      break;
		    case DISP_IPPROTO:
		      thost[cursproto] = 0;

		      sprintf (ttt, "%*s %8s %10s   ", -cursproto, thost,
			    current->ip_pr, servicenm (current->servicename,
						       current->port));
		      break;
		    case DISP_IPPROTON:
		      thost[cursdest] = 0;

		      sprintf (ttt, "%*s %8s %5d   ", -cursdest, thost,
			       current->ip_pr, current->port);
		      break;
		    case DISP_DEST1:
		      pc = (unsigned char *) current->othaddr;
		      thost[cursdest] = 0;
		      sprintf (ttt, "%*s %u.%u.%u.%u        ", -cursdest, thost,
			       pc[0], pc[1], pc[2], pc[3]);
		      break;
		    case DISP_DEST2:
		      pc = (unsigned char *) current->othaddr;
		      makeaddr (current->addr, thost);
		      thost[cursdest] = 0;
		      sprintf (ttt, "%*s %u.%u.%u.%u        ", -cursdest, thost,
			       pc[0], pc[1], pc[2], pc[3]);
		      break;
		    case DISP_ACCT:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %10lu %10lu", -cursproto, thost,
			       current->sendbytes, current->recbytes);
		      break;
		    case DISP_EXTTXRC:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %10lu %10lu", -cursproto, thost,
			       current->extsendbytes, current->extrecbytes);
		      break;
		    case DISP_INTTXRC:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %10lu %10lu", -cursproto, thost,
			       current->intsendbytes, current->intrecbytes);
		      break;
		    case DISP_MAC:
		      thost[cursproto] = 0;
		      ttp = current->mac;
		      sprintf (ttt, "%*s %02x:%02x:%02x:%02x:%02x:%02x", -cursproto, thost,
			    ttp[0], ttp[1], ttp[2], ttp[3], ttp[4], ttp[5]);
		      break;
		    case DISP_BADMAC:
		      thost[cursproto] = 0;
		      ttp = current->badmac;
		      sprintf (ttt, "%*s %02x:%02x:%02x:%02x:%02x:%02x", -cursproto, thost,
			    ttp[0], ttp[1], ttp[2], ttp[3], ttp[4], ttp[5]);
		      break;
		    case DISP_SERVER:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %-25s", -cursproto, thost,
			       current->server);
		      break;
		    case DISP_FTPSERVER:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %-25s", -cursproto, thost,
			       current->ftpserver);
		      break;
		    case DISP_LASTINTERVAL:
		      thost[cursdest] = 0;
		      sprintf (ttt, "%*s %15lu", -cursdest, thost,
			       current->timelastbytes);
		      break;
		    case DISP_LASTLIVEINT:
		      thost[cursdest] = 0;
		      sprintf (ttt, "%*s %15lu", -cursdest, thost,
			       current->timebytes);
		      break;
		    case DISP_LASTGET:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %-25s", -cursproto, thost,
			       current->lastget);
		      break;
		    }
		  ttt[scrmid - 2] = 0;
		  if (printtospeclog && speclog)
		    fprintf (fpspeclog, "%s\n", ttt);
		  else
		    mvprintw (yact, xleft, ttt);
		  attron (col4);
		  if (current->update)
		    {
		      if (current->update == 1)
			updaterest = 1;
		      current->update = 0;
		    }
		}
	    }
	  else
	    {
	      if (yact < 0)
		mvaddch (3, 0, ACS_UARROW);
	      else
		mvaddch (3, 0, ACS_DARROW);
	    }
	  if (topflag)
		current = current->tflink;
	  else
	  	current = current->flink;
	}

      localupdate = 0;
    }
  if (!remotebypass && !rlockout && (remoteupdate || refreshrem))
    {
      mvaddch (3, MCOLS - 1, ACS_VLINE);
      rcnt = 0;
      current = rfirst->flink;
      pwork = rfirst;
      if (topflag)
      {
	current = topremote->tflink;
	pwork = topremote;
      }
      if (magnaspot == NULL)
	magnaspot = current;
      while (current !=  pwork)
	{
	  y = rcnt;
	  tmpservice = current->servicename;
	  if (!tmpservice)
	    tmpservice = emptystr;
	  if ((current->tstamp < colgreen && bluedie) ||
	      (ignoredomain && !strcmp (tmpservice, "domain")))
	    {
		if (topflag)
			current = current->tflink;
		else
	      		current = current->flink;
	      continue;
	    }
	  rcnt++;
	  yact = y - rydisp;
	  if ((yact >= 0 && yact < MLINES - 5) || printtospeclog)
	    {
	      if (!printtospeclog)
		yact += 4;
	      if (refreshrem || updaterest || current->update)
		{
		  strncpy (thost, current->name, curshosttrim);
		  if (selectchange && selecthost && numselect + 4 == yact)
		    {
		      magnakey = *((u_int32_t *) current->addr);
		      strncpy (magnamatch, current->name, RESOLVE_MAX);
		      magnaspot = current;
		      magnacomhost = NULL;
		      magnacomkey = *((u_int32_t *) current->othaddr);
		      magnafirst = TRUE;
		      selectchange = FALSE;
		    }
		  thost[curshosttrim] = 0;
		  testt = current->tstamp;
		  if (testt > colred)
		    {
		      attron (col1);
		      if (current->telnet_in)
			attron (col5);
		      if (current->update == 3)
			{
			  ttp = current->badmac;
			  sprintf (ttt, "IP %s with BAD MAC = %02x:%02x:%02x:%02x:%02x:%02x",
				   thost,
			    ttp[0], ttp[1], ttp[2], ttp[3], ttp[4], ttp[5]);
			  if (printtospeclog && speclog)
			    fprintf (fpspeclog, "%s\n", ttt);
			  else
			    mvprintw (MLINES - 1, 2, ttt);
			  attron (col5);
			}
		    }
		  else
		    {
		      current->telnet_in = 0;
		      if (testt > colyel)
			attron (col2);
		      else if (testt > colgreen)
			attron (col3);
		      else
			attron (col4);
		    }
		  switch (dispopt)
		    {
		    case DISP_TX_RC:
		    case DISP_INTTXRCP:
		    case DISP_EXTTXRCP:
		      sprintf (ttt, "%*s %6ld %6ld", -curshosttrim - 1, thost,
			       current->pktcntsend, current->pktcntrec);
		      break;
		    case DISP_IPPROTO:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %8s %10s   ", -cursproto, thost,
			    current->ip_pr, servicenm (current->servicename,
						       current->port));
		      break;
		    case DISP_IPPROTON:
		      thost[cursdest] = 0;

		      sprintf (ttt, "%*s %8s %5d   ", -cursdest, thost,
			       current->ip_pr, current->port);
		      break;
		    case DISP_DEST1:
		      pc = (unsigned char *) current->othaddr;
		      thost[cursdest] = 0;
		      sprintf (ttt, "%*s %u.%u.%u.%u        ", -cursdest, thost,
			       pc[0], pc[1], pc[2], pc[3]);
		      break;
		    case DISP_DEST2:
		      pc = (unsigned char *) current->othaddr;
		      makeaddr (current->addr, thost);
		      thost[cursdest] = 0;
		      sprintf (ttt, "%*s %u.%u.%u.%u        ", -cursdest, thost,
			       pc[0], pc[1], pc[2], pc[3]);
		      break;
		    case DISP_ACCT:
		    case DISP_EXTTXRC:
		    case DISP_INTTXRC:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %10lu %10lu", -cursproto, thost,
			       current->sendbytes, current->recbytes);
		      break;
		    case DISP_MAC:
		      thost[cursproto] = 0;
		      ttp = current->mac;
		      sprintf (ttt, "%*s %02x:%02x:%02x:%02x:%02x:%02x", -cursproto, thost,
			    ttp[0], ttp[1], ttp[2], ttp[3], ttp[4], ttp[5]);
		      break;
		    case DISP_BADMAC:
		      thost[cursproto] = 0;
		      ttp = current->badmac;
		      sprintf (ttt, "%*s %02x:%02x:%02x:%02x:%02x:%02x", -cursproto, thost,
			    ttp[0], ttp[1], ttp[2], ttp[3], ttp[4], ttp[5]);
		      break;
		    case DISP_SERVER:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %-25s", -cursproto, thost,
			       current->server);
		      break;
		    case DISP_FTPSERVER:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %-25s", -cursproto, thost,
			       current->ftpserver);
		      break;
		    case DISP_LASTINTERVAL:
		      thost[cursdest] = 0;
		      sprintf (ttt, "%*s %15lu", -cursdest, thost,
			       current->timelastbytes);
		      break;
		    case DISP_LASTLIVEINT:
		      thost[cursdest] = 0;
		      sprintf (ttt, "%*s %15lu", -cursdest, thost,
			       current->timebytes);
		      break;
		    case DISP_LASTGET:
		      thost[cursproto] = 0;
		      sprintf (ttt, "%*s %-25s", -cursproto, thost,
			       current->lastget);
		      break;
		    }
		  ttt[scrmid - 2] = 0;
		  if (printtospeclog)
		    fprintf (fpspeclog, "%s\n", ttt);
		  else
		    mvprintw (yact, xright, ttt);
		  attron (col4);
		  if (current->update)
		    {
		      if (current->update == 1)
			updaterest = 1;
		      current->update = 0;
		    }
		}
	    }
	  else
	    {
	      if (yact < 0)
		mvaddch (3, MCOLS - 1, ACS_UARROW);
	      else
		mvaddch (3, MCOLS - 1, ACS_DARROW);
	    }
	  if (topflag)
		current = current->tflink;
	  else
	  	current = current->flink;
	}
      remoteupdate = 0;
    }
  poschange = 0;
  refresh ();
  if (printtospeclog && speclog && !llockout && !rlockout)
    {
      printtospeclog = FALSE;
      fclose (fpspeclog);
      speclogext++;
      sprintf (ttt, "%s.%03d", speclogfile, speclogext);
      fpspeclog = fopen (ttt, "w");
    }
}
