/*
$Id$
*/  

/* XPM */
static const char * black_xpm[] = {
"32 32 2 1",
" 	c None",
".	c #020202",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................",
"................................"};

/* XPM */
static const char * red_xpm[] = {
"32 32 6 1",
" 	c None",
".	c #EE0928",
"+	c #EF0928",
"@	c #EE0A29",
"#	c #EE0B2A",
"$	c #ED0C2B",
"........................+.......",
".+.++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++.+++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
"+++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++.+++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++.+++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++@",
".+++++++++++++++++++++++++++++.#",
".+++++++++++++++++++++++++.+++.$",
".+++++++++++++++++++++++++++++#$",
".+++++++++++++++++++++++++++++.#",
".+++++++++++++++++++++++++++++.#",
".++++++++.+++++++++++++++++++++@",
".++++++.+++++++++++++++++++++++.",
".++++++++++++++++++++++++++++++.",
"..........+.............+......."};


#include "editor.h"

#include <qtextedit.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qaction.h>

Editor::Editor() 
    : QMainWindow( 0, "main window")
{
    QActionGroup * colors = new QActionGroup( this, "colors", TRUE );

    QAction * setBlackFont = new QAction( "black", QPixmap( (const char**)black_xpm ),
                                          "Font color: black", CTRL+Key_B,
                                          colors, "blackfontcolor", TRUE );
    setRedFont = new QAction( "red", QPixmap( (const char**)red_xpm ), "Font color: red",
                              CTRL+Key_R, colors, "redfontcolor", TRUE );

    QObject::connect( colors, SIGNAL( selected( QAction * ) ),
                      this, SLOT( setFontColor( QAction * ) ) );

    QToolBar * toolbar = new QToolBar( this, "toolbar" );
    colors->addTo( toolbar );

    QPopupMenu * font = new QPopupMenu( this );
    menuBar()->insertItem( "&Font", font );

    colors->setUsesDropDown( TRUE );
    colors->setMenuText( "Font Color" );

    colors->addTo( font );

    editor = new QTextEdit( this, "editor" );
    setCentralWidget( editor );
}


void Editor::setFontColor( QAction * coloraction )
{
    if ( coloraction == setRedFont )
	editor->setColor( red );
    else
	editor->setColor( black );
}
