/* $Id: generate_xml_textflow.cpp,v 1.5 1999/10/20 10:24:57 kulow Exp $
 *
 * This file is part of MIFParse, a MIF parser for Unix.
 *
 * Copyright (C) 1998 by Matthias Kalle Dalheimer <kalle@dalheimer.de>
 */

#include "generate_xml_textflow.h"
#include "generate_xml_para.h"
#include "treebuild_textflow.h"
#include "treebuild_para.h"

#include <algorithm>
#include <fstream>

extern ofstream xmloutstr;

class generate_xml_textflow_element
{
public:
	static void generate( const TextFlowElement* tfe );
	static void out_begin();
	static void out_end();
};

void generate_xml_textflow::generate( const TextFlow* tf )
{
	generate_xml_textflow_element::out_begin();
	QListIterator<TextFlowElement> tfei( *tf->elements() );
	TextFlowElement* tfe = tfei.current();
	while( tfe ) {
		++tfei;
		generate_xml_textflow_element::generate( tfe );
		tfe = tfei.current();
	}
	generate_xml_textflow_element::out_end();
}


void generate_xml_textflow_element::generate( const TextFlowElement* tfe )
{
	switch( tfe->type() ) {
	case TextFlowElement::T_Para: {
		Para* para = tfe->para();
		generate_xml_para_element::out_begin();
		QListIterator<ParaElement> pei( *para->elements() );
		ParaElement* pe = pei.current();
		while( pe ) {
			++pei;
			generate_xml_para_element::generate( pe );
			pe = pei.current();
		}
		generate_xml_para_element::out_end();
		break;
	}
	default:
		cerr << "Unsupported TextFlowElement type\n";
	};
}


void generate_xml_textflow_element::out_begin()
{
	// PENDING(kalle) Adjust attributes
	xmloutstr << "  <FRAMESET frameType=\"1\" autoCreateNewFrame=\"1\">" << endl;
}

void generate_xml_textflow_element::out_end()
{
	xmloutstr << "  </FRAMESET>" << endl;
}
