/***************************************************************************
                          kscribbleview.cpp  -  description
                             -------------------
    begin                : Mon Jan 31 11:05:05 CET 2000
    copyright            : (C) 2000 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream.h>

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qdir.h>
#include <qsize.h>
#include <qclipboard.h>
#include <qimage.h>
#include <qdragobject.h>

// include files for KDE
#include <kiconloader.h>

// application specific includes
#include "kscribbleview.h"
#include "kscribbledoc.h"
#include "kscribble.h"


KScribbleView::KScribbleView(KScribbleDoc* pDoc, QWidget *parent, const char* name, int wflags)
 : QScrollView(parent, name, wflags | WPaintClever | WNorthWestGravity | WRepaintNoErase)
{
  cb = QApplication::clipboard();
  viewport()->setAcceptDrops(true);
  setDragAutoScroll(true);
  doc=pDoc;
	action=IDLE;
	viewport()->setCursor( Qt::crossCursor );
  QSize size=doc->docSize();
  resizeContents(size.width(), size.height());
  resize(size);
}

KScribbleView::~KScribbleView()
{
}

KScribbleDoc *KScribbleView::getDocument() const
{
	return doc;
}

void KScribbleView::update(KScribbleView* pSender){
	if(pSender != this)
    viewport()->repaint(0,0,visibleWidth(), visibleHeight(), false);
}

void KScribbleView::print(QPrinter *pPrinter)
{
  if (pPrinter->setup(this))
  {
		QPainter p;
		p.begin(pPrinter);
	  	
		///////////////////////////////
		// TODO: add your printing code here
		p.drawPixmap(0,0,doc->buffer);
		///////////////////////////////
		p.end();
  }
}

/** cuts out a selection */
void KScribbleView::cutSelection(){
  select=select.normalize();
  QPixmap cb_pix;
  cb_pix.resize(select.size());
  // copy selection to cb_pix and copy to clipboard
  bitBlt(&cb_pix, 0, 0, &doc->buffer, select.x()+contentsX(),  select.y()+contentsY(), cb_pix.width(), cb_pix.height());
  cb->setPixmap(cb_pix);
  // fill cb_pix with white and copy to selection area
  cb_pix.fill(Qt::white);
  bitBlt(&doc->buffer, select.x()+contentsX(), select.y()+contentsY(), &cb_pix, 0, 0, cb_pix.width(), cb_pix.height());
  action = IDLE;
  doc->setModified();
  doc->updateAllViews(this);
  viewport()->repaint(0,0,visibleWidth(), visibleHeight(), false);
}
/** copies a selection to the clipboard */
void KScribbleView::copySelection(){
  select=select.normalize();
  QPixmap cb_pix;
  cb_pix.resize(select.size());
  // copy selection to cb_pix and copy to clipboard
  bitBlt(&cb_pix, 0, 0, &doc->buffer, select.x()+contentsX(),  select.y()+contentsY(),cb_pix.width(), cb_pix.height());
  cb->setPixmap(cb_pix);
  action = IDLE;
  viewport()->repaint(0,0,visibleWidth(), visibleHeight(), false);
}
/** pastes the clipboard contents to a selection that can be inserted into the picture */
void KScribbleView::pasteSelection(){
  select=cb->pixmap().rect();
  action = PASTE;
  viewport()->setCursor( Qt::sizeAllCursor );
}

void KScribbleView::closeEvent(QCloseEvent* e){

// DO NOT CALL QWidget::closeEvent(e) here !!
// This will accept the closing by QCloseEvent::accept() by default.
// The installed eventFilter() in KScribbleApp takes care for closing the widget
// or ignoring the close event
		
}

void KScribbleView::keyPressEvent( QKeyEvent *e )
{
  switch (e->key())
  {
    case Key_Right:
	    scrollBy( 10, 0 );
	    break;
    case Key_Left:
	    scrollBy( -10,0);
	    break;
    case Key_Up:
	    scrollBy( 0, -10 );
	    break;
    case Key_Down:
	    scrollBy( 0, 10 );
	    break;
    case Key_Home:
	    setContentsPos(0,0);
	    break;
    case Key_End:
	    setContentsPos(0,viewport()->height()-viewport()->height());
	    break;
    case Key_PageUp:
	    scrollBy( 0, -viewport()->height() );
	    break;
    case Key_PageDown:
	    scrollBy( 0, viewport()->height() );
	    break;
  }

}

void KScribbleView::viewportMousePressEvent( QMouseEvent *e )
{
  if ( e->button() == LeftButton && action == IDLE)
  {
    action=DRAW;
    doc->polyline[2] = doc->polyline[1] = doc->polyline[0] = viewportToContents(e->pos());
    doc->updateAllViews(this);
  }
  else if ( e->button() == RightButton && action == IDLE)
  {
    action = SELECT;
    QPoint pt=e->pos();
    int x = pt.x() > contentsWidth() ? contentsWidth() : pt.x();
    int y = pt.y() > contentsHeight() ? contentsHeight() : pt.y();
    select.setLeft(x-1);
    select.setTop(y-1);
    select.setRight(x-1);
    select.setBottom(y-1);
  }
  else if( action == SELECT )
  {
    action = IDLE;
    select=select.normalize();
    // drag
    if(select.contains(e->pos(), true)) // point inside the selection
    {
      tmp.resize(select.size());
      bitBlt(&tmp, 0, 0, &doc->buffer, select.x()+contentsX(),  select.y()+contentsY(), tmp.width(), tmp.height());
      QImage img =tmp.convertToImage();
      QDragObject *d = new QImageDrag( img, viewport() );
      d->setPixmap(BarIcon("filenew"));
      d->drag();
    }
    // remove selection
    else
      viewport()->repaint(0,0,visibleWidth(), visibleHeight(), false);
  }
  else if( action == PASTE )
  {
    if ( e->button() == RightButton )
    {
      action = IDLE;
      viewport()->setCursor( Qt::crossCursor );
    }
  	QPoint mv_pt (viewport()->height(), viewport()->width());
    if(QRect(0,0,mv_pt.x(),mv_pt.y()).contains(e->pos()))
      select.moveCenter(e->pos());
  	else
  	{
  	  select.moveBottomRight(mv_pt);
  	}
    viewport()->repaint(0,0,visibleWidth(), visibleHeight(), false);
  }
}

void KScribbleView::viewportMouseReleaseEvent( QMouseEvent *e )
{
  if ( action == DRAW )
  {
    action = IDLE;
    doc->updateAllViews(this);
  }
  if ( action == SELECT)
  {
    QPoint pt=e->pos();
    int x = pt.x() > 0 ? pt.x() : 0;
    int y = pt.y() > 0 ? pt.y() : 0;
    select.setRight(x);
    select.setBottom(y);
    QSize size=doc->docSize();
    select = select.intersect(QRect(0,0,size.width(), size.height()));	
  }
}

/** On paste actions inserts the pasted clipboard contents
 */
void KScribbleView::viewportMouseDoubleClickEvent(QMouseEvent* e)
{
  if( action == PASTE )
  {
    action = IDLE;
    select.moveCenter(e->pos());
  	viewport()->setCursor( Qt::crossCursor );
    QPixmap cb_pix;
    cb_pix.resize(cb->pixmap().size());
    cb_pix=cb->pixmap();
	  bitBlt( &doc->buffer, contentsX()+select.x(), contentsY()+select.y(), &cb_pix, 0,0 , select.width(),select.height() );
    viewport()->repaint(0,0,visibleWidth(), visibleHeight(), false);
	  doc->setModified();
	  doc->updateAllViews(this);
  }

}

void KScribbleView::viewportMouseMoveEvent( QMouseEvent *e )
{
  if ( action == DRAW )
  {		
    QPainter painter;
    painter.begin( &doc->buffer );
    painter.setPen( doc->currentPen() );
    doc->polyline[2] = doc->polyline[1];
    doc->polyline[1] = doc->polyline[0];
    doc->polyline[0] = viewportToContents(e->pos());
    painter.drawPolyline( doc->polyline );
    painter.end();

    QRect r = doc->polyline.boundingRect();
    r = r.normalize();
    r.setLeft( r.left() - doc->penWidth() );
    r.setTop( r.top() - doc->penWidth() );
    r.setRight( r.right() + doc->penWidth() );
    r.setBottom( r.bottom() + doc->penWidth() );

    bitBlt(viewport(), r.x()-contentsX(), r.y()-contentsY() , &doc->buffer, r.x(), r.y(), r.width(), r.height() );
	  doc->setModified();
	  doc->updateAllViews(this);
  }
  if ( action == SELECT )
  {
    QPoint pt=e->pos();
    select.setWidth(select.x()+pt.x());
    select.setHeight(select.y()+pt.y());
    select.setRight(pt.x());
    select.setBottom(pt.y());
    QSize size=doc->docSize();
    select = select.intersect(QRect(0,0,size.width(), size.height()));	
    viewport()->repaint(0,0,visibleWidth(), visibleHeight(), false);
  }
  if( action == PASTE )
  {
  	QPoint mv_pt (viewport()->height(), viewport()->width());
    if(QRect(0,0,mv_pt.x(),mv_pt.y()).contains(e->pos()))
      select.moveCenter(e->pos());
  	else
  	{
  	  select.moveBottomRight(mv_pt);
  	}
    QRect pm_rect=cb->pixmap().rect();
    select.setWidth(pm_rect.width());
    select.setHeight(pm_rect.height());
    QSize size=doc->docSize();
    select = select.intersect(QRect(0,0,size.width(), size.height()));	
    viewport()->repaint(0,0,visibleWidth(), visibleHeight(), false);
	  doc->setModified();
	  doc->updateAllViews(this);
  }
}

//void KScribbleView::viewportResizeEvent( QResizeEvent *e )
//{
//}

void KScribbleView::viewportPaintEvent( QPaintEvent *e )
{
  bitBlt( viewport(),0,0, &doc->buffer,contentsX() ,contentsY() );

  if( action == PASTE )
  {
    tmp.resize(cb->pixmap().size());
    tmp=cb->pixmap();
  }
  if( action == PASTE || action == DRAG )
  {
    QSize size=doc->docSize();
    select = select.intersect(QRect(0,0,size.width(), size.height()));	
    if(select.intersects(e->rect()))
      bitBlt(viewport(), select.x(), select.y(), &tmp, 0, 0, select.width(), select.height());
  }
  if( action == PASTE || action == DRAG || action == SELECT )
  {
//    if(select.intersects(e->rect()))
//    {
      QPainter paint_area;
      paint_area.begin(viewport());
    	paint_area.setPen(QPen(Qt::black, 0, DashLine));
      paint_area.drawRect( select );
      paint_area.end();
//    }
  }
  QScrollView::viewportPaintEvent(e);
}

void  KScribbleView::viewportDragEnterEvent ( QDragEnterEvent * e)
{
  e->accept(QImageDrag::canDecode(e));
  action = DRAG;
}

void  KScribbleView::viewportDragMoveEvent ( QDragMoveEvent * e)
{
  QImage img;
  if ( QImageDrag::decode(e, img) ){
    tmp.resize(img.size());
    tmp.convertFromImage(img);
    select.setWidth(tmp.width());
    select.setHeight(tmp.height());
    select.moveCenter(e->pos());
    viewport()->repaint(0,0,visibleWidth(), visibleHeight(), false);
  }
}

void  KScribbleView::viewportDragLeaveEvent ( QDragLeaveEvent * )
{
  action = IDLE;
  viewport()->repaint(0,0,visibleWidth(), visibleHeight(), false);
}

void  KScribbleView::viewportDropEvent ( QDropEvent * e)
{
  QImage img;
  if ( QImageDrag::decode(e, img) )
  {
    tmp.resize(img.size());
    tmp.convertFromImage(img);
    select.setWidth(tmp.width());
    select.setHeight(tmp.height());
    select.moveCenter(e->pos());
    bitBlt(&doc->buffer, select.x()+contentsX(), select.y()+contentsY(), &tmp, 0, 0, tmp.width(), tmp.height());
    doc->setModified();
    doc->updateAllViews(this);
  }
  action = IDLE;
    viewport()->repaint(0,0,visibleWidth(), visibleHeight(), false);
}
