/*
 * kfortunewindow.h
 *
 * Copyright (c) 2001 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef KFORTUNEWINDOW_H
#define KFORTUNEWINDOW_H

#include <qstring.h>

#include <dcopobject.h>
#include <kmainwindow.h>
#include "prefs.h"

class QGroupBox;
class QHBoxLayout;
class QPushButton;
class QVBoxLayout;

class KFortuneView;
class KProcess;

class KFortuneWindow : public KMainWindow, virtual public DCOPObject
{
	K_DCOP
	Q_OBJECT

	public:
		KFortuneWindow();
		virtual ~KFortuneWindow();
	
	k_dcop:
		void nextFortune();
		QString currentFortune() const;

	private slots:
		void newFortune();
		void saveFortune();
		void copyFortune();
		void setFortune(const QString &fortune);
		void preferences();

		void receivedStdout(KProcess *process, char *data, int len);
		void processExited(KProcess *process);
		void slotSavePrefs();
		
	private:
		void setupActions();

		KFortuneView *m_view;
		QString m_fortuneText;
		prefs *m_prefsView;
};

#endif // KFORTUNEWINDOW_H
// vim:ts=4:sw=4:noet
