/*
 * kfortuneview.cpp
 *
 * Copyright (c) 2001 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#include "kfortuneview.h"

#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qwidget.h>

#include <kdialog.h>
#include <klocale.h>

KFortuneView::KFortuneView(QWidget *parent) : QWidget(parent, "kfortuneview")
{
	m_layout = new QGridLayout(this);
	m_layout->setSpacing(KDialog::spacingHint());
	m_layout->setMargin(KDialog::marginHint());

	m_groupBox = new QGroupBox(i18n("Your fortune for today:"), this, "m_groupBox");
	m_groupBox->setColumnLayout(0, Qt::Vertical);
	m_groupBox->layout()->setMargin(16);

	m_fortune = new QLabel(QString::null, m_groupBox, "m_fortune");
	QFont font("courier", 12);
	m_fortune->setFont(font);
	m_groupBox->layout()->add(m_fortune);

	m_layout->addMultiCellWidget(m_groupBox, 0, 0, 0, 2);

	QSpacerItem *spacer = new QSpacerItem(1, 1, QSizePolicy::Expanding, QSizePolicy::Minimum);
	m_layout->addItem(spacer, 1, 0);

	m_bNewFortune = new QPushButton(i18n("&New Fortune"), this, "m_bNewFortune");
	connect(m_bNewFortune, SIGNAL(clicked()), this, SIGNAL(newFortuneClicked()));
	m_layout->addWidget(m_bNewFortune, 1, 1);
	
	m_bClose = new QPushButton(i18n("&Close"), this, "m_bClose");
	connect(m_bClose, SIGNAL(clicked()), this, SIGNAL(closeClicked()));
	m_layout->addWidget(m_bClose, 1, 2);
}

KFortuneView::~KFortuneView()
{
}

QString KFortuneView::fortune() const
{
	return m_fortune->text();
}

void KFortuneView::setFortune(const QString &fortune)
{
	m_fortune->setText(fortune);
}

#include "kfortuneview.moc"
// vim:ts=4:sw=4:noet
