#include "field.h"
#include "field.moc"

#include <qwhatsthis.h>

#include <klocale.h>

#include "base/defines.h"
#include "base/board.h"


KSField::KSField(QWidget *parent)
    : Field(parent)
{
    QWhatsThis::add(showRemoved, i18n("Display the number of lines removed "
                                      "simultaneously."));
    for (uint i=0; i<4; i++) {
        showRemoved->append(new LCD(5, showRemoved));
        showRemoved->lcd(i)->setLeadString(QString::number(i+1));
    }

    connect(board, SIGNAL(removedLinesUpdated(uint, uint)),
            SLOT(removedLinesUpdated(uint, uint)));
}

void KSField::removedLinesUpdated(uint i, uint removed)
{
    Q_ASSERT( i<4 );
    showRemoved->lcd(i)->showValue(removed);
    if (removed) showRemoved->lcd(i)->highlight();
}
