#include "ai.h"
#include "ai.moc"

#include <klocale.h>

#include "board.h"


KSAI::KSAI(uint thinkTime, uint orderTime)
: AI(thinkTime, orderTime)
{
    addElement(new AIElement("occupied lines",
                             I18N_NOOP("Number of occupied lines"),
                             -2, -100, 0, 0, 0, 0, nbOccupiedLines));
    addElement(new AIElement("peak-to-peak",I18N_NOOP("Peak-to-peak distance"),
                             -2, -100, 0, 0, 0, 0, peakToPeak));
    addElement(new AIElement("holes", I18N_NOOP("Number of holes"),
                             -4, -100, 0, 0, 0, 0, nbHoles));
    addElement(new AIElement("mean height", I18N_NOOP("Mean height"),
                             0, -100, 0, 0, 0, 0, mean));
    addElement(new AIElement("spaces",
                           I18N_NOOP("Number of spaces\n(under mean height)"),
                           -2, -100, 0, 0, 0, 0, nbSpaces));
    addElement(new AIElement("full lines", I18N_NOOP("Number of full lines"),
                             50, 0, 100, 1, 1, 4, nbRemoved));
}
