/***************************************************************************
                            KPanelApplet.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPANELAPPLET_H
#define KPANELAPPLET_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QFrame.h>

/**

 Implement a panel applet.

 Panel applets

 Note: For security and stability reasons the panel won't load
 untrusted third party applets directly into its namespace but via an
 external wrapper process.

 The panel locates available applets by searching for applet desktop
 files in (ALL_KDEDIRS)/share/apps/kicker/applets. Every panel applet should
 install a desktop file there to be recognised by the panel.

 Besides standard keys like "Name", "Comment" and "Icon" there are
 two panel applet specific keys:

 Used by the panel to locate the applet DSO (Dynamic Shared Object)
 Example: X-KDE-Library=libexampleapplet

 Similar to @ref KApplication and @ref KUniqueApplication there are
 two types of panel applets. Use unique applets when it makes no
 sence to run more than one instance of a applet in the panel. A
 good example for unique applets is the taskbar applet.  Use normal
 applets when you need instance specific configuration. An example
 is the koolclock applet where you might want to run two instances
 in your panel, one configured as analog clock, the other one as
 digital clock. X-KDE-UniqueApplet is a boolean key which defaults
 to "false".  Example: X-KDE-UniqueApplet=true

 Back to panel applet DSOs, the following conventions are used for KDE:
 Name:    lib<appletname>applet.la
 LDFLAGS: -module -no-undefined

 To implement a panel applet it is not enough to write a class
 inheriting from KPanelApplet but you also have to provide a
 factory function in your DSO.  A sample factory function could look
 like this:

 <pre>

 extern "C"
 {
     KPanelApplet* init(QWidget *parent, const QString& configFile)
     {
         -[KGlobal locale]->insertCatalogue("exampleapplet");
         return new ExampleApplet(configFile, -[KPanelApplet Normal],
                       -[KPanelApplet About]| -[KPanelApplet Help]| -[KPanelApplet Preferences],
                       parent, "exampleapplet");
     }
 }

 </pre>

 Note: Don't change the factory function signature or the panel will
 fail to load your applet.

 @author Matthias Elter <elter@kde.org>

 @short KDE Panel Applet class.
*/

@class KConfig;

@interface KPanelApplet : QFrame 

/** 
 Constructs a KPanelApplet just like any other widget.

*/
- initWithText: (NSString *)configFile t: (int)t actions: (int)actions parent: (QWidget *)parent name: (NSString *)name f: (int)f;
- initWithText: (NSString *)configFile ;

/** 
 Destructor.

*/
- (void) dealloc;

/** 
 Returns a suggested width for a given height.

 Every applet should reimplement this function.

 Depending on the panel orientation the height (horizontal panel) or the
 width (vertical panel) of the applets is fixed.
 The exact values of the fixed size component depend on the panel size.

 On a horizontal panel the applet height is fixed, the panel will
 call @ref widthForHeight(int height) with @p height
 equal to 'the fixed applet height'
 when laying out the applets.

 The applet can now choose the other size component (width)
 based on the given height.

 The width you return is granted.

*/
- (int) widthForHeight: (int)height;

/** 

 Every applet should reimplement this function.

 Depending on the panel orientation the height (horizontal panel) or the
 width (vertical panel) of the applets is fixed.
 The exact values of the fixed size component depend on the panel size.

 On a vertical panel the applet width is fixed, the panel will
 call @ref heightForWidth(int width) with @p width
 equal to 'the fixed applet width'
 when layint out the applets.

 The applet can now choose the other size component (height)
 based on the given width.

 The height you return is granted.

*/
- (int) heightForWidth: (int)width;

/** 
 Always use this @ref KConfig object to save/load your applets configuration.

 For unique applets this config object will write to a config file called
 <appletname>rc in the users local KDE directory.

 For normal applets this config object will write to a instance specific config file
 called <appletname><instanceid>rc in the users local KDE directory.

*/
- (KConfig*) config;

/** 

*/
- (int) type;

/** 

*/
- (int) actions;

/** 
 Generic action dispatcher. Called  when the user selects an item
 from the applets RMB menu.

 Reimplement this function to handle actions.

 For About, Help, Preferences and ReportBug, use the convenience handlers
 ref -about, -help, -preferences, -reportBug

*/
- action: (int)a;

/** 

*/
- setPosition: (int)p;

/** 

*/
- setAlignment: (int)a;

/** 
 Is called when the user selects "About" from the applet's RMB menu.
 Reimplement this function to launch a about dialog.

 Note that this is called only when your applet supports the About action.
 See @ref Action and -KPanelApplet.

*/
- about;

/** 
 Is called when the user selects "Help" from the applet's RMB menu.
 Reimplement this function to launch a manual or help page.

 Note that this is called only when your applet supports the Help action.
 See @ref Action and -KPanelApplet.

*/
- help;

/** 
 Is called when the user selects "Preferences" from the applet's RMB menu.
 Reimplement this function to launch a preferences dialog or kcontrol module.

 Note that this is called only when your applet supports the preferences action.
 See @ref Action and -KPanelApplet.

*/
- preferences;

/** 
 Is called when the user selects "Report bug" from the applet's RMB menu.
 Reimplement this function to launch a bug reporting dialog.

 Note that this is called only when your applet supports the ReportBug
 action.
 See @ref Action and -KPanelApplet

*/
- reportBug;

/** 

*/
- (int) orientation;

/** 

*/
- (int) position;

/** 

*/
- (int) alignment;

/** 
 The panel on which this applet resides has changed its position.
 Reimplement this change handler in order to adjust the look of your
 applet.

*/
- positionChange: (int)p;

/** 
 The panel on which this applet resides has changed its alignment.
 Reimplement this change handler in order to adjust the look of your
 applet.

*/
- alignmentChange: (int)a;

/** 
 The orientation changed to @p orientation. Reimplement this
 change handler in order to adjust the look of your applet.

*/
- orientationChange: (int)arg1;

/** 
 You may need this if you want to popup menus at the right position.

 See @ref  -popupDirectionChange

*/
- (int) popupDirection;

/** 
 The popup direction changed to @p direction. Reimplement this
 change handler in order to adjust the look of your applet.

*/
- popupDirectionChange: (int)arg1;
- virtual_hook: (int)identifier data: (void*)data;
+ (int) Normal;
+ (int) Stretch;
+ (int) About;
+ (int) Help;
+ (int) Preferences;
+ (int) ReportBug;
+ (int) pLeft;
+ (int) pRight;
+ (int) pTop;
+ (int) pBottom;
+ (int) LeftTop;
+ (int) Center;
+ (int) RightBottom;
+ (int) Up;
+ (int) Down;
+ (int) Left;
+ (int) Right;
@end

/** Override these methods in subclasses of KPanelApplet to customise event handling behaviour */
@protocol KPanelAppletEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
