/***************************************************************************
                            KDEsuClient.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDESUCLIENT_H
#define KDESUCLIENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 A client class to access kdesud, the KDE su daemon. Kdesud can assist in 
 password caching in two ways:

 @short 
 A client class to access kdesud, the KDE su daemon.
*/
@class QCStringList; 

@interface  KDEsuClient : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- (void) dealloc;

/** 
 Lets kdesud execute a command. If the daemon does not have a password
 for this command, this will fail and you need to call @ref  #--setPass.

*/
- (int) exec: (NSString *)command user: (NSString *)user options: (NSString *)options env: (QCStringList*)env;
- (int) exec: (NSString *)command user: (NSString *)user ;

/** 
 Set root's password, lasts one session.

*/
- (int) setPass: (NSString *)pass timeout: (int)timeout;

/** 
 Set the target host (optional).
     
*/
- (int) setHost: (NSString *)host;

/** 
 Set the desired priority (optional), see @ref  #-StubProcess.
     
*/
- (int) setPriority: (int)priority;

/** 
 Set the desired scheduler (optional), see @ref  #-StubProcess.
     
*/
- (int) setScheduler: (int)scheduler;

/** 
 Remove a password for a user/command.

*/
- (int) delCommand: (NSString *)command user: (NSString *)user;

/** 
 Set a persistent variable.

*/
- (int) setVar: (NSString *)key value: (NSString *)value timeout: (int)timeout group: (NSString *)group;
- (int) setVar: (NSString *)key value: (NSString *)value ;

/** 
 Get a persistent variable.

*/
- (NSString *) getVar: (NSString *)key;

/** 
 Returns true if the specified group exists is
 cached.

*/
- (BOOL) findGroup: (NSString *)group;

/** 
 Delete a persistent variable.

*/
- (int) delVar: (NSString *)key;

/** 
 Delete all persistent variables with the given key.

 A specicalized variant of @ref delVar(QCString) that removes all
 subsets of the cached varaibles given by @p key. In order for all
 cached variables related to this key to be deleted properly, the
 value given to the @p group argument when the @ref setVar function
 was called, must be a subset of the argument given here and the key

 <u>NOTE:</u> Simply supplying the group key here WILL not necessarily
 work. If you only have a group key, then use @ref delGroup instead.

*/
- (int) delVars: (NSString *)special_key;

/** 
 Delete all persistent variables in a group.

*/
- (int) delGroup: (NSString *)group;

/** 
 Ping kdesud. This can be used for diagnostics.

*/
- (int) ping;

/**  Stop the daemon.  
*/
- (int) stopServer;

/**  Try to start up kdesud 
*/
- (int) startServer;

/**  Returns true if the server is safe (installed setgid), false otherwise. 
*/
- (BOOL) isServerSGID;
@end

#endif
