/***************************************************************************
                            KURLRequesterDlg.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Dialog in which a user can enter a filename or url. It is a dialog
 encapsulating {@link KURLRequester}. The API is derived from
 {@link KFileDialog}.

 See {@link KURLRequesterDlgSignals} for signals emitted by KURLRequesterDlg.

 See {@link KURLRequesterDlgEventHandling} for event handlers to override in subclasses of KURLRequesterDlg.

 @author Wilco Greven <j.w.greven@student.utwente.nl>
 
 @short Simple dialog to enter a filename/url.

*/
public class KURLRequesterDlg extends KDialogBase  {
	protected KURLRequesterDlg(Class dummy){super((Class) null);}

	private native void newKURLRequesterDlg( String url, QWidget parent, String name, boolean modal);

/** 
 Constructs a KURLRequesterDlg.

*/
	public KURLRequesterDlg( String url, QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKURLRequesterDlg( url, parent, name, modal);
	}
	private native void newKURLRequesterDlg( String url, QWidget parent, String name);
	public KURLRequesterDlg( String url, QWidget parent, String name) {
		super((Class) null);
		newKURLRequesterDlg( url, parent, name);
	}
	private native void newKURLRequesterDlg( String url, String text, QWidget parent, String name, boolean modal);

/** 
 Constructs a KURLRequesterDlg.

*/
	public KURLRequesterDlg( String url, String text, QWidget parent, String name, boolean modal) {
		super((Class) null);
		newKURLRequesterDlg( url, text, parent, name, modal);
	}
	private native void newKURLRequesterDlg( String url, String text, QWidget parent, String name);
	public KURLRequesterDlg( String url, String text, QWidget parent, String name) {
		super((Class) null);
		newKURLRequesterDlg( url, text, parent, name);
	}

/** 
 Destructs the dialog.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns the fully qualified filename.
     
*/
	public native KURL selectedURL();

/** 
 Returns a pointer to the file dialog used by the KURLRequester.
     
*/
	public native KFileDialog fileDialog();

/** 
 Returns a pointer to the KURLRequester.
     
*/
	public native KURLRequester urlRequester();

/** 
 Creates a modal dialog, executes it and returns the selected URL.

*/
	public static native KURL getURL( String url, QWidget parent, String caption);
	public static native KURL getURL();
}
