package org.kde.koala;
import org.kde.qt.*;


/** {@link KToolBar} emits these signals */
public interface KToolBarSignals {

/** 
 Emitted when toolbar changes position, or when
 an item is removed from toolbar.

 If you subclass {@link KMainWindow} and reimplement
 {@link KMainWindow#resizeEvent} be sure to connect to
 this signal. Note: You can connect this signal to a slot that
 doesn't take parameter.
     
*/
	void moved( int arg1 );
	void destroyed( QObject obj );

/** 

*/
	void highlightSetting();
	void orientationChanged( int o );

/** 
 Emitted when a toggle button changes state.

 Emitted also if you change state
 with {@link KToolBar#setButton} or {@link KToolBar#toggleButton}
 If you make a button normal again, with
 setToggle(false), this signal won't
 be emitted.
     
*/
	void toggled( int arg1 );

/** 
 Emitted when button <code>id</code> is pressed.
     
*/
	void pressed( int arg1 );

/** 
 This signal is emitted when item id gets highlighted/unhighlighted
 (i.e when mouse enters/exits).

 Note that this signal is emitted from
 all buttons (normal, disabled and toggle) even when there is no visible
 change in buttons (i.e., buttons do not raise when mouse enters).
     
*/
	void highlighted( int identifier );
	void visibilityChanged( boolean arg1 );

/** 
 Emitted when button <code>id</code> is clicked.
     
*/
	void clicked( int identifier );
	void placeChanged( int p );

/** 
 Emits when button <code>id</code> is released.
     
*/
	void released( int arg1 );

/** 

*/
	void transparentSetting();

/** 
 Emitted when button <code>id</code> is double-clicked.

 Note: you will always
 recive two {@link KToolBar#clicked} , {@link KToolBar#pressed} and {@link KToolBar#released} signals.
 There is no way to avoid it - at least no easy way.
 If you need to resolve this all you can do is set up timers
 which wait for {@link QApplication#doubleClickInterval} to expire.
 If in that time you don't get this signal, you may belive that
 button was only clicked and not double-clicked.
 And please note that butons with popup menus do not emit this signal,
 but those with delayed popup do.
     
*/
	void doubleClicked( int identifier );

/** 

 This signal is emited when toolbar detects changing of
 following parameters:
 highlighting, button-size, button-mode. This signal is
 internal, aimed to buttons.
     
*/
	void modechange();

/** 

*/
	void iconTextSetting();
}

