/***************************************************************************
                            KSpellConfig.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A configuration class/dialog for {@link KSpell}.

 It contains all of the options settings.The options are set to default
 values by the constructor and can be reset either by using the 
 public interface or by using KSpellConfig as a widget in a dialog 
 (or, preferably a tabbed dialog using {@link KDialogBase}) and letting 
 the user change the settings. This way an application that uses 
 {@link KSpell} can either rely on the default settings (in the simplest 
 case), offer a dialog to configure {@link KSpell}, or offer a dialog to 
 configure {@link KSpell} _for_this_app_only_ (in which case, the application 
 should save the settings for use next time it is run).
 This last option might be useful in an email program, for example, where
 people may be writing in a language different from that used for
 writing papers in their word processor.

 See {@link KSpellConfigSignals} for signals emitted by KSpellConfig.

 See {@link KSpellConfigEventHandling} for event handlers to override in subclasses of KSpellConfig.

 @author David Sweet <dsweet@kde.org>

 @version $Id: KSpellConfig.java,v 1.6 2002/01/31 04:49:01 rdale Exp $

 @short 
 A configuration class/dialog for @ref KSpell.
*/
public class KSpellConfig extends QWidget  {
	protected KSpellConfig(Class dummy){super((Class) null);}

	private native void newKSpellConfig( QWidget parent, String name, KSpellConfig spellConfig, boolean addHelpButton);

/** 
 Constructs a KSpellConfig with default or custom settings. 

     
*/
	public KSpellConfig( QWidget parent, String name, KSpellConfig spellConfig, boolean addHelpButton) {
		super((Class) null);
		newKSpellConfig( parent, name, spellConfig, addHelpButton);
	}
	private native void newKSpellConfig();
	public KSpellConfig() {
		super((Class) null);
		newKSpellConfig();
	}
	private native void newKSpellConfig( KSpellConfig arg1);
	public KSpellConfig( KSpellConfig arg1) {
		super((Class) null);
		newKSpellConfig( arg1);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 

 The <code>_ignorelist</code> contains words you'd like {@link KSpell}
 to ignore when it is spellchecking.  When you get a KSpellConfig
 object back from {@link #KSpell},
 the <code>_ignorelist</code> contains whatever was put in by you plus 
 any words the user has chosen to ignore via the dialog box.  
 It may be useful to save this list with the document being 
 edited to facilitate quicker future spellchecking.
     
*/
	public native void setIgnoreList( String[] _ignorelist);

/** 
 Set an ISpell option.

 If <code>true</code>, don't create root-affix combinations.
     
*/
	public native void setNoRootAffix( boolean arg1);

/** 
 Set an ISpell option.

 If <code>true</code>, treat run-together words a valid.
     
*/
	public native void setRunTogether( boolean arg1);

/** 
 Set the name of the dictionary to use.
     
*/
	public native void setDictionary( String qs);
	public native void setDictFromList( boolean dfl);

/** 

     
*/
	public native void setEncoding( int enctype);
	public native void setClient( int client);

/** 
 Options reading routines.
     
*/
	public native boolean noRootAffix();
	public native boolean runTogether();
	public native String dictionary();
	public native boolean dictFromList();
	public native int encoding();
	public native ArrayList ignoreList();
	public native int client();

/** 
 Call this method before this class is deleted  if you want 
 the settings you have (or the user has) chosen to become the 
 global, default settings.
     
*/
	public native boolean writeGlobalSettings();

/** 
 Use this function to activate the help information for this 
 widget. The function is particulary useful if the help button is
 not displayed as specified by the constructor. Normally you want
 to hide the help button if this widget is embedded into a larger
 dialog box that has its own help button. See kedit 
 (optiondialog.cpp) for an example 
     
*/
	public native void activateHelp();
	protected native void fillInDialog();
	protected native boolean readGlobalSettings();

/** 
 This takes a dictionary file name (fname) and returns a language 
 abbreviation (lname; like de for German), appropriate for the
 $LANG variable, and a human-readble name (hname; like "Deutsch").

 It also truncates ".aff" at the end of fname.

 TRUE is returned if lname.data()==$LANG
     
*/
	protected native boolean interpret( String fname, String lname, String hname);
	protected native void sHelp();
	protected native void sNoAff( boolean arg1);
	protected native void sRunTogether( boolean arg1);
	protected native void sDictionary( boolean arg1);
	protected native void sPathDictionary( boolean arg1);
	protected native void sSetDictionary( int arg1);
	protected native void sChangeEncoding( int arg1);
	protected native void sChangeClient( int arg1);
	public static final int rdictlist = 3;
	public static final int rencoding = 4;
	public static final int rhelp = 6;
}
