package org.kde.koala;
import org.kde.qt.*;


/** {@link KFontDialog} emits these signals */
public interface KFontDialogSignals {

/** 
 The User3 button was pressed. This signal is only emitted if
 {@link KFontDialog#slotUser3} is not replaced.
     
*/
	void user3Clicked();
	void destroyed( QObject obj );

/** 
 The Yes button was pressed. This signal is only emitted if
 {@link KFontDialog#slotYes} is not replaced.
     
*/
	void yesClicked();

/** 
 The Help button was pressed. This signal is only emitted if
 {@link KFontDialog#slotHelp} is not replaced.
     
*/
	void helpClicked();

/** 
 Emitted whenever the currently selected font changes.
 Connect to this to monitor the font as it is selected if you are
 not running modal.
   
*/
	void fontSelected( QFont font );

/** 
 The Apply button was pressed. This signal is only emitted if
 {@link KFontDialog#slotApply} is not replaced.
     
*/
	void applyClicked();

/** 
 The Default button was pressed. This signal is only emitted if
 {@link KFontDialog#slotDefault} is not replaced.
     
*/
	void defaultClicked();

/** 
 The Try button was pressed. This signal is only emitted if
 {@link KFontDialog#slotTry} is not replaced.
     
*/
	void tryClicked();

/** 
 The No button was pressed. This signal is only emitted if
 {@link KFontDialog#slotNo} is not replaced.
     
*/
	void noClicked();

/** 
 The detailsWidget is about to get shown. This is your last chance
 to call setDetailsWidget if you haven't done so yet.
     
*/
	void aboutToShowDetails();

/** 
 The Cancel button was pressed. This signal is only emitted if
 {@link KFontDialog#slotCancel} is not replaced.
     
*/
	void cancelClicked();

/** 
 Do not use this signal. Is is kept for compatibility reasons.
 Use {@link KFontDialog#applyClicked} instead.
     
*/
	void apply();

/** 
 The dialog has finished.

 A dialog emits finished after a user clicks a button that ends
 the dialog.

 This signal is also emitted when you call {@link KFontDialog#hide}

 If you have stored a pointer to the
 dialog do <em>not</em> try to delete the pointer in the slot that is
 connected to this signal.

 You should use {@link KFontDialog#delayedDestruct} instead.
     
*/
	void finished();

/** 
 The background tile has changed.
     
*/
	void backgroundChanged();

/** 
 The User1 button was pressed. This signal is only emitted if
 {@link KFontDialog#slotUser1} is not replaced.
     
*/
	void user1Clicked();

/** 
 Emitted when the margin size and/or spacing size 
 have changed.

 Use {@link KFontDialog#marginHint} and  {@link KFontDialog#spacingHint} in your slot
 to get the new values.
     
*/
	void layoutHintChanged();

/** 
 The Close button was pressed. This signal is only emitted if
 {@link KFontDialog#slotClose} is not replaced.
     
*/
	void closeClicked();

/** 
 The OK button was pressed. This signal is only emitted if
 {@link KFontDialog#slotOk} is not replaced.
     
*/
	void okClicked();

/** 
 The dialog is about to be hidden.

 A dialog is hidden after a user clicks a button that ends
 the dialog or when the user switches to another desktop or
 minimizes the dialog.
     
*/
	void hidden();

/** 
 The User2 button was pressed. This signal is only emitted if
 {@link KFontDialog#slotUser2} is not replaced.
     
*/
	void user2Clicked();

/** 
 A page is about to be shown.
     
*/
	void aboutToShowPage( QWidget page );
}

