/***************************************************************************
                            DocumentFragment.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 <code> DocumentFragment </code> is a "lightweight" or "minimal"
 <code> Document </code> object. It is very common to want to be
 able to extract a portion of a document's tree or to create a new
 fragment of a document. Imagine implementing a user command like
 cut or rearranging a document by moving fragments around. It is
 desirable to have an object which can hold such fragments and it is
 quite natural to use a Node for this purpose. While it is true that
 a <code> Document </code> object could fulfil this role, a <code>
 Document </code> object can potentially be a heavyweight object,
 depending on the underlying implementation. What is really needed
 for this is a very lightweight object. <code> DocumentFragment
 </code> is such an object.

  Furthermore, various operations -- such as inserting nodes as
 children of another <code> Node </code> -- may take <code>
 DocumentFragment </code> objects as arguments; this results in all
 the child nodes of the <code> DocumentFragment </code> being moved
 to the child list of this node.

  The children of a <code> DocumentFragment </code> node are zero or
 more nodes representing the tops of any sub-trees defining the
 structure of the document. <code> DocumentFragment </code> nodes do
 not need to be well-formed XML documents (although they do need to
 follow the rules imposed upon well-formed XML parsed entities,
 which can have multiple top nodes). For example, a <code>
 DocumentFragment </code> might have only one child and that child
 node could be a <code> Text </code> node. Such a structure model
 represents neither an HTML document nor a well-formed XML document.

  When a <code> DocumentFragment </code> is inserted into a <code>
 Document </code> (or indeed any other <code> Node </code> that may
 take children) the children of the <code> DocumentFragment </code>
 and not the <code> DocumentFragment </code> itself are inserted
 into the <code> Node </code> . This makes the <code>
 DocumentFragment </code> very useful when the user wishes to create
 nodes that are siblings; the <code> DocumentFragment </code> acts
 as the parent of these nodes so that the user can use the standard
 methods from the <code> Node </code> interface, such as <code>
 insertBefore() </code> and <code> appendChild() </code> .

 
 @short 
 <code> DocumentFragment </code> is a "lightweight" or "minimal"
 <code> Document </code> object.
*/
public class DocumentFragment extends DOMNode  {
	protected DocumentFragment(Class dummy){super((Class) null);}

	private native void newDocumentFragment();
	public DocumentFragment() {
		super((Class) null);
		newDocumentFragment();
	}
	private native void newDocumentFragment( DocumentFragment other);
	public DocumentFragment( DocumentFragment other) {
		super((Class) null);
		newDocumentFragment( other);
	}
	private native void newDocumentFragment( DOMNode other);
	public DocumentFragment( DOMNode other) {
		super((Class) null);
		newDocumentFragment( other);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
}
