/***************************************************************************
                            kde_KShred.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSHRED
#define KDE_KSHRED

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Erase a file in a way that makes recovery impossible -- well, no guarentee
 of that, but at least as difficult as reasonably possible.
 For this, KShred write several times over the
 existing file, using different patterns, before deleting it.

 @author David Faure <faure@kde.org> (integration into KDE and progress signal)
 
 @short 
 Erase a file in a way that makes recovery impossible -- well, no guarentee
 of that, but at least as difficult as reasonably possible.
*/

/** 
 Initialize the class using the name of the file to 'shred'.

*/
kde_KShred * kde_new_KShred(qt_QString * fileName);
void kde_del_KShred( kde_KShred* p );

/** 
 Writes all 1's over the entire file and flushes the file buffers.

*/
int kde_KShred_fill1s(kde_KShred* instPointer);

/** 
 Writes all 0's over the entire file and flushes the file buffers.

*/
int kde_KShred_fill0s(kde_KShred* instPointer);

/** 
 Writes the specified byte over the entire file and flushes the file buffers.

*/
int kde_KShred_fillbyte(kde_KShred* instPointer,unsigned int byte);

/** 
 Writes random bites over the entire file and flushes the file buffers.

*/
int kde_KShred_fillrandom(kde_KShred* instPointer);

/** 
 Writes the specified byte array over the entire file and flushes the file buffers.

*/
int kde_KShred_fillpattern(kde_KShred* instPointer,unsigned char* pattern, unsigned int size);

/** 
 Shreds a file by writing a series of values over it (uses @ref 
 fill0s, then @ref fill1s, then @ref fillrandom, then @ref fillbyte
 with 0101..., then @ref fillbyte with 1010....

*/
int kde_KShred_shred(kde_KShred* instPointer);

/** 
 The simplest method to shred a file.
 No need to create an instance of the class.

*/
int kde_KShred_shred1( qt_QString * fileName);

#endif
