/***************************************************************************
                            kde_KServiceGroup.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSERVICEGROUP
#define KDE_KSERVICEGROUP

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 This class is typically used like this: 

 // Lookup screensaver group
 KServiceGroup::Ptr group = KServiceGroup::baseGroup("screensavers");
 if (!group || !group->isValid()) return;

 KServiceGroup::List list = group->entries();

 // Iterate over all entries in the group
 for( KServiceGroup::List::ConstIterator it = list.begin();
      it != list.end(); it++)
 {
    KSycocaEntry *p = (*it);
    if (p->isType(KST_KService))
    {
       KService *s = static_cast<KService *>(p);
       printf("Name = %s\n", s->name().latin1());
    }
    else if (p->isType(KST_KServiceGroup))
    {
       KServiceGroup *g = static_cast<KServiceGroup *>(p);
       // Sub group ...
    }
 }
 
 @short 
 This class is typically used like this: 

*/

/** 
 Construct a service and take all informations from a config file

*/
kde_KServiceGroup * kde_new_KServiceGroup(qt_QString * _fullpath, qt_QString * _relpath);

/** 

 The stream must already be positionned at the correct offset
   
*/
kde_KServiceGroup * kde_new_KServiceGroup1(qt_QDataStream * _str, int offset, int deep);
void kde_del_KServiceGroup( kde_KServiceGroup* p );

/** 

*/
int kde_KServiceGroup_isValid(kde_KServiceGroup* instPointer);

/** 
 Name used for indexing.
   
*/
qt_QString * kde_KServiceGroup_name(kde_KServiceGroup* instPointer);
qt_QString * kde_KServiceGroup_relPath(kde_KServiceGroup* instPointer);

/** 

*/
qt_QString * kde_KServiceGroup_caption(kde_KServiceGroup* instPointer);

/** 

*/
qt_QString * kde_KServiceGroup_icon(kde_KServiceGroup* instPointer);

/** 

*/
qt_QString * kde_KServiceGroup_comment(kde_KServiceGroup* instPointer);

/** 

*/
int kde_KServiceGroup_childCount(kde_KServiceGroup* instPointer);

/** 

 Load the service from a stream.
   
*/
void kde_KServiceGroup_load(kde_KServiceGroup* instPointer,qt_QDataStream * arg1);

/** 

 Save the service to a stream.
   
*/
void kde_KServiceGroup_save(kde_KServiceGroup* instPointer,qt_QDataStream * arg1);

/** 
 List of all Services and ServiceGroups within this
 ServiceGroup

*/
//kde_List kde_KServiceGroup_entries(kde_KServiceGroup* instPointer,int sorted, int excludeNoDisplay);

/** 
 As above with excludeNoDisplay true.
   
*/
//kde_List kde_KServiceGroup_entries1(kde_KServiceGroup* instPointer,int sorted);

/** 

 The base group is defined by the X-KDE-BaseGroup key
 in the .directory file.
   
*/
qt_QString * kde_KServiceGroup_baseGroupName(kde_KServiceGroup* instPointer);

/** 

*/
void * kde_KServiceGroup_baseGroup( qt_QString * baseGroupName);
void * kde_KServiceGroup_root( );
void * kde_KServiceGroup_group( qt_QString * relPath);

/** 

 Add a service to this group
   
*/
void kde_KServiceGroup_addEntry(kde_KServiceGroup* instPointer,kde_KSycocaEntry* entry);

#endif
