/***************************************************************************
                            kde_KSaveFile.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSAVEFILE
#define KDE_KSAVEFILE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 The KSaveFile class has been made to write out changes to an existing
 file atomically.
 This means that EITHER:
 a)
   All changes have been written successfully to the file.

 b)
   Some error occured, no changes have been written whatsoever and the
   old file is still in place.
 
 @short 
 The KSaveFile class has been made to write out changes to an existing
 file atomically.
*/
kde_KSaveFile * kde_new_KSaveFile(qt_QString * filename, int mode);

/** 
 The destructor closes the file.

*/
void kde_del_KSaveFile( kde_KSaveFile* p );

/** 
 Returns the status of the file based on errno. (see errno.h)
 0 means OK.

 You should check the status after object creation to check
 whether a file could be created in the first place.

 You may check the status after closing the file to verify that
 the file has indeed been written correctly.

*/
int kde_KSaveFile_status(kde_KSaveFile* instPointer);

/** 
 The name of the file as passed to the constructor.

*/
qt_QString * kde_KSaveFile_name(kde_KSaveFile* instPointer);

/** 
 An integer file descriptor open for writing to the file.

*/
int kde_KSaveFile_handle(kde_KSaveFile* instPointer);

/** 
 A FILE* stream open for writing to the file.

*/
//FILE* kde_KSaveFile_fstream(kde_KSaveFile* instPointer);

/** 
 A QFile* open for writing to the file.

*/
qt_QFile* kde_KSaveFile_file(kde_KSaveFile* instPointer);

/** 
 A QTextStream* open for writing to the file.

*/
qt_QTextStream* kde_KSaveFile_textStream(kde_KSaveFile* instPointer);

/** 
 A QDataStream* open for writing to the file.

*/
qt_QDataStream* kde_KSaveFile_dataStream(kde_KSaveFile* instPointer);

/** 
 Aborts the write operation and removes any intermediate files
 This implies a close.

*/
void kde_KSaveFile_abort(kde_KSaveFile* instPointer);

/** 
 Closes the file and makes the changes definitive.
 Returns 'true' is successful, or 'false' if an error has occured.
 See status() for details about errors.

*/
int kde_KSaveFile_close(kde_KSaveFile* instPointer);

#endif
