#ifndef KBEROFTPD_H
#define KBEROFTPD_H

#include "ftpaccess.h"
#include "UserClasses.h"
#include "Directories.h"
#include "Security.h"
#include "Messages.h"
#include "Logging.h"
#include "Ratios.h"
#include "Uploads.h"
#include "Virtual.h"
#include <kapp.h>
#include <kmainwindow.h>
#include <klocale.h>
#include <qtabwidget.h>

class kwuftpd : public KMainWindow {
			Q_OBJECT
public:
			kwuftpd();
			~kwuftpd();
public slots:
	void		handleMenu(int);
signals:
	void		ftpaccessLoaded(ftpaccess *xs);
	void		aboutToSave();
protected:
	void		init();
private:
	ftpaccess	*ftpxs;
	KMenuBar	*menu;
	QPopupMenu	*file;
	QPopupMenu	*help;
	QTabWidget	*ktc;
	UserClasses	*ClassesTab;
	Directories	*DirectoriesTab;
	Security	*SecurityTab;
	Messages	*MessagesTab;
	Logging		*LoggingTab;
	Ratios		*RatiosTab;
	Uploads		*UploadsTab;
	Virtual		*VirtualTab;
};

// Menu items
#define	ID_FILE_LOADFTPACCESS	1
#define ID_FILE_LOADOTHER	2
#define ID_FILE_SAVEFTPACCESS	3
#define ID_FILE_SAVEOTHER	4
#define ID_FILE_QUIT		5

#endif
