/*  Stolen and multilated from XMMS 1.2.1
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "common.h"
#include "dirbrowser.h"

static char *folder[] =
{
	"16 16 8 1",
	" 	c None",
	".	c #909000",
	"+	c #000000",
	"@	c #EFE8EF",
	"#	c #FFF8CF",
	"$	c #FFF890",
	"%	c #CFC860",
	"&	c #FFC890",
	"                ",
	"  .....+        ",
	" .@##$$.+       ",
	".%%%%%%%......  ",
	".###########$%+ ",
	".#$$$$$$$$$$&%+ ",
	".#$$$$$$$&$&$%+ ",
	".#$$$$$$$$&$&%+ ",
	".#$$$$$&$&$&$%+ ",
	".#$$$$$$&$&$&%+ ",
	".#$$$&$&$&$&&%+ ",
	".#&$&$&$&$&&&%+ ",
	".%%%%%%%%%%%%%+ ",
	" ++++++++++++++ ",
	"                ",
	"                "};

/* XPM */
static char *ofolder[] =
{
	"16 16 12 1",
	" 	c None",
	".	c #808080",
	"+	c #E0E0D0",
	"@	c #4F484F",
	"#	c #909000",
	"$	c #FFF8EF",
	"%	c #CFC860",
	"&	c #003090",
	"*	c #7F7800",
	"=	c #FFC890",
	"-	c #FFF890",
	";	c #2F3000",
	"        .       ",
	"       .+@      ",
	"   ###.$$+@     ",
	"  #%%.$$$$+@    ",
	"  #%.$$$&$$+@** ",
	"  #.+++&+&+++@* ",
	"############++@ ",
	"#$$$$$$$$$=%#++@",
	"#$-------=-=#+; ",
	" #---=--=-==%#; ",
	" #-----=-=-==#; ",
	" #-=--=-=-=-=#; ",
	"  #=-=-=-=-==#; ",
	"  ############; ",
	"   ;;;;;;;;;;;  ",
	"                "};

static GdkPixmap *folder_pixmap = NULL, *ofolder_pixmap;
static GdkBitmap *folder_mask, *ofolder_mask;

typedef struct
{
	gboolean scanned;
	gchar *path;
}
DirNode;

static gboolean check_for_subdir(gchar * path)
{
	DIR *dir;
	struct dirent *dirent;
	struct stat statbuf;
	gchar *npath;

	if ((dir = opendir(path)) != NULL)
	{
		while ((dirent = readdir(dir)) != NULL)
		{
			if (dirent->d_name[0] != '.')
			{
				npath = g_strconcat(path, dirent->d_name, NULL);
				if (stat(npath, &statbuf) != -1 && S_ISDIR(statbuf.st_mode))
				{
					g_free(npath);
					closedir(dir);
					return TRUE;
				}
				g_free(npath);
			}
		}
		closedir(dir);
	}
	return FALSE;
}

static void destroy_cb(gpointer data)
{
	DirNode *node = data;

	g_free(node->path);
	g_free(node);
}

static void expand_cb(GtkWidget * widget, GtkCTreeNode * parent_node)
{
	DIR *dir;
	struct dirent *dirent;
	gchar *path, *text, *dummy = "dummy";
	struct stat statbuf;
	GtkCTreeNode *node, *sub_node;
	DirNode *parent_dirnode, *dirnode;
	gboolean has_subdir = FALSE;

	parent_dirnode = gtk_ctree_node_get_row_data(GTK_CTREE(widget), parent_node);
	if (!parent_dirnode->scanned)
	{
		gtk_clist_freeze(GTK_CLIST(widget));
		node = gtk_ctree_find_by_row_data(GTK_CTREE(widget), parent_node, NULL);
		gtk_ctree_remove_node(GTK_CTREE(widget), node);
		if ((dir = opendir(parent_dirnode->path)) != NULL)
		{
			while ((dirent = readdir(dir)) != NULL)
			{
				path = g_strconcat(parent_dirnode->path, dirent->d_name, NULL);
				if (stat(path, &statbuf) != -1 && S_ISDIR(statbuf.st_mode) && dirent->d_name[0] != '.')
				{
					dirnode = g_malloc0(sizeof (DirNode));
					dirnode->path = g_strconcat(path, "/", NULL);
					text = dirent->d_name;
					if (check_for_subdir(dirnode->path))
						has_subdir = TRUE;
					else
						has_subdir = FALSE;
					node = gtk_ctree_insert_node(GTK_CTREE(widget), parent_node, NULL, &text, 4, folder_pixmap, folder_mask, ofolder_pixmap, ofolder_mask, !has_subdir, FALSE);
					gtk_ctree_node_set_row_data_full(GTK_CTREE(widget), node, dirnode, destroy_cb);
					if (has_subdir)
						sub_node = gtk_ctree_insert_node(GTK_CTREE(widget), node, NULL, &dummy, 4, NULL, NULL, NULL, NULL, FALSE, FALSE);
				}
				g_free(path);
			}
			closedir(dir);
			gtk_ctree_sort_node(GTK_CTREE(widget), parent_node);
		}
		gtk_clist_thaw(GTK_CLIST(widget));
		parent_dirnode->scanned = TRUE;
	}
}

static void select_row_cb(GtkWidget * widget, gint row, gint column, GdkEventButton * bevent, gpointer data)
{
	DirNode *dirnode;
	GtkCTreeNode *node;
	void (*handler) (gchar *, gpointer);

	if (bevent)
	{
		if (bevent->type == GDK_2BUTTON_PRESS)
		{
			node = gtk_ctree_node_nth(GTK_CTREE(widget), row);
			dirnode = gtk_ctree_node_get_row_data(GTK_CTREE(widget), node);
			handler = (void (*)(gchar *, gpointer)) gtk_object_get_data(GTK_OBJECT(widget), "handler");
			if (handler)
				handler(dirnode->path, gtk_object_get_data(GTK_OBJECT(widget), "user_data"));
		}
	}

}

static void ok_clicked(GtkWidget * widget, GtkWidget * tree)
{
	GtkCTreeNode *node;
	DirNode *dirnode;
	GList *list_node;
	GtkWidget *window;
	void (*handler) (gchar *, gpointer);

	window = gtk_object_get_user_data(GTK_OBJECT(widget));
	gtk_widget_hide(window);
	list_node = GTK_CLIST(tree)->selection;
	while (list_node)
	{
		node = list_node->data;
		dirnode = gtk_ctree_node_get_row_data(GTK_CTREE(tree), node);
		handler = (void (*)(gchar *, gpointer)) gtk_object_get_data(GTK_OBJECT(tree), "handler");
		if (handler)
			handler(dirnode->path, gtk_object_get_data(GTK_OBJECT(tree), "user_data"));
		list_node = g_list_next(list_node);
	}
	gtk_widget_destroy(window);

}

GtkWidget *create_dir_browser(gchar * title, void (*handler) (gchar *, gpointer), gpointer user_data)
{
	GtkWidget *window, *scroll_win, *tree, *vbox, *bbox, *ok, *cancel,
	         *sep;
 char *root_text = "/", *node_text = "dummy";
	GtkCTreeNode *root_node, *node;
	DirNode *dirnode;

	window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(window), title);
	gtk_container_border_width(GTK_CONTAINER(window), 10);

	vbox = gtk_vbox_new(FALSE, 10);
	gtk_container_add(GTK_CONTAINER(window), vbox);

	scroll_win = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll_win), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize(scroll_win, 250, 200);
	gtk_box_pack_start(GTK_BOX(vbox), scroll_win, TRUE, TRUE, 0);
	gtk_widget_show(scroll_win);

	gtk_widget_realize(window);
	if (!folder_pixmap)
	{
		folder_pixmap = gdk_pixmap_create_from_xpm_d(window->window, &folder_mask, NULL, folder);
		ofolder_pixmap = gdk_pixmap_create_from_xpm_d(window->window, &ofolder_mask, NULL, ofolder);
	}

	tree = gtk_ctree_new(1, 0);
	gtk_clist_set_column_auto_resize(GTK_CLIST(tree), 0, TRUE);
	gtk_clist_set_selection_mode(GTK_CLIST(tree), GTK_SELECTION_SINGLE);
	gtk_ctree_set_line_style(GTK_CTREE(tree), GTK_CTREE_LINES_DOTTED);
	gtk_signal_connect(GTK_OBJECT(tree), "tree_expand", GTK_SIGNAL_FUNC(expand_cb), NULL);
	gtk_signal_connect(GTK_OBJECT(tree), "select_row", GTK_SIGNAL_FUNC(select_row_cb), NULL);
	gtk_container_add(GTK_CONTAINER(scroll_win), tree);
	gtk_object_set_data(GTK_OBJECT(tree), "handler", (gpointer) handler);
  gtk_object_set_data(GTK_OBJECT(tree), "user_data", (gpointer) user_data);

	root_node = gtk_ctree_insert_node(GTK_CTREE(tree), NULL, NULL, &root_text, 4, folder_pixmap, folder_mask, ofolder_pixmap, ofolder_mask, FALSE, FALSE);
	dirnode = g_malloc0(sizeof (DirNode));
	dirnode->path = g_strdup("/");
	gtk_ctree_node_set_row_data_full(GTK_CTREE(tree), root_node, dirnode, destroy_cb);
	node = gtk_ctree_insert_node(GTK_CTREE(tree), root_node, NULL, &node_text, 4, NULL, NULL, NULL, NULL, TRUE, TRUE);
	gtk_ctree_expand(GTK_CTREE(tree), root_node);
	gtk_widget_show(tree);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), sep, FALSE, FALSE, 0);
	gtk_widget_show(sep);

	bbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);

	ok = gtk_button_new_with_label(_("Ok"));
	gtk_object_set_user_data(GTK_OBJECT(ok), window);
	GTK_WIDGET_SET_FLAGS(ok, GTK_CAN_DEFAULT);
	gtk_window_set_default(GTK_WINDOW(window), ok);
	gtk_box_pack_start(GTK_BOX(bbox), ok, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(ok), "clicked", GTK_SIGNAL_FUNC(ok_clicked), tree);
	gtk_widget_show(ok);

	cancel = gtk_button_new_with_label(_("Cancel"));
	GTK_WIDGET_SET_FLAGS(cancel, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bbox), cancel, TRUE, TRUE, 0);
	gtk_signal_connect_object(GTK_OBJECT(cancel), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
	gtk_widget_show(cancel);

	gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);
	gtk_widget_show(bbox);
	gtk_widget_show(vbox);

	gtk_ctree_select(GTK_CTREE(tree), root_node);

	return window;
}

static int int_compare_func(const void *a, const void *b)
{
	if ((gint) a < (gint) b)
		return -1;
	if ((gint) a > (gint) b)
		return 1;
	else
		return 0;
}

static gboolean filebrowser_is_dir(GtkFileSelection * filesel)
{
	gchar *text;
	struct stat buf;
	
	text = g_strdup(gtk_file_selection_get_filename(filesel));
	g_strstrip(text);
	while ((text[strlen(text) - 1] == '/') &&
	       (strlen(text) > 1) && (text[strlen(text) - 2] == '/'))
	{
		text[strlen(text) - 1] = '\0';
	}

	if (stat(text, &buf) == 0)
	{
		if (S_ISDIR(buf.st_mode))
		{		/* Selected directory */
			gtk_file_selection_set_filename(filesel, text);
			g_free(text);
			return TRUE;
		}
	}
	g_free(text);
	return FALSE;
}

static void filebrowser_add_files(GtkFileSelection * filesel)
{
	GList *sel_list = NULL, *node;
	gchar *text, *text2, *text3;
	void (*handler)(gchar *, gpointer data);

	handler = gtk_object_get_data(GTK_OBJECT(filesel), "handler");

	text3 = g_strdup(gtk_file_selection_get_filename(filesel));
	if(!text3)
		return;
	
	text = strrchr(text3, '/');
	if (text)
		*(text + 1) = '\0';

	node = GTK_CLIST(filesel->file_list)->selection;
	while(node)
	{
		sel_list = g_list_prepend(sel_list, node->data);
		node = g_list_next(node);
	}
	sel_list = g_list_sort(sel_list, int_compare_func);

	node = sel_list;
	
	if (node)
	{
		while (node)
		{
			gtk_clist_get_text(GTK_CLIST(filesel->file_list), GPOINTER_TO_INT(node->data), 0, &text);
			text2 = g_strconcat(text3, text, NULL);

			handler(text2, gtk_object_get_data(GTK_OBJECT(filesel), "user_data"));
			g_free(text2);
			node = g_list_next(node);
		}
	}
	else
	{
		/*
		 * No files selected, but the user may have
		 * typed a filename.
		 */		
		text = gtk_file_selection_get_filename(filesel);
		if (text[strlen(text) - 1] != '/')
			handler(text, gtk_object_get_data(GTK_OBJECT(filesel), "user_data"));
	}
	g_list_free(sel_list);
	g_free(text3);
	gtk_file_selection_set_filename(GTK_FILE_SELECTION(filesel), "");
}

static void filebrowser_ok(GtkWidget * w, GtkWidget * filesel)
{
	if(!filebrowser_is_dir(GTK_FILE_SELECTION(filesel)))
	{
		gtk_widget_hide(filesel);
		filebrowser_add_files(GTK_FILE_SELECTION(filesel));
		gtk_widget_destroy(filesel);
	}
}

static void filebrowser_add_selected_files(GtkWidget * w, GtkWidget * filesel)
{
	filebrowser_add_files(GTK_FILE_SELECTION(filesel));
}

static void filebrowser_add_all_files(GtkWidget * w, GtkWidget * filesel)
{
	if(GTK_CLIST(GTK_FILE_SELECTION(filesel)->file_list)->row_list)
	{
		gtk_clist_freeze(GTK_CLIST(GTK_FILE_SELECTION(filesel)->file_list));
		gtk_clist_select_all(GTK_CLIST(GTK_FILE_SELECTION(filesel)->file_list));
		filebrowser_add_files(GTK_FILE_SELECTION(filesel));
		/*
		 * We want gtk_clist_undo_selection() but it is buggy in GTK+ 1.2.6
		 */
		/*  gtk_clist_undo_selection(GTK_CLIST(GTK_FILE_SELECTION(filesel)->file_list)); */
		gtk_clist_unselect_all(GTK_CLIST(GTK_FILE_SELECTION(filesel)->file_list));
		gtk_clist_thaw(GTK_CLIST(GTK_FILE_SELECTION(filesel)->file_list));
	}
}

GtkWidget * create_filebrowser( void (*callback)(gchar *, gpointer), gpointer data )
{
	GtkWidget *filebrowser, *bbox, *add_selected, *add_all, *label;

	filebrowser = gtk_file_selection_new(_("Send file(s)"));
		
	gtk_object_set_data(GTK_OBJECT(filebrowser), "handler", (gpointer)callback);
  gtk_object_set_data(GTK_OBJECT(filebrowser), "user_data", data);

	gtk_clist_set_selection_mode(GTK_CLIST(GTK_FILE_SELECTION(filebrowser)->file_list),
				     GTK_SELECTION_EXTENDED);
	gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(filebrowser)->ok_button),
			   "clicked", GTK_SIGNAL_FUNC(filebrowser_ok), filebrowser);
	gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(filebrowser)->cancel_button),
				  "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
				  GTK_OBJECT(filebrowser));

	bbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 0);
	gtk_box_pack_end(GTK_BOX(GTK_FILE_SELECTION(filebrowser)->action_area),
			 bbox, TRUE, TRUE, 0);
	add_selected  = gtk_button_new_with_label(_("Add selected files"));
	gtk_box_pack_start(GTK_BOX(bbox), add_selected, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(add_selected), "clicked",
			   GTK_SIGNAL_FUNC(filebrowser_add_selected_files), filebrowser);
	add_all = gtk_button_new_with_label(_("Add all files in directory"));
	gtk_box_pack_start(GTK_BOX(bbox), add_all, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(add_all), "clicked",
			   GTK_SIGNAL_FUNC(filebrowser_add_all_files), filebrowser);
	gtk_widget_show_all(bbox);

	/*
	 * This is ugly.
	 * Change the Cancel buttons caption to Close.
	 */
	label = gtk_label_new(_("Close"));
	gtk_misc_set_alignment(GTK_MISC(label), 0.5, 0.5);
	gtk_container_remove(GTK_CONTAINER(GTK_FILE_SELECTION(filebrowser)->cancel_button),
			     gtk_container_children(GTK_CONTAINER(GTK_FILE_SELECTION(filebrowser)->cancel_button))->data);
	gtk_container_add(GTK_CONTAINER(GTK_FILE_SELECTION(filebrowser)->cancel_button), label);
	gtk_widget_show(label);

	gtk_widget_show(filebrowser);
	return filebrowser;
}
