/********************************
 Chat peer to peer functions
 (c) 1999 Jeremy Wise
 (c) 2000 Olivier Crete
 GnomeICU
*********************************/

#include "common.h"
#include "chatdlg.h"
#include "events.h"
#include "gnomeicu.h"
#include "history.h"
#include "packetprint.h"
#include "rus_conv.h"
#include "tcp.h"
#include "util.h"

GtkWidget *chat_filesel;

GSList *Sessions;

void chat_save_got_name( GtkWidget *widget, ChatSession *csession );

void TCPChatHandshake(ChatSession *csession, int lsock, GdkInputCondition cond);
void TCPChatWaitForNewConnection(ChatContact *ccontact, int sock,
				GdkInputCondition cond);
void TCPChatWait3rdPak(ChatContact *ccontact, int sock, GdkInputCondition cond);
void TCPChatWaitForAck(ChatContact *ccontact, int sock, GdkInputCondition cond);
void TCPChatRead(ChatContact *ccontact, int sock, GdkInputCondition cond);



/* Global Functions */
int TCPAcceptChat(int sock, ChatContact *ccontact)
{
     BYTE *buffer;
     unsigned short intsize;
     unsigned short backport, tempport;
     /* This must be int, not socklen_t, breaks compilation otherwise */
     int length = sizeof(struct sockaddr);
     BYTE *ptr;

     typedef struct {
	  BYTE uin1[4];
	  BYTE version[2];
	  BYTE command[2];
	  BYTE zero[2];
	  BYTE uin2[4];
	  BYTE cmd[2];
	  BYTE message_length[2];
     } tcp_head;

     typedef struct {
	  BYTE ip[4];
	  BYTE ip_real[4];
	  BYTE porta[4];
	  BYTE junk;
	  BYTE status[2];
	  BYTE msgcommand[2];
	  BYTE session_len[2];
     } tcp_mid;

     typedef struct {
	  BYTE back_port[2];
	  BYTE zero[2];
	  BYTE portb[4];
	  BYTE seq[4];
     } tcp_tail;

     tcp_head pack_head;
     tcp_mid pack_mid;
     tcp_tail pack_tail;

     struct sockaddr_in my_addr;

     gint cx;
     gboolean have_tcp_port = FALSE;

#ifdef TRACE_FUNCTION
     g_print("TCPAcceptChat\n");
#endif

     if (ccontact->chatsession == NULL)
     {
	  ccontact->chatsession = g_malloc0(sizeof(ChatSession));
	  Sessions = g_slist_append(Sessions, ccontact->chatsession);
     }
	 

     if (ccontact->chatsession->listen_socket == 0)
     {
	  ccontact->chatsession->listen_socket = socket(AF_INET, SOCK_STREAM, 0);
	  if (ccontact->chatsession->listen_socket <= 0)
	       return FALSE;
	  
	  for (cx = min_tcp_port; cx <= max_tcp_port; cx++) {
	       my_addr.sin_family = AF_INET;
	       my_addr.sin_port = g_htons(cx);
	       my_addr.sin_addr.s_addr = g_htonl(INADDR_ANY);
	       memset(&(my_addr.sin_zero), 0x00, 8);
	       if (bind
		   (ccontact->chatsession->listen_socket, (struct sockaddr *) &my_addr,
		    sizeof(struct sockaddr)) != -1)
		    have_tcp_port = TRUE;
	       else
		    continue;
	       
	       break;
	  }
	  
	  if (have_tcp_port == FALSE)
	       return FALSE;

	  listen(ccontact->chatsession->listen_socket, 1);
	  ccontact->chatsession->gdk_input =
	       gdk_input_add(ccontact->chatsession->listen_socket, GDK_INPUT_READ,
			     (GdkInputFunction) TCPChatHandshake, ccontact->chatsession);
	  
	  getsockname(ccontact->chatsession->listen_socket, (struct sockaddr *) &my_addr, &length);
	  
	  ccontact->chatsession->listen_port = g_ntohs(my_addr.sin_port);
     }
     ccontact->chatsession->initiator = (void *) ccontact;

     tempport = ccontact->chatsession->listen_port;
     backport = (tempport >> 8) + (tempport << 8);

     DW_2_Chars(pack_head.uin1, our_info->uin);
     Word_2_Chars(pack_head.version, 0x0003);
     Word_2_Chars(pack_head.command, ICQ_CMDxTCP_ACK);
     Word_2_Chars(pack_head.zero, 0x0000);
     DW_2_Chars(pack_head.uin2, our_info->uin);
     Word_2_Chars(pack_head.cmd, ICQ_CMDxTCP_CHAT);
     Word_2_Chars(pack_head.message_length, 1);

     DW_2_IP(pack_mid.ip, 0x00000000);
     DW_2_IP(pack_mid.ip_real, LOCALHOST);
     DW_2_Chars(pack_mid.porta, our_port);
     pack_mid.junk = 0x04;
     Word_2_Chars(pack_mid.status, ICQ_ACKxTCP_ONLINE);
     Word_2_Chars(pack_mid.msgcommand, 0x0010);
     Word_2_Chars(pack_mid.session_len, 1);

     Word_2_Chars(pack_tail.back_port, backport);
     Word_2_Chars(pack_tail.zero, 0x0000);
     DW_2_Chars(pack_tail.portb, ccontact->chatsession->listen_port);
     DW_2_Chars(pack_tail.seq, ccontact->seq);

     if (sock != -1) {
	  intsize =
	       sizeof(tcp_head) + sizeof(tcp_mid) + sizeof(tcp_tail) + 2;
	  buffer = (BYTE *) g_malloc0(intsize + 2);

	  Word_2_Chars(buffer, intsize);
	  ptr = buffer + 2;
	  memcpy(ptr, &pack_head, sizeof(pack_head));
	  ptr += sizeof(pack_head);
	  *ptr = 0x00;
	  ptr++;
	  memcpy(ptr, &pack_mid, sizeof(pack_mid));
	  ptr += sizeof(pack_mid);
	  *ptr = 0x00;
	  ptr++;
	  memcpy(ptr, &pack_tail, sizeof(pack_tail));
	  ptr += sizeof(pack_tail);
	  write(sock, buffer, intsize + 2);
	  packet_print(buffer + 2, intsize,
		       PACKET_TYPE_TCP | PACKET_DIRECTION_SEND,
		       "ACCEPT CHAT");
	  g_free(buffer);

	  if (ccontact->mpartynew > 1)
	       TCPConnectChat(ccontact->listen_port, ccontact->contact->uin, ccontact->chatsession);
	  
     } else
	  return -1;
     
     return 1;
}

int TCPRefuseChat(int sock, ChatContact *ccontact)
{
    BYTE *buffer;
    unsigned short intsize;

    typedef struct {
	BYTE uin1[4];
	BYTE version[2];
	BYTE command[2];
	BYTE zero[2];
	BYTE uin2[4];
	BYTE cmd[2];
	BYTE message_length[2];
    } tcp_head;

    typedef struct {
	BYTE ip[4];
	BYTE ip_real[4];
	BYTE porta[4];
	BYTE junk;
	BYTE status[4];
	BYTE zeroa[4];
	BYTE zerob[4];
	BYTE zeroc[2];
	BYTE zerod;
	BYTE seq[4];
    } tcp_tail;

    tcp_head pack_head;
    tcp_tail pack_tail;

#ifdef TRACE_FUNCTION
    g_print("TCPRefuseChat\n");
#endif
    
    ccontact->contact = NULL;

    DW_2_Chars(pack_head.uin1, our_info->uin);
    Word_2_Chars(pack_head.version, 0x0003);
    Word_2_Chars(pack_head.command, ICQ_CMDxTCP_CANCEL);
    Word_2_Chars(pack_head.zero, 0x0000);
    DW_2_Chars(pack_head.uin2, our_info->uin);
    DW_2_Chars(pack_head.cmd, ICQ_CMDxTCP_CHAT);
    DW_2_Chars(pack_head.message_length, 1);

    DW_2_IP(pack_tail.ip, our_ip);
    DW_2_IP(pack_tail.ip_real, LOCALHOST);
    DW_2_Chars(pack_tail.porta, our_port);
    pack_tail.junk = 0x04;
    DW_2_Chars(pack_tail.status, ICQ_ACKxTCP_REFUSE);

    DW_2_Chars(pack_tail.zeroa, 0x00000001);
    DW_2_Chars(pack_tail.zerob, 0x00000000);
    DW_2_Chars(pack_tail.zeroc, 0x00000000);
    pack_tail.zerod = 0x00;
    DW_2_Chars(pack_tail.seq, ccontact->seq);

    g_free(ccontact);

    if (sock != -1) {
	intsize = sizeof(tcp_head) + sizeof(tcp_tail) + 1;
	buffer = (BYTE *) g_malloc0(intsize + 2);

	Word_2_Chars(buffer, intsize);
	memcpy(buffer + 2, &pack_head, sizeof(pack_head));
	buffer[2 + sizeof(pack_head)] = 0x00;
	memcpy(buffer + 2 + sizeof(pack_head) + 1,
	       &pack_tail, sizeof(pack_tail));
	write(sock, buffer, intsize + 2);
	packet_print(buffer + 2, intsize,
		     PACKET_TYPE_TCP | PACKET_DIRECTION_SEND,
		     "REFUSE CHAT");
    } else
	return -1;

    return 1;
}

int TCPSendChatRequest(UIN_T uin, gchar * msg, ChatSession *csession)
{
    int sock;
    unsigned short intsize;
    BYTE *buffer;
    BYTE *ptr;
    GSList *temp_ccontact;

    typedef struct {
	BYTE uin_a[4];
	BYTE version[2];
	BYTE cmd[2];
	BYTE zero[2];
	BYTE uin_b[4];
	BYTE command[2];
	BYTE msg_length[2];
    } tcp_head;

    typedef struct {
	BYTE ip[4];
	BYTE real_ip[4];
	BYTE port[4];
	BYTE four;
	BYTE status[2];
	BYTE msgcommand[2];
	BYTE session_len[2];
    } tcp_mid;

    typedef struct {
	BYTE revport[2];
	BYTE zero[2];
	BYTE port[4];
	BYTE seq[4];
    } tcp_tail;

    struct {
	tcp_head head;
	const gchar *body;
	tcp_mid mid;
	tcp_tail tail;
    } packet;

    GSList *contact;
    GString *sessionname = NULL;

#ifdef TRACE_FUNCTION
    g_print("TCPSendChatRequest\n");
#endif

    contact = Find_User( uin );
    if (contact == NULL)
	return 0;

    if (!kontakt->has_direct_connect)
      return 0;

    
    if (csession == NULL)
    {
	 csession = g_malloc0(sizeof(ChatSession));
	 Sessions = g_slist_append(Sessions, csession);
    }

    kontakt->chat_requests = g_list_append(kontakt->chat_requests, csession);

    rus_conv(RUS_KOI_WIN, msg);
    DW_2_Chars(packet.head.uin_a, our_info->uin);
    Word_2_Chars(packet.head.version, 0x0003);
    Word_2_Chars(packet.head.cmd, ICQ_CMDxTCP_START);
    Word_2_Chars(packet.head.zero, 0x0000);
    DW_2_Chars(packet.head.uin_b, our_info->uin);
    Word_2_Chars(packet.head.command, ICQ_CMDxTCP_CHAT);
    Word_2_Chars(packet.head.msg_length, (strlen(msg) + 1));

    packet.body = msg;

    DW_2_IP(packet.mid.ip, our_ip);
    DW_2_IP(packet.mid.real_ip, LOCALHOST);
    DW_2_Chars(packet.mid.port, our_port);
    packet.mid.four = 0x04;

    switch (Current_Status) {
    case STATUS_ONLINE:
	Word_2_Chars(packet.mid.status, ICQ_ACKxTCP_ONLINE);
	break;
    case STATUS_AWAY:
	Word_2_Chars(packet.mid.status, ICQ_ACKxTCP_AWAY);
	break;
    case STATUS_DND:
	Word_2_Chars(packet.mid.status, ICQ_ACKxTCP_DND);
	break;
    case STATUS_OCCUPIED:
	Word_2_Chars(packet.mid.status, ICQ_ACKxTCP_OCC);
	break;
    case STATUS_NA:
	Word_2_Chars(packet.mid.status, ICQ_ACKxTCP_NA);
	break;
    case STATUS_INVISIBLE:
	Word_2_Chars(packet.mid.status, ICQ_ACKxTCP_ONLINE);
	break;
    }

    Word_2_Chars(packet.mid.msgcommand, 0x0010);

    if (csession->members && g_slist_length(csession->members) > 0)
    {

	 sessionname = g_string_new(our_info->nick);

	 for (temp_ccontact = csession->members;
	      temp_ccontact != NULL;
	      temp_ccontact = g_slist_next(temp_ccontact))
	 {
	      g_string_sprintfa(sessionname, ",%s", ((ChatContact *)temp_ccontact->data)->contact->nick);
	 }
	 g_assert (sessionname != NULL);
	 Word_2_Chars(packet.mid.session_len, sessionname->len);
	 Word_2_Chars(packet.tail.revport, g_htons((WORD) csession->listen_port));
	 DW_2_Chars(packet.tail.port, (DWORD) csession->listen_port);
	 

    }
    else
    {
	 Word_2_Chars(packet.mid.session_len, 1);
	 Word_2_Chars(packet.tail.revport, 0x0000);
	 DW_2_Chars(packet.tail.port, 0x00000000);
    }
    Word_2_Chars(packet.tail.zero, 0x0000);

    DW_2_Chars(packet.tail.seq, kontakt->tcp_seq);

/*** Create packet ***/
    intsize =
	sizeof(tcp_head) + sizeof(tcp_mid) + sizeof(tcp_tail) +
	strlen(msg) + 1 + ((g_slist_length(csession->members) > 0) ? (sessionname->len): 1 );
    buffer = (BYTE *) g_malloc0(strlen("REQUEST CHAT") + 1 + intsize + 2);

    Word_2_Chars(buffer, intsize);
    ptr = buffer + 2;
    memcpy(ptr, &packet.head, sizeof(packet.head));
    ptr += sizeof(packet.head);
    memcpy(ptr, packet.body, strlen(packet.body) + 1);
    ptr += strlen(packet.body) + 1;
    memcpy(ptr, &packet.mid, sizeof(packet.mid));
    ptr += sizeof(packet.mid);
    if (Chars_2_Word(packet.mid.session_len) == 1)
    {
	 *ptr = 0x00;
	 ptr++;
    }
    else
    {
	 g_assert(sessionname != NULL);
	 memcpy(ptr, sessionname->str, sessionname->len);
	 g_string_free (sessionname, TRUE);
	 ptr += sessionname->len;
    }
    memcpy(ptr, &packet.tail, sizeof(packet.tail));
    ptr += sizeof(packet.tail);
    strcpy(buffer + 2 + intsize, "REQUEST CHAT");
/*********************/

    tcp_prepare_message(kontakt, buffer, NULL,
			kontakt->tcp_seq--, TRUE);

    sock =
	TCPGainConnection(kontakt->current_ip,
			  kontakt->port, contact);

    if (sock == -2)		/* We're waiting for a connection */
	return TRUE;

    if (sock != -1)
	TCPClearQueue(contact);
    else
	return -1;

    return 1;
}

int TCPChatSend(GtkWidget *widget, GdkEventKey *ev, ChatSession *csession)
{
    guchar c;
    char tmp[] = "_";

#ifdef TRACE_FUNCTION
    g_print("TCPChatSend\n");
#endif

    if (ev == NULL)
	return FALSE;

    if (csession->lineout == NULL)
	 csession->lineout = g_string_new("");

    switch (ev->keyval) {
    case GDK_Shift_L:
    case GDK_Shift_R:
    case GDK_Control_L:
    case GDK_Control_R:
    case GDK_Alt_L:
    case GDK_Alt_R:
    case GDK_Up:
    case GDK_Down:
    case GDK_Right:
    case GDK_Left:
    case GDK_Home:
    case GDK_End:
    case GDK_Page_Up:
    case GDK_Page_Down:
    case GDK_Delete:
    case GDK_Caps_Lock:
	return TRUE;
    case 'g': /* Ctrl-G is BEEP */
	if (ev->state & GDK_CONTROL_MASK) {
	    gnomeicu_event(EV_CHATBEEP, 0);

	    c = 0x07;
	    break;
	} 
	else {
	     c = ev->keyval;
	     g_string_append_c(csession->lineout, c);
	}
	break;
    case GDK_Return:
	c = 0x0D;
	InsertLine(csession);
	break;
    case GDK_BackSpace:
	 c = 0x08;
	 g_string_truncate(csession->lineout, (csession->lineout->len - 1 >= 0) ? (csession->lineout->len - 1) : 0 );
	 
	 break;
    case GDK_Tab:
	 c = 0x09;
	 break;
    default:
	 c = ev->keyval;
	 g_string_append_c(csession->lineout, c);
	 
    }
    

    tmp[0] = c;
    rus_conv(RUS_KOI_WIN, tmp);
    c = tmp[0];
    
    TCPChatWriteAll(csession, &c, 1);

    return FALSE;
}

void TCPChatWriteAll(ChatSession *csession, gpointer data, size_t len)
{
     GSList *nc_list;
     
#ifdef TRACE_FUNCTION
     g_print("TCPChatWriteAll\n");
#endif
     
     nc_list = csession->members;
     while (nc_list != NULL)
     {
	  if (((ChatContact *) nc_list->data)->socket > 0)
	       write(((ChatContact *) nc_list->data)->socket, data, len);
	  nc_list = g_slist_next(nc_list);
     }
}

int TCPChatSendSel(GtkWidget *widget, GtkSelectionData *data, guint time,
		   ChatSession *csession)
{
    char c;
    int i = 0;


#ifdef TRACE_FUNCTION
    g_print("TCPChatSendSel\n");
#endif


    if (data->data == NULL)
	return FALSE;

    c = data->data[i];

    while (c != 0x00) {
	switch (c) {
	case '\n':
	    c = 0x0D;
	    break;
	}

	if (c != 0x07 && c != 0x08 && c != 0x09 && c != 0x0D )
	     csession->lineout = g_string_append_c(csession->lineout, c);
	
	
	if (c == 0x0D) {
	     InsertLine(csession);
	}

	TCPChatWriteAll(csession, &c, 1);
	
	i++;
	c = data->data[i];
    }

    return FALSE;
}

void TCPTerminateChatSession(GtkWidget * widget, ChatSession *csession)
{

     GSList *nc_list, *nc_list_temp;

#ifdef TRACE_FUNCTION
    g_print("TCPTerminateChatSession\n");
#endif


    if (csession->gdk_input)
	 gdk_input_remove(csession->gdk_input);

	 Sessions = g_slist_remove (Sessions, csession);
    
    
    if (csession->lineout)
	 g_string_free(csession->lineout, TRUE);

    if (csession->history)
	 g_slist_free(csession->history);

     if (csession->filesel)
	 gtk_widget_destroy(csession->filesel);

     if (csession->font)
	  gdk_font_unref (csession->font);
     
     gtk_widget_show(gnome_message_box_new
		    (_("Chat Session terminated"), GNOME_MESSAGE_BOX_INFO,
		     GNOME_STOCK_BUTTON_OK, NULL));

    if (csession->listen_socket)
	 close(csession->listen_socket);

    
    nc_list = csession->members;
    while (nc_list != NULL)
    {
	 nc_list_temp = nc_list;
	 nc_list = nc_list->next;
	 PartChatSession((ChatContact *)nc_list_temp->data);


    }
		   
    if (csession->chatwindow)
	 gtk_widget_destroy(csession->chatwindow);

    g_free(csession);

}

void chat_save(GtkWidget * widget, ChatSession *csession)
{

#ifdef TRACE_FUNCTION
     g_print("chat_save\n");
#endif
     
     csession->filesel =
	  gtk_file_selection_new(_("GnomeICU: Save Chat Session"));
     gtk_signal_connect(GTK_OBJECT(csession->filesel), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);
     gtk_signal_connect(GTK_OBJECT
			(GTK_FILE_SELECTION(csession->filesel)->ok_button),
			"clicked", GTK_SIGNAL_FUNC(chat_save_got_name),
			csession);
     gtk_signal_connect_object(GTK_OBJECT
			       (GTK_FILE_SELECTION(csession->filesel)->
				cancel_button), "clicked",
			       GTK_SIGNAL_FUNC(gtk_widget_destroy),
			       GTK_OBJECT(csession->filesel));
     gtk_widget_show(csession->filesel);
}

void chat_save_got_name(GtkWidget * widget, ChatSession *csession)
{
    char *fn;
    int chat_file_fd;
    GSList *list;

#ifdef TRACE_FUNCTION
    g_print( "chat_save_got_name" );
#endif

    fn = gtk_file_selection_get_filename(GTK_FILE_SELECTION(csession->filesel));

    if (
	(chat_file_fd =
	 open(fn, O_WRONLY | O_CREAT | O_APPEND, S_IRUSR | S_IWUSR)) == -1)
	return;

    list = csession->history;

    while (list) {
	write(chat_file_fd, list->data, strlen(list->data));
	list = list->next;
    }

    write(chat_file_fd, "\n\n\n", 3);
    close(chat_file_fd);

    gtk_widget_destroy(csession->filesel);
}

int TCPConnectChat( DWORD port, UIN_T uin, ChatSession *csession)
{
     struct sockaddr_in local, remote;
     /* This must be int, not socklen_t, breaks compilation otherwise */
     int sizeofSockaddr = sizeof(struct sockaddr);
     DWORD ip;
     unsigned short size;
     BYTE *buffer;
     struct sockaddr_in my_addr;
     ChatContact *ccontact;
     gint cx, have_tcp_port = FALSE;
     int length = sizeof(struct sockaddr);

     typedef struct {
	  BYTE code;
	  BYTE version[4];
	  BYTE chat_porta[4];
	  BYTE uin[4];
	  BYTE ip_local[4];
	  BYTE ip_remote[4];
	  BYTE four;
	  BYTE chat_portb[4];
     } handshake_a; 
		       
     typedef struct {
	  BYTE code[4];
	  BYTE biga[4];
	  BYTE uin[4];
	  BYTE name_length[2];
     } handshake_b;     

     
     typedef struct {
	  BYTE revporta;
	  BYTE revportb;
	  BYTE foreground[4];
	  BYTE background[4];
	  BYTE zero;
     } handshake_c;
     
     handshake_a hsa;
     handshake_b hsb;
     handshake_c hsc;
     
     GSList *contact;
     
#ifdef TRACE_FUNCTION
     g_print("TCPConnectChat\n");
#endif
     
     contact = Find_User( uin );
     if (contact == NULL)
	  return -1;
     
      if (!kontakt->has_direct_connect)
          return FALSE;
     
     if (csession == NULL) {
	  csession = (ChatSession *) g_list_first(kontakt->chat_requests)->data;
	  kontakt->chat_requests = g_list_remove(kontakt->chat_requests, csession);
	  
	  if (csession->members && g_slist_length(csession->members) > 0)
	       return 0;

     }

     
     if (csession->initiator != NULL) {
	  ccontact = (ChatContact *) csession->initiator;
	  csession->initiator = NULL;
     }
     else {
	  ccontact = g_new0(ChatContact,1);
	  ccontact->contact = kontakt;
	  ccontact->listen_port = port;
     }
     
     ip = kontakt->current_ip;
     
     if (ip == 0)
	  return -1;
     
     if (csession->listen_socket == 0) {
	  csession->listen_socket = socket(AF_INET, SOCK_STREAM, 0);
	  if (csession->listen_socket <= 0)
	       return FALSE;
	  
	  for (cx = min_tcp_port; cx <= max_tcp_port; cx++) {
	       my_addr.sin_family = AF_INET;
	       my_addr.sin_port = g_htons(cx);
	       my_addr.sin_addr.s_addr = g_htonl(INADDR_ANY);
	       memset(&(my_addr.sin_zero), 0x00, 8);
	       if (bind
		   (csession->listen_socket, (struct sockaddr *) &my_addr,
		    sizeof(struct sockaddr)) != -1)
		    have_tcp_port = TRUE;
	       else
		    continue;
	       
	       break;
	  }
	  
	  if( have_tcp_port == FALSE )
	       return FALSE;
	  
	  listen(csession->listen_socket, 1);
	  csession->gdk_input =
	       gdk_input_add(csession->listen_socket, GDK_INPUT_READ,
			     (GdkInputFunction) TCPChatHandshake, csession);
	  
	  getsockname(csession->listen_socket, (struct sockaddr *) &my_addr, &length);
	  csession->listen_port = g_ntohs(my_addr.sin_port);
	  
	  
     }
     
     
     
     ccontact->socket = socket(AF_INET, SOCK_STREAM, 0);
     if (ccontact->socket == -1)
	  return -1;
     
     fcntl(ccontact->socket, O_NONBLOCK);
     
     memset(&local.sin_zero, 0x00, 8);
     memset(&remote.sin_zero, 0x00, 8);
     
     local.sin_family = AF_INET;
     remote.sin_family = AF_INET;
     local.sin_port = g_htons(0);
     local.sin_addr.s_addr = g_htonl(INADDR_ANY);
     
     remote.sin_port = g_htons(port);
     remote.sin_addr.s_addr = g_htonl(ip);
     
     if (connect(ccontact->socket, (struct sockaddr *) &remote, sizeofSockaddr) < 0)
	  return -1;
     
     getsockname(ccontact->socket, (struct sockaddr *) &local, &sizeofSockaddr);
     ccontact->port = g_ntohs(local.sin_port);
     
     history_add_outgoing(uin, _("Connected for a session."));
     
     if (csession->chatwindow == NULL)
	  ChatWindowNew(csession);
     
     JoinChatSession(csession, ccontact);
     
     
     fcntl(ccontact->socket, O_NONBLOCK);
     
     ccontact->gdk_input = gdk_input_add(ccontact->socket, GDK_INPUT_READ,
					 (GdkInputFunction) TCPChatWaitForAck,
					 ccontact);
     
     hsa.code = 0xFF;
     DW_2_Chars(hsa.version, 0x00000004);
     DW_2_Chars(hsa.uin, our_info->uin);
     DW_2_IP(hsa.ip_local, our_ip);
     DW_2_IP(hsa.ip_remote, our_ip);
     hsa.four = 0x04;
     DW_2_Chars(hsa.chat_portb, csession->listen_port);
     DW_2_Chars(hsa.chat_porta, csession->listen_port);
     
     size = sizeof(handshake_a);
     buffer = g_malloc0(size + 2);
     
     Word_2_Chars(buffer, size);
     memcpy(buffer + 2, &hsa, size);
     write(ccontact->socket, buffer, size + 2);
     packet_print(buffer + 2, size,
		  PACKET_TYPE_TCP | PACKET_DIRECTION_SEND, "CHAT(INIT HSA)");
     g_free(buffer);
     
     DW_2_Chars(hsb.code, 0x00000064);
     DW_2_Chars(hsb.biga, 0xFFFFFFFC);
     DW_2_Chars(hsb.uin, our_info->uin);
     Word_2_Chars(hsb.name_length, strlen(our_info->nick) + 1);
     hsc.revporta = ((char *) (&csession->listen_port))[1];
     hsc.revportb = ((char *) (&csession->listen_port))[0];
     DW_2_Chars(hsc.foreground, 0x00FFFFFF);
     DW_2_Chars(hsc.background, 0x00000000);
     hsc.zero = 0x00;
     
     size =
	  sizeof(handshake_b) + sizeof(handshake_c) +
	  strlen(our_info->nick) + 1;
     buffer = (BYTE *) g_malloc0(size + 2);
     
     Word_2_Chars(buffer, size);
     memcpy(buffer + 2, &hsb, sizeof(handshake_b));
     memcpy(buffer + 2 + sizeof(handshake_b), our_info->nick,
	    strlen(our_info->nick) + 1);
     memcpy(buffer + 3 + sizeof(handshake_b) + strlen(our_info->nick), &hsc,
	    sizeof(handshake_c));
     write(ccontact->socket, buffer, size + 2);
     packet_print(buffer + 2, size,
		  PACKET_TYPE_TCP | PACKET_DIRECTION_SEND, "CHAT(HINIT SB/C)");
     g_free(buffer);
     
     return ccontact->socket;
}

void TCPChatHandshake(ChatSession *csession, int lsock, GdkInputCondition cond)
{
     
     /* This must be int, not socklen_t, breaks compilation otherwise */
     int size = sizeof(struct sockaddr);
     struct sockaddr_in their_addr;
     ChatContact *ccontact;
     
#ifdef TRACE_FUNCTION
     g_print("TCPChatHandshake\n");
#endif
     
     if (csession->chatwindow == NULL)
	  ChatWindowNew(csession);


     if (csession->initiator != NULL) {
	  ccontact = (ChatContact *) csession->initiator;
	  csession->initiator = NULL;
     }
     else
	  ccontact = g_new0(ChatContact,1);

     ccontact->chatsession = csession;


     ccontact->socket = accept(lsock, (struct sockaddr *) &their_addr, &size);

     ccontact->port = g_ntohs(their_addr.sin_port);

     fcntl(ccontact->socket, O_NONBLOCK);
    
     ccontact->gdk_input =
	  gdk_input_add(ccontact->socket, GDK_INPUT_READ,
			(GdkInputFunction) TCPChatWaitForNewConnection, ccontact);
}

void TCPChatWaitForNewConnection(ChatContact *ccontact, int sock, GdkInputCondition cond)
{   

     BYTE *packet;
     BYTE *buffer;     
     unsigned short packet_size;

     typedef struct
     {
	  BYTE version[4];
	  DWORD uin;
	  WORD name_len;
	  char *name;
	  BYTE foreground[4];
	  BYTE background[4];
     } read_pack;


     typedef struct
     {
	  BYTE code[4];
	  BYTE uin[4];
	  WORD name_length;
     } begin_chat_a;
	
     typedef struct
     {
	  BYTE foreground[4];
	  BYTE background[4];
	  BYTE version[4];
	  BYTE chat_port[4];
	  BYTE ip_local[4];
	  BYTE ip_remote[4];
	  BYTE four;
	  BYTE our_port[2];
	  BYTE font_size[4];
	  BYTE font_face[4];
	  BYTE font_length[2];
     } begin_chat_b;
	
     typedef struct
     {
	  BYTE zeroa[2];
	  BYTE count;
     } begin_chat_c;

     typedef struct {
	  BYTE version[4];
	  BYTE port[4];
	  BYTE uin[4];
	  BYTE ip_local[4];
	  BYTE ip_remote[4];
	  BYTE rev_port[2];
 	  BYTE tcpflags;
	  BYTE sessionid[2];
	  BYTE code[4];
     } other_user;


     read_pack rpak;
     begin_chat_a paka;
     begin_chat_b pakb;
     begin_chat_c pakc;
     other_user *ouser;
     other_user *ouser_beg = NULL;
     
     GSList *contact;
     WORD font_size = 12;
     gchar *font_name;
     gchar *font_copy;
     GSList *otherccontact;
     gchar *message;
 
#ifdef TRACE_FUNCTION
     g_print("TCPChatWaitForNewConnection\n");
#endif
     
     gdk_input_remove(ccontact->gdk_input);

     font_copy = g_strdup( ChatFontString );
     strtok( font_copy, "-" );
     font_name = strtok( NULL, "-" );
  
     if( read(sock, (char *) (&packet_size), 1) <= 0 )
     {
	  
	  message = g_strdup_printf( _("%s has left the chat session."), ccontact->contact->nick );
	  gtk_widget_show( gnome_message_box_new( _( message ),
						  GNOME_MESSAGE_BOX_INFO,
						  GNOME_STOCK_BUTTON_OK,
						  NULL ) );
	  
	  PartChatSession(ccontact);
	  return;
     }
      read( sock, (char*)(&packet_size) + 1, 1 );
     packet_size = GUINT16_FROM_LE (packet_size);
     
     packet = (BYTE *)g_malloc0( packet_size );
     read( sock, packet, packet_size );
     packet_print( packet, packet_size,
		   PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE, "CHAT(PRE INIT)" );
     
     /* Interpretation of packet NO 1 */

     g_free( packet ); 

     read( sock, (char*)(&packet_size), 1 );
     read( sock, (char*)(&packet_size) + 1, 1 );
     packet_size = GUINT16_FROM_LE (packet_size);
     if( packet_size < 1024 )
     {
	  packet = (BYTE *)g_malloc0( packet_size );
	  read( sock, packet, packet_size );
	  packet_print( packet, packet_size,
			PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE, "CHAT(INIT)" );
	  

	  rpak.uin = Chars_2_DW(packet + 8);
	  rpak.name_len =  Chars_2_Word(packet + 12);
	  memcpy( &rpak.foreground, packet + 16 + GPOINTER_TO_INT( rpak.name_len ), 4 );
	  memcpy( &rpak.background, packet + 20 + GPOINTER_TO_INT( rpak.name_len ), 4 );
	  ccontact->fg_red = rpak.foreground[0];
	  ccontact->fg_green = rpak.foreground[1];
	  ccontact->fg_blue = rpak.foreground[2];
	  ccontact->bg_red = rpak.background[0];
	  ccontact->bg_green = rpak.background[1];
	  ccontact->bg_blue = rpak.background[2];	


	  if (ccontact->contact == NULL)
	  {
	       contact = Find_User( rpak.uin );
	       if (!contact) 
	       {
		    rpak.name = g_strndup(packet+14, rpak.name_len);
		    contact = Add_User(Chars_2_DW(paka.uin), rpak.name, FALSE);
		    g_free(rpak.name);
	       }
	       ccontact->contact = kontakt;
	  }
	  
	  g_free( packet );
     }
     else
     {
	  g_print ( "We have received a bizzare chat packet\n");
     }
     
     DW_2_Chars( paka.code, 0x00000064 );
     DW_2_Chars( paka.uin, our_info->uin );
     paka.name_length = strlen( our_info->nick ) + 1;
     DW_2_Chars( pakb.foreground, 0x00FFFFFF );
     DW_2_Chars( pakb.background, 0x00000000 );
     DW_2_Chars( pakb.version, 0x00000004 );
     DW_2_Chars( pakb.chat_port, ccontact->port );
     DW_2_IP( pakb.ip_local, our_ip );
     DW_2_IP( pakb.ip_remote, our_ip );
     pakb.four = 0x04;
     Word_2_Chars( pakb.our_port, our_port );
     DW_2_Chars( pakb.font_size, font_size );
     DW_2_Chars( pakb.font_face, FONT_PLAIN );
     Word_2_Chars( pakb.font_length, strlen( font_name ) + 1 );
     Word_2_Chars( pakc.zeroa, 0x4200 );
     if (g_slist_length(ccontact->chatsession->members) > 0)
     {
	  pakc.count = g_slist_length(ccontact->chatsession->members);
	  ouser = ouser_beg = g_new0(other_user, g_slist_length(ccontact->chatsession->members));
	  otherccontact = ccontact->chatsession->members;
	  while (otherccontact != NULL)
	  {
	       Word_2_Chars( ouser->version, 0x00000004 );
	       DW_2_Chars( ouser->port, ((ChatContact *)otherccontact->data)->listen_port );
	       DW_2_Chars(ouser->uin, ((ChatContact *)otherccontact->data)->contact->uin);
	       DW_2_IP( ouser->ip_local, ((ChatContact *)otherccontact->data)->contact->current_ip );
	       DW_2_IP( ouser->ip_remote, ((ChatContact *)otherccontact->data)->contact->current_ip );
	       ouser->rev_port[0] = ((char *) (&ccontact->listen_port))[1];
	       ouser->rev_port[1] = ((char *) (&ccontact->listen_port))[0];
	       ouser->tcpflags = 0x04;
	       Word_2_Chars( ouser->sessionid, our_port);
	       DW_2_Chars( ouser->code, 0x00000064 );

	       otherccontact = otherccontact->next;
	       ouser += sizeof(other_user);
	  }

     }
     else 
	  pakc.count = 0x00;

     packet_size = sizeof( begin_chat_a ) + sizeof( begin_chat_b ) + sizeof( begin_chat_c ) + strlen( our_info->nick ) + 1 + strlen( font_name ) + 1 + sizeof(other_user)*pakc.count;
     buffer = (BYTE*)g_malloc0( packet_size + 2 );

     Word_2_Chars (buffer, packet_size);
     memcpy( buffer+2, &paka, sizeof( begin_chat_a ) );
     memcpy( buffer+2 + sizeof( begin_chat_a ), our_info->nick, strlen( our_info->nick ) + 1 );
     memcpy( buffer+3 + sizeof( begin_chat_a ) + strlen( our_info->nick ), &pakb, sizeof( begin_chat_b ) );
     memcpy( buffer+3 + sizeof( begin_chat_a ) + strlen( our_info->nick ) + sizeof( begin_chat_b ), font_name, strlen( font_name ) + 1 );
     memcpy( buffer+4 + sizeof( begin_chat_a ) + strlen( our_info->nick ) + sizeof( begin_chat_b ) + strlen( font_name ), &pakc, sizeof( begin_chat_c ) );
     if (pakc.count > 0)
	  memcpy( buffer+4 + sizeof( begin_chat_a ) + strlen( our_info->nick ) + sizeof( begin_chat_b ) + strlen( font_name )+sizeof( begin_chat_c ), ouser_beg, sizeof(other_user)*pakc.count);
	  
     write( sock, buffer, packet_size + 2 );
     packet_print( buffer+2, packet_size,
		   PACKET_TYPE_TCP | PACKET_DIRECTION_SEND, "CHAT(ACK)" );

     g_free( buffer );
     
     if ( ouser_beg )
	  g_free(ouser_beg);
     
     g_free(font_name);
     g_free(font_copy);

     ccontact->gdk_input =
	  gdk_input_add(ccontact->socket, GDK_INPUT_READ,
			(GdkInputFunction) TCPChatWait3rdPak, ccontact);
     
}

void TCPChatWait3rdPak(ChatContact *ccontact, int sock, GdkInputCondition cond)
{   
     
     BYTE *packet;
     unsigned short packet_size;

     typedef struct
     {
	  BYTE version[2];
	  BYTE revision[2];
	  BYTE port[4];
	  BYTE ip_local[4];
	  BYTE ip_remote[4];
	  BYTE four;
	  BYTE sessionid[2];
	  BYTE font_size[4];
	  BYTE font_face[4];
	  BYTE font_length[2];
//	  gchar *font_name;
     } trd_read_pack;
     
     trd_read_pack *rpak;
     gchar *message;
 
     
#ifdef TRACE_FUNCTION
     g_print("TCPChatWait3rdPak\n");
#endif
     
     gdk_input_remove(ccontact->gdk_input);
     
     
     if( read(sock, (char *) (&packet_size), 1) <= 0 )
     {
	  
	  message = g_strdup_printf( _("%s has left the chat session."), ccontact->contact->nick );
	  gtk_widget_show( gnome_message_box_new( _( message ),
						  GNOME_MESSAGE_BOX_INFO,
						  GNOME_STOCK_BUTTON_OK,
						  NULL ) );
	  PartChatSession(ccontact);
	  return;

     }
 
     read(sock, (char *) (&packet_size) + 1, 1);
     packet_size = GUINT16_FROM_LE(packet_size);
     
     packet = (BYTE *) g_malloc0(packet_size);
     read(sock, packet, packet_size);
     packet_print(packet, packet_size,
		  PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE,
		  "CHAT(BEGIN)");
     rpak = (trd_read_pack *)packet;
     

     ccontact->port = Chars_2_DW(rpak->port);
     

     /* font stuff */
     
     
     JoinChatSession(ccontact->chatsession, ccontact);

     ccontact->gdk_input =
	  gdk_input_add(ccontact->socket, GDK_INPUT_READ,
			(GdkInputFunction) TCPChatRead, ccontact);
     
}



void TCPChatWaitForAck(ChatContact *ccontact, int sock, GdkInputCondition cond)
{
     
     unsigned short packet_size;
     BYTE *packet;
     BYTE *buffer;
     BYTE *countbase;
     int i;
     GSList *nc_list;
     ChatSession *csession = ccontact->chatsession;
     WORD font_size = 12;
     gchar *font_name;
     gchar *font_copy;
     GSList *contact;

     typedef struct
     {
	  BYTE version[2];
	  BYTE revision[2];
	  BYTE chat_port[4];
	  BYTE ip_local[4];
	  BYTE ip_remote[4];
	  BYTE four;
	  BYTE our_port[2];
	  BYTE font_size[4];
	  BYTE font_face[4];
	  BYTE font_length[2];
     } begin_chat_a;
     
     typedef struct
     {
	  BYTE one[2];
     } begin_chat_b;
     
    typedef struct
     {
	  DWORD code;
	  UIN_T uin;
	  WORD name_length;
	  BYTE foreground[4];
	  BYTE background[4];
	  BYTE version[4];
	  BYTE chat_port[4];
	  BYTE ip_local[4];
	  BYTE ip_remote[4];
	  BYTE four;
	  BYTE our_port[2];
	  BYTE font_size[4];
	  BYTE font_face[4];
	  WORD font_length;
	  BYTE count;
     } read_pak;

    typedef struct {
	 BYTE version[4];
	 DWORD port;
	 DWORD uin;
	 BYTE ip_local[4];
	 BYTE ip_remote[4];
	 BYTE rev_port[2];
	 BYTE tcpflags;
	 BYTE sessionid[2];
	 BYTE code[4];
    } read_user;
 
    
    begin_chat_a paka;
    begin_chat_b pakb;

    read_pak rpak;
    read_user *ruser;
    gchar *message;

#ifdef TRACE_FUNCTION
     g_print("TCPChatWaitForAck\n");
#endif
     font_copy = g_strdup( ChatFontString );
     strtok( font_copy, "-" );
     font_name = strtok( NULL, "-" );

     gdk_input_remove(ccontact->gdk_input);
     
     if( read(sock, (char *) (&packet_size), 1) <= 0 )
     {
	  
	  message = g_strdup_printf( _("%s has left the chat session."), ccontact->contact->nick );
	  gtk_widget_show( gnome_message_box_new( _( message ),
						  GNOME_MESSAGE_BOX_INFO,
						  GNOME_STOCK_BUTTON_OK,
						  NULL ) );
	  PartChatSession(ccontact);
	  return;
     }

     read(sock, (char *) (&packet_size) + 1, 1);
     packet_size = GUINT16_FROM_LE(packet_size);

     packet = (BYTE *) g_malloc0(packet_size);
     read(sock, packet, packet_size);
     packet_print(packet, packet_size,
		  PACKET_TYPE_TCP | PACKET_DIRECTION_RECEIVE,
		  "CHAT(ACK)");

     rpak.code = Chars_2_DW (packet);
     rpak.uin = Chars_2_DW (packet + 4);
     rpak.name_length = Chars_2_Word (packet + 8);
     memcpy( &rpak.foreground, ( packet + 10 + GPOINTER_TO_INT( rpak.name_length ) ), 4 );
     memcpy( &rpak.background, ( packet + 14 + GPOINTER_TO_INT( rpak.name_length ) ), 4 );
     ccontact->fg_red = rpak.foreground[0];
     ccontact->fg_green = rpak.foreground[1];
     ccontact->fg_blue = rpak.foreground[2];
     ccontact->bg_red = rpak.background[0];
     ccontact->bg_green = rpak.background[1];
     ccontact->bg_blue = rpak.background[2];	
     
     rpak.font_length  = Chars_2_Word(packet +  rpak.name_length  + 45);

     rpak.count = *(packet + rpak.name_length + rpak.font_length + 49);

     if (rpak.count > 0)
     {
	  countbase = packet + GPOINTER_TO_INT( rpak.name_length ) +  GPOINTER_TO_INT( rpak.font_length) + 50;

	  for (i = 0;
	       i < rpak.count; 
	       ++i)
	  {
	       ruser = ((read_user *) countbase + i * sizeof(read_user));
	       
	       contact = Find_User( ruser->uin );
	       if (contact == NULL)
		    contact = Add_User(ruser->uin, NULL, FALSE);

	       nc_list = csession->members;

	       while (nc_list != NULL)
	       {
		    if (((ChatContact *) nc_list->data)->contact == kontakt)
			 break;
		    nc_list = nc_list->next;
	       }
	       
	       if (nc_list == NULL) {
		    TCPConnectChat( ruser->port, ruser->uin, csession);
	       }
	  }
     }
     
     Word_2_Chars( paka.version, 0x00000004 );
     DW_2_Chars( paka.chat_port, ccontact->port );
     DW_2_IP( paka.ip_local, our_ip );
     DW_2_IP( paka.ip_remote, our_ip );
     paka.four = 0x04;
     Word_2_Chars( paka.our_port, our_port );
     DW_2_Chars( paka.font_size, font_size );
     DW_2_Chars( paka.font_face, FONT_PLAIN );
     Word_2_Chars( paka.font_length, strlen( font_name ) + 1 );
     
     Word_2_Chars( pakb.one, 0x0002 ); /* or 0x4200 */
     
     packet_size = sizeof( begin_chat_a ) + sizeof( begin_chat_b ) + strlen( font_name ) + 1;
     buffer = (BYTE*)g_malloc0( packet_size );
     
     Word_2_Chars (buffer, packet_size);
     memcpy( buffer+2, &paka, sizeof( begin_chat_a ) );
     memcpy( buffer+2 + sizeof( begin_chat_a ), font_name, strlen( font_name ) + 1 );
     memcpy( buffer+3 + sizeof( begin_chat_a ) + strlen( font_name ), &pakb, sizeof( begin_chat_b ) );
     write( sock, buffer, packet_size + 2 );
     packet_print( buffer + 2, packet_size,
		   PACKET_TYPE_TCP | PACKET_DIRECTION_SEND, "CHAT(BEGIN)" );
     g_free( buffer );

     g_free( font_copy );

     ccontact->gdk_input =
	  gdk_input_add(ccontact->socket, GDK_INPUT_READ,
			(GdkInputFunction) TCPChatRead, ccontact); 
}

void TCPChatRead(ChatContact *ccontact, int sock, GdkInputCondition cond)
{

     gchar c, zero;
     WORD font_length;
     WORD font_family;
     DWORD font_style;
     WORD font_size = 12;
     gchar *font_name;

     gchar *message;

#ifdef TRACE_FUNCTION
     g_print("TCPChatRead\n");
#endif

     if( ( read( sock, &c, 1 ) ) <= 0 )
     {

	  message = g_strdup_printf (_("%s has left the chat session."), ccontact->contact->nick );
	  gtk_widget_show( gnome_message_box_new( _(message),
						  GNOME_MESSAGE_BOX_INFO,
						  GNOME_STOCK_BUTTON_OK,
						  NULL ) );
	  PartChatSession(ccontact);
	  return;

     }

     switch( c )
     {
     case 0x00: /* Change foreground color */
	  read( sock, &ccontact->fg_red, 1 );
	  read( sock, &ccontact->fg_green, 1 );
	  read( sock, &ccontact->fg_blue, 1 );
	  read( sock, &zero, 1 );
	  break;
     case 0x01: /* Change background color */
	  read( sock, &ccontact->bg_red, 1 );
	  read( sock, &ccontact->bg_green, 1 );
	  read( sock, &ccontact->bg_blue, 1 );
	  read( sock, &zero, 1 );
	  break;
     case 0x04: /* User is away */
	  ccontact->away = time(NULL);
	  break;
	  
     case 0x03: /* User is back */
	  ccontact->away = -1;
	  break;
     case 0x07: /* Beep */
	  gnomeicu_event( EV_CHATBEEP , 0 );
	  break;
     case 0x08: /* Backspace */
	  DelCharacter(ccontact);
	  break;
     case 0x0D: /* CR/LF */
	  AddNewline(ccontact);
	  break;
     case 0x10: /* Change font */
	  read( sock, &font_length, 2 );
	  font_length = GINT16_FROM_LE (font_length);
	  font_name = (char*)g_malloc0( font_length );
	  read( sock, font_name, font_length );
	  read( sock, &font_family, 2 );
	  font_family = GINT16_FROM_LE (font_family);
	  g_free( font_name );
	  break;
     case 0x11: /* Change font style */
	  read( sock, &font_style, 4 );
	  font_style = GINT32_FROM_LE (font_style);
	  break;
     case 0x12: /* Change font size */
	  read( sock, &font_size, 4 );
	  font_size = GINT32_FROM_LE (font_size);
	  break; 
     default:
	  AddCharacter(ccontact, c);
     }
     
}

