/*
 *  Copyright (C) 2000 Nate Case 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "eel-gconf-extensions.h"
#include <gtk/gtk.h>

/**
 * prefs_generic_mozilla_string_notify: update mozilla pref to match galeon prefs.
 * 	user_data should match the mozilla key
 */
void
prefs_generic_mozilla_string_notify(GConfClient *client,
				    guint cnxn_id,
				    GConfEntry *entry,
				    gpointer user_data);

/**
 * prefs_generic_mozilla_int_notify: update mozilla pref to match galeon prefs.
 * 	user_data should match the mozilla key
 */
void
prefs_generic_mozilla_int_notify(GConfClient *client,
				 guint cnxn_id,
				 GConfEntry *entry,
				 gpointer user_data);

/**
 * prefs_generic_mozilla_bool_notify: update mozilla prefs 
 * to match galeon prefs.
 * 	user_data should match the mozilla key
 */
void
prefs_generic_mozilla_bool_notify(GConfClient *client,
				  guint cnxn_id,
				  GConfEntry *entry,
				  gpointer user_data);

/**
 * mozilla_notifiers_init : installs notifiers for a few mozilla prefs
 * (the prefs which can be changed in the settings menu)
 */
void 
mozilla_notifiers_init(void);


/* HACK set all mozilla related keys, so mozilla prefs
   get initialized correctly, used on newuser */
void mozilla_notifiers_set_defaults(void);
