/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * New code Copyright (C) 2001 Philip Langdale
 *
 * This code is based on Original Code from nsISimpleURI.cpp
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Pierre Phaneuf <pp@ludusdesign.com>
 *   Gagan Saksena <gagan@netscape.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "gGnomeHelpUrl.h"
#include "gUrlCID.h"
#include "nscore.h"
#include "nsCRT.h"
#include "nsString.h"
#include "nsReadableUtils.h"
#include "prmem.h"
#include "prprf.h"
#include "nsURLHelper.h"
#include "nsNetCID.h"
#include "nsIObjectInputStream.h"
#include "nsIObjectOutputStream.h"
#include "nsEscape.h"

static NS_DEFINE_CID(kGnomeHelpURLCID, G_GNOMEHELPURL_CID);
static NS_DEFINE_IID(kISupportsIID, NS_ISUPPORTS_IID);

////////////////////////////////////////////////////////////////////////////////
// gGnomeHelpUrl methods:

gGnomeHelpUrl::gGnomeHelpUrl(nsISupports* outer)
    : mScheme(""), mPath(""), mFilePath(""), mQuery(""), mRef("")
{
    NS_INIT_AGGREGATED(outer);
}

gGnomeHelpUrl::~gGnomeHelpUrl() {}

NS_IMPL_AGGREGATED(gGnomeHelpUrl);

NS_IMETHODIMP
gGnomeHelpUrl::AggregatedQueryInterface(const nsIID& aIID, void** aInstancePtr)
{
    NS_ENSURE_ARG_POINTER(aInstancePtr);

    if (aIID.Equals(kISupportsIID)) {
        *aInstancePtr = GetInner();
    } else if (aIID.Equals(kGnomeHelpURLCID) || // used by Equals
               aIID.Equals(NS_GET_IID(nsIURI))) {
        *aInstancePtr = NS_STATIC_CAST(nsIURI*, this);
    } else if (aIID.Equals(NS_GET_IID(nsISerializable))) {
        *aInstancePtr = NS_STATIC_CAST(nsISerializable*, this);
    } else if (aIID.Equals(NS_GET_IID(nsIURL))) {
        *aInstancePtr = NS_STATIC_CAST(nsIURL*, this);
    } else {
        *aInstancePtr = nsnull;
        return NS_NOINTERFACE;
    }
    NS_ADDREF((nsISupports*)*aInstancePtr);
    return NS_OK;
}

////////////////////////////////////////////////////////////////////////////////
// nsISerializable methods:

NS_IMETHODIMP
gGnomeHelpUrl::Read(nsIObjectInputStream* aStream)
{
    nsresult rv;

    nsXPIDLCString buf;

    rv = aStream->ReadStringZ(getter_Copies(buf));
    if (NS_FAILED(rv)) return rv;
    mScheme = buf;
 
    rv = aStream->ReadStringZ(getter_Copies(buf));
    if (NS_FAILED(rv)) return rv;
    mPath = buf;

    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::Write(nsIObjectOutputStream* aStream)
{
    nsresult rv;
 
    rv = aStream->WriteStringZ(mScheme.get());
    if (NS_FAILED(rv)) return rv;
    
    rv = aStream->WriteStringZ(mPath.get());
    if (NS_FAILED(rv)) return rv;
  
    return NS_OK;
}

////////////////////////////////////////////////////////////////////////////////
// nsIURI methods:

NS_IMETHODIMP
gGnomeHelpUrl::GetSpec(nsACString &result)
{
    result = mScheme + NS_LITERAL_CSTRING(":") + mPath;
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetSpec(const nsACString &aSpec)
{
    nsCAutoString spec;
    
    // nsSimpleURI currently restricts the charset to US-ASCII
    NS_EscapeURL(PromiseFlatCString(aSpec), esc_OnlyNonASCII|esc_AlwaysCopy, spec);

    PRInt32 posSpec = spec.Find(":");
    if (posSpec == -1)
        return NS_ERROR_FAILURE;

    mScheme.Truncate();
    mPath.Truncate();
    mFilePath.Truncate();
    mQuery.Truncate();
    mRef.Truncate();

    PRInt32 n = spec.Left(mScheme, posSpec);
    NS_ASSERTION(n == posSpec, "Left failed");

    PRInt32 end = spec.Length() - posSpec - 1;
    n = spec.Mid(mPath, posSpec + 1, end);
    NS_ASSERTION(n == end, "Mid failed");

    PRInt32 posQuery = mPath.Find("?");
    PRInt32 posRef = mPath.Find("#");

    if (posQuery != -1 && posRef == -1)
    {
        n = mPath.Left(mFilePath, posQuery);
	NS_ASSERTION(n == posQuery, "Left failed");
	end = mPath.Length() - posQuery - 1;
	n = mPath.Mid(mQuery, posQuery +1, end);
        NS_ASSERTION(n == end, "Mid failed");
    }
    else if (posRef != -1 && posQuery == -1)
    {
        n = mPath.Left(mFilePath, posRef);
	NS_ASSERTION(n == posRef, "Left failed");
	end = mPath.Length() - posRef - 1;
	n = mPath.Mid(mRef, posRef +1, end);
        NS_ASSERTION(n == end, "Mid failed");
    }
    else if (posRef != -1 && posQuery != -1)
    {
        n = mPath.Left(mFilePath, posQuery);
	NS_ASSERTION(n == posQuery, "Left failed");
	end = posRef -posQuery -1;
        n = mPath.Mid(mQuery, posQuery +1, end);
	NS_ASSERTION(n == end, "Mid failed");
	end = mPath.Length() - posRef - 1;
	n = mPath.Mid(mRef, posRef +1, end);
        NS_ASSERTION(n == end, "Mid failed");
    }
    else
    {
        mFilePath = mPath;
    }

    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetScheme(nsACString &result)
{
    result = mScheme;
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetScheme(const nsACString &scheme)
{
    mScheme = scheme;
    ToLowerCase(mScheme);
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetPrePath(nsACString &result)
{
    result = mScheme + NS_LITERAL_CSTRING(":");
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetUserPass(nsACString &result)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetUserPass(const nsACString &userPass)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetUsername(nsACString &result)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetUsername(const nsACString &userName)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetPassword(nsACString &result)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetPassword(const nsACString &password)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetHost(nsACString &result)
{
    PRInt32 posSlash = mFilePath.Find("/");
#ifdef NS_DEBUG
    PRInt32 n = mFilePath.Left(result, posSlash);
#else
    mFilePath.Left(result, posSlash);
#endif
    NS_ASSERTION(n == posSlash, "Left failed");
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetHost(const nsACString &host)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetHostPort(nsACString &result)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetHostPort(const nsACString &hostPort)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetPort(PRInt32 *result)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetPort(PRInt32 port)
{
    return NS_ERROR_FAILURE;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetPath(nsACString &result)
{
    result = mPath;
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::SetPath(const nsACString &path)
{
    mPath = path;
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::Equals(nsIURI* other, PRBool *result)
{
    PRBool eq = PR_FALSE;
    if (other) {
        gGnomeHelpUrl* otherUrl;
        nsresult rv =
            other->QueryInterface(kGnomeHelpURLCID,
                                  (void**)&otherUrl);
        if (NS_SUCCEEDED(rv)) {
            eq = PRBool((0 == PL_strcmp(mScheme.get(), otherUrl->mScheme.get())) && 
                        (0 == PL_strcmp(mPath.get(), otherUrl->mPath.get())));
            NS_RELEASE(otherUrl);
        }
    }
    *result = eq;
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::SchemeIs(const char *i_Scheme, PRBool *o_Equals)
{
    NS_ENSURE_ARG_POINTER(o_Equals);
    if (!i_Scheme) return NS_ERROR_NULL_POINTER;

    const char *this_scheme = mScheme.get();
    
    // mScheme is guaranteed to be lower case.
    if (*i_Scheme == *this_scheme || *i_Scheme == (*this_scheme - ('a' - 'A')) ) {
        *o_Equals = PL_strcasecmp(this_scheme, i_Scheme) ? PR_FALSE : PR_TRUE;
    } else {
        *o_Equals = PR_FALSE;
    }

    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::Clone(nsIURI* *result)
{
    gGnomeHelpUrl* url = new gGnomeHelpUrl(nsnull);     // XXX outer?
    if (url == nsnull)
        return NS_ERROR_OUT_OF_MEMORY;
    
    url->mScheme = mScheme;
    url->mPath = mPath;

    *result = url;
    NS_ADDREF(url);
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::Resolve(const nsACString &relativePath, nsACString &result) 
{
    result = relativePath;
    return NS_OK;
}

NS_IMETHODIMP
gGnomeHelpUrl::GetAsciiSpec(nsACString &result)
{
    nsCAutoString buf;
    nsresult rv = GetSpec(buf);
    if (NS_FAILED(rv)) return rv;
    NS_EscapeURL(buf, esc_OnlyNonASCII|esc_AlwaysCopy, result);
    return NS_OK;
}
    
NS_IMETHODIMP
gGnomeHelpUrl::GetAsciiHost(nsACString &result)
{
    result.Truncate();
    return NS_OK;
}                                 

NS_IMETHODIMP
gGnomeHelpUrl::GetOriginCharset(nsACString &result)
{
    result.Truncate();
    return NS_OK;
}   

////////////////////////////////////////////////////////////////////////////////

NS_METHOD
gGnomeHelpUrl::Create(nsISupports *aOuter, REFNSIID aIID, void **aResult)
{
    NS_ENSURE_ARG_POINTER(aResult);
     NS_ENSURE_PROPER_AGGREGATION(aOuter, aIID);

    gGnomeHelpUrl* url = new gGnomeHelpUrl(aOuter);
    if (url == nsnull)
        return NS_ERROR_OUT_OF_MEMORY;

    nsresult rv = url->AggregatedQueryInterface(aIID, aResult);

     if (NS_FAILED(rv))
         delete url;
    return rv;
}

////////////////////////////////////////////////////////////////////////////////
// nsIURL methods:

/* attribute string filePath; */
NS_IMETHODIMP gGnomeHelpUrl::GetFilePath(nsACString &result)
{
    result = mFilePath;
    return NS_OK;
}
NS_IMETHODIMP gGnomeHelpUrl::SetFilePath(const nsACString &aFilePath)
{
    mFilePath = aFilePath;
    return NS_OK;
}

/* attribute string param; */
NS_IMETHODIMP gGnomeHelpUrl::GetParam(nsACString &result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP gGnomeHelpUrl::SetParam(const nsACString &aParam)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string query; */
NS_IMETHODIMP gGnomeHelpUrl::GetQuery(nsACString &result)
{
    result = mQuery;
    return NS_OK;
}
NS_IMETHODIMP gGnomeHelpUrl::SetQuery(const nsACString &aQuery)
{
    mQuery = aQuery;
    return NS_OK;
}

/* attribute string ref; */
NS_IMETHODIMP gGnomeHelpUrl::GetRef(nsACString &result)
{
    result = mRef;
    return NS_OK;
}
NS_IMETHODIMP gGnomeHelpUrl::SetRef(const nsACString &aRef)
{
    mRef = aRef;
    return NS_OK;
}

/* attribute string directory; */
NS_IMETHODIMP gGnomeHelpUrl::GetDirectory(nsACString &result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP gGnomeHelpUrl::SetDirectory(const nsACString &aDirectory)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string fileName; */
NS_IMETHODIMP gGnomeHelpUrl::GetFileName(nsACString &result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP gGnomeHelpUrl::SetFileName(const nsACString &aFileName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string fileBaseName; */
NS_IMETHODIMP gGnomeHelpUrl::GetFileBaseName(nsACString &result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP gGnomeHelpUrl::SetFileBaseName(const nsACString &aFileBaseName)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute string fileExtension; */
NS_IMETHODIMP gGnomeHelpUrl::GetFileExtension(nsACString &result)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP gGnomeHelpUrl::SetFileExtension(const nsACString &aFileExtension)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* AUTF8String getCommonBaseSpec (in nsIURI aURIToCompare); */
NS_IMETHODIMP gGnomeHelpUrl::GetCommonBaseSpec(nsIURI *aURIToCompare, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
 
/* AUTF8String getRelativeSpec (in nsIURI aURIToCompare); */
NS_IMETHODIMP gGnomeHelpUrl::GetRelativeSpec(nsIURI *aURIToCompare, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

////////////////////////////////////////////////////////////////////////////////

