/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <gtk/gtk.h>

#include "ExternalProtocolService.h"

#include "nsString.h"
#include "nsXPIDLString.h"
#include "nsIMailtoUrl.h"
#include "nsCOMPtr.h"
#include "nsIURI.h"

extern "C" {
#include "prefs_strings.h"
#include "eel-gconf-extensions.h"

#include <libgnomeui/gnome-dialog-util.h>
#include <libgnomeui/gnome-messagebox.h>
#include <libgnome/gnome-exec.h>
#include <libgnomeui/gnome-stock.h>
#include <libgnome/gnome-i18n.h>
#include <libgnome/gnome-url.h>
#include <libgnome/gnome-config.h>
}

void OpenLegacyMailer(char *format, nsIMailtoUrl *aURL, const char *url);

/* Implementation file */
NS_IMPL_ISUPPORTS1(GExternalProtocolService, nsIExternalProtocolService)

GExternalProtocolService::GExternalProtocolService()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

GExternalProtocolService::~GExternalProtocolService()
{
  /* destructor code */
}

/* boolean externalProtocolHandlerExists (in string aProtocolScheme); */
NS_IMETHODIMP GExternalProtocolService::
		ExternalProtocolHandlerExists(const char *aProtocolScheme,
					      PRBool *_retval)
{
	*_retval = PR_FALSE;

	nsCString cProtocolScheme = aProtocolScheme;
	cProtocolScheme.Append("-show");

	nsXPIDLCString key, value;
	for (void *pI = gnome_config_init_iterator ("/Gnome/URL Handlers/") ;
	     pI !=NULL ;
	     pI = gnome_config_iterator_next (pI, getter_Copies(key),
					      getter_Copies(value)))
	{
		if (cProtocolScheme.Equals(key))
		{
			*_retval = PR_TRUE;
			break;
		}
	};
	return NS_OK;
}

/* void loadUrl (in nsIURI aURL); */
NS_IMETHODIMP GExternalProtocolService::LoadUrl(nsIURI *aURL)
{
	gchar *mailer;
	nsCString cSpec;
	aURL->GetSpec (cSpec);
	nsXPIDLCString cScheme;
	aURL->GetScheme (cScheme);

	nsCOMPtr<nsIMailtoUrl> mailUrl;
	mailUrl = do_QueryInterface (aURL);
	if (mailUrl)
	{
		mailer = eel_gconf_get_string (CONF_PROGRAMS_MAILER);
	
		if (mailer && strcmp (mailer, "Gnome") != 0)
		{
			OpenLegacyMailer (mailer, mailUrl, cSpec.get());
			return NS_OK;
		}
	}

	/* build the config key */

	nsCString key = NS_LITERAL_CSTRING("/Gnome/URL Handlers/") +
			cScheme + NS_LITERAL_CSTRING("-show");

	/* find it */
	nsCString result = gnome_config_get_string(key.get());
	if (result.Length() != 0)
	{
		gnome_url_show(cSpec.get());
		return NS_OK;
	}

	/* no luck, so offer the user the option of trying the
	 * default handler -- we don't do this automatically in
	 * case the default handler is erroneously set to galeon */
	result = gnome_config_get_string("/Gnome/URL Handlers/default-show");

		/* check there is a default */
	if (result.IsEmpty())
	{
		/* throw the error */
		gnome_error_dialog(_("Galeon cannot handle this protocol,\n"
				     "and no GNOME default handler is set"));

		/* don't let mozilla try blindly */
		return NS_ERROR_FAILURE;
	}

	/* offer the choice */
	GtkWidget *dialog = gnome_message_box_new (_("The protocol specified "
						     "is not recognised.\n\n"
						     "Would you like to try "
						     "the GNOME default?"),
						   GNOME_MESSAGE_BOX_QUESTION,
						   GNOME_STOCK_BUTTON_YES,
						   GNOME_STOCK_BUTTON_NO,
						   NULL);
	int ret = gnome_dialog_run (GNOME_DIALOG(dialog));
	if (ret == 0)
	{
		gnome_url_show(cSpec.get());		
		return NS_OK;
	}
	else
	{
		return NS_ERROR_FAILURE;
	}
}

/*
 * Open a legacy mailer according to preferences command
 *
 * Options:
 *
 * %t To
 * %c Cc
 * %b Bcc
 * %k Organization
 * %w News host
 * %n News group
 * %p Priority
 * %a Attachment
 * %e Reference
 * %h Html
 * %y Body
 * %s Subject
 * %r Reply
 * %o Follow up
 * %u Unchanged URL
 * [ ] ignore all content if the part is null
 */
void OpenLegacyMailer(char *format, nsIMailtoUrl *aURL, const char *url)
{
	gchar *ToPart, *CcPart, *BccPart, *FromPart, 
		*FollowUpToPart, *OrganizationPart, 
		*ReplyToPart, *SubjectPart, *BodyPart, 
		*HtmlPart, *ReferencePart, *AttachmentPart, 
		*PriorityPart, *NewsgroupPart, *NewsHostPart;
	/* FIXME not used */
	gboolean forcePlainText;
	
	int length, i, j, subpos = -1;
	const char *copy;
	char *command;

	aURL->GetMessageContents (&ToPart, 
				  &CcPart, 
				  &BccPart, 
				  &FromPart, 
				  &FollowUpToPart, 
				  &OrganizationPart, 
				  &ReplyToPart, 
				  &SubjectPart, 
				  &BodyPart, 
				  &HtmlPart, 
				  &ReferencePart, 
				  &AttachmentPart, 
				  &PriorityPart, 
				  &NewsgroupPart, 
				  &NewsHostPart, 
				  &forcePlainText);

	/* get the format string */
        length = strlen (format);

        /* make a target string of maximal size */
        command = (char *) malloc (length + 
			   (ToPart != NULL ? strlen (ToPart) : 0) + 
			   (CcPart != NULL ? strlen (CcPart) : 0) +
			   (FromPart != NULL ? strlen (FromPart) : 0) + 
			   (FollowUpToPart != NULL ? strlen (FollowUpToPart) : 0) +
			   (OrganizationPart != NULL ? strlen (OrganizationPart) : 0) + 
			   (ReplyToPart != NULL ? strlen (ReplyToPart) : 0) +
			   (SubjectPart != NULL ? strlen (SubjectPart) : 0) +
			   (BodyPart != NULL ? strlen (BodyPart) : 0) +
			   (HtmlPart != NULL ? strlen (HtmlPart) : 0) +
			   (ReferencePart != NULL ? strlen (ReferencePart) : 0) +
			   (AttachmentPart != NULL ? strlen (AttachmentPart) : 0) +
			   (PriorityPart != NULL ? strlen (PriorityPart) : 0) +
			   (NewsgroupPart != NULL ? strlen (NewsgroupPart) : 0) +
			   (NewsHostPart != NULL ? strlen (NewsHostPart) : 0) +
			   (BccPart != NULL ? strlen (BccPart) : 0) +
			   (url != NULL ? strlen (url) : 0));
                                  
        /* parse the format string doing substitutions */
        for (i = 0, j = 0; i < length; i++)
        {
		if (format[i] == '[')
		{
			subpos = j;
		}
		else if (format[i] == ']')
		{
			subpos = -1;
		}
		else if (format[i] == '%' && (i == 0 || format[i - 1] != '\\'))
                {
                        /* check the format character */
                        switch (format[++i])
                        {
                        case 'k':
                                copy = OrganizationPart;
                                break;
                        case 'w':
                                copy = NewsHostPart;
                                break;
                        case 'n':
                                copy = NewsgroupPart;
                                break;
                        case 'p':
                                copy = PriorityPart;
                                break;
                        case 'a':
                                copy = AttachmentPart;
                                break;
                        case 'e':
                                copy = ReferencePart;
                                break;
                        case 'h':
                                copy = HtmlPart;
                                break;
                        case 'y':
                                copy = BodyPart;
                                break;
                        case 's':
                                copy = SubjectPart;
                                break;
                        case 'r':
                                copy = ReplyToPart;
                                break;
                        case 'o':
                                copy = FollowUpToPart;
                                break;
                        case 'f':
                                copy = FromPart;
                                break;
                        case 't':
                                copy = ToPart;
                                break;
                        case 'c':
                                copy = CcPart;
                                break;
                        case 'b':
                                copy = BccPart;
                                break;
                        case 'u':
                                copy = url;
                                break;
                        default:
                                copy = NULL;
                                break;
                        }
                        
                        /* copy substitute string */
                        if (copy != NULL && strlen (copy) > 0)
                        {
				strcpy (command + j, copy);
                                j += strlen (copy);
                        }
			else
			{
				if (subpos>0)
				{
					j = subpos - 1;
					while (i<length &&
					       format[i] != ']')
					{
						i++;
					}
					subpos = -1;
				}
			}
                }
                else
                {
                        command[j++] = format[i];
                }
        }
        command[j] = '\0';

        /* execute the command */
        gnome_execute_shell (NULL, command);
        
        /* free allocated strings */
	free (command);
        nsMemory::Free (ToPart);
	nsMemory::Free (CcPart); 
	nsMemory::Free (BccPart);
	nsMemory::Free (FromPart);
	nsMemory::Free (FollowUpToPart);
	nsMemory::Free (OrganizationPart);
	nsMemory::Free (ReplyToPart);
	nsMemory::Free (SubjectPart);
	nsMemory::Free (BodyPart);
	nsMemory::Free (HtmlPart);
	nsMemory::Free (ReferencePart);
	nsMemory::Free (AttachmentPart);
	nsMemory::Free (PriorityPart);
	nsMemory::Free (NewsgroupPart);
	nsMemory::Free (NewsHostPart);
}

