/*
 *  Copyright (C) 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __misc_general_h
#define __misc_general_h

#ifdef __cplusplus
extern "C" {
#endif

/* Galeon includes */
#include "galeon_types.h"

/* system includes */
#include <glib.h>
#include <gnome-xml/tree.h>

/* misc_general.c */
gchar *misc_general_user_file (gchar *fname, gboolean critical);
gchar *misc_general_read_line_from_file (FILE *f);
void misc_general_launch_external_viewer (const gchar *filename);
LinkState misc_general_key_state_to_link_state (guint evstate);
LinkState misc_general_mouse_state_to_link_state (guint button, guint evstate);
/* i haven't renamed these, because i'm not sure where they should go  -dan */
xmlAttrPtr xmlSetRawProp (xmlNodePtr node, const xmlChar *name,
			  const xmlChar *value);
xmlChar *xmlGetRawProp (xmlNodePtr node, const xmlChar *name);
gint xmlGetIntProp (xmlNodePtr node, const gchar *attribute);

#ifdef __cplusplus
}
#endif
#endif

