/*-
 * utimes.c --
 *
 *	This routine maps the 4.3BSD utimes system call onto the
 *	System V utime call.
 *
 * Copyright (c) 1988 by the Regents of the University of California
 * Copyright (c) 1988 by Adam de Boor
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  Neither the University of California nor
 * Adam de Boor makes any representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */
#ifndef lint
static char *rcsid = "$Id: utimes.c,v 1.7 1998/04/04 15:34:43 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include <sys/time.h>
#include <utime.h>

utimes(file, tvp)
    char *file;
    struct timeval *tvp;
{
    if (tvp == (struct timeval *)0) {
	return(utime(file, (struct utimbuf *)0));
    } else {
	struct utimbuf t;

	t.actime  = tvp[0].tv_sec;
	t.modtime = tvp[1].tv_sec;
	return(utime(file, &t));
    }
}
