/***********************************************************************
 *
 * PROJECT:	  PMake
 * MODULE:	  Customs -- OS dependencies
 * FILE:	  os-default.c
 *
 * AUTHOR:  	  Adam de Boor: Sep  9, 1989
 *
 * ROUTINES:
 *	Name	  	    Description
 *	----	  	    -----------
 *	OS_Init	    	    Initialize module and return mask of criteria
 *	    	    	    to be considered in determination.
 *	OS_Exit	    	    Undo any initialization.
 *	OS_Idle	    	    Return machine idle time, in seconds
 *	OS_Load	    	    Return machine load factor
 *	OS_Swap	    	    Return free swap space
 *	OS_Proc	    	    Return number of free processes
 *
 * REVISION HISTORY:
 *	Date	  Name	    Description
 *	----	  ----	    -----------
 *	3/29/94	  stolcke   Initial version
 *
 * DESCRIPTION:
 *	Dummy versions of the OS-dependent functions used by Customs.
 *	Only the OS_Idle() routine does real work, based on a generic
 *	utmp file lookup.
 *
 *	These functions are responsible for the determination of the
 *	current state of the system, returning it as a set of numbers
 *	in a customs-standard form, whatever form they may be in in the
 *	system itself.
 *
 *	The format used is the same as that transmitted for the AVAIL_SET
 *	RPC.
 *
 * 	Copyright (c) Berkeley Softworks 1989
 * 	Copyright (c) Adam de Boor 1989
 *
 * 	Permission to use, copy, modify, and distribute this
 * 	software and its documentation for any non-commercial purpose
 *	and without fee is hereby granted, provided that the above copyright
 * 	notice appears in all copies.  Neither Berkeley Softworks nor
 * 	Adam de Boor makes any representations about the suitability of this
 * 	software for any purpose.  It is provided "as is" without
 * 	express or implied warranty.
 *
 *
 ***********************************************************************/
#ifndef lint
static char *rcsid =
"$Id: os-default.c,v 1.2 1994/10/22 02:37:09 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    <fcntl.h>
#include    <sys/types.h>
#include    <sys/stat.h>
#include    <time.h>
#include    <sys/file.h>
#include    <utmp.h>

#include    "customsInt.h"

#ifndef UTMP_FILE
#define UTMP_FILE	"/etc/utmp"
#endif
#define NO_UTHOST
#define DEV_CONSOLE	"/dev/console"

static int		utmpf;		/* Descriptor to /etc/utmp */


/***********************************************************************
 *				OS_Init
 ***********************************************************************
 * SYNOPSIS:	    Initialize this module
 * CALLED BY:	    Avail_Init
 * RETURN:	    Mask of AVAIL_* bits indicating what criteria are
 *	    	    to be examined.
 * SIDE EFFECTS:
 *
 * STRATEGY:
 *
 * REVISION HISTORY:
 *	Name	Date		Description
 *	----	----		-----------
 *	ardeb	9/ 9/89		Initial Revision
 *
 ***********************************************************************/
int
OS_Init()
{
    if ((utmpf = open (UTMP_FILE, O_RDONLY, 0)) < 0) {
	/*
	 * If couldn't open /etc/utmp, we can't tell how long the machine's
	 * been idle.
	 */
	xlog (XLOG_WARNING,
		"OS_Init: cannot open or stat %s: disabling idle time check", 
		UTMP_FILE
	     );
	return (0);
    } else {
	/*
	 * Only thing supported here is idle time
	 */
	return (AVAIL_IDLE);
    }
}

/***********************************************************************
 *				OS_Exit
 ***********************************************************************
 * SYNOPSIS:	    Deinitialize this module
 * CALLED BY:	    CustomsRestart()
 * RETURN:	    Nothing
 * SIDE EFFECTS:    kmem and kbd are closed.
 *
 * STRATEGY:
 *
 * REVISION HISTORY:
 *	Name	Date		Description
 *	----	----		-----------
 *	stolcke	2/20/92		Initial Revision
 *
 ***********************************************************************/
void
OS_Exit()
{
    if (utmpf >= 0) {
	close(utmpf);
    }
    return;
}

/***********************************************************************
 *				OS_Swap
 ***********************************************************************
 * SYNOPSIS:	    Find the percentage of the system's swap space that
 *	    	    isn't being used.
 * CALLED BY:	    Avail_Local
 * RETURN:	    The percentage of free swap space
 * SIDE EFFECTS:    None
 *
 * STRATEGY:
 *	Is never called.
 *
 * REVISION HISTORY:
 *	Name	Date		Description
 *	----	----		-----------
 *	stolcke	3/29/94		Dummy version
 *
 ***********************************************************************/
int
OS_Swap()
{
    return (0);
}


/***********************************************************************
 *				OS_Proc
 ***********************************************************************
 * SYNOPSIS:	    Find the number of additional processes that can be
 *	    	    created.
 * CALLED BY:	    Avail_Local
 * RETURN:	    Number of free process slots
 * SIDE EFFECTS:    None
 *
 * STRATEGY:
 *	Is never called.
 *
 * REVISION HISTORY:
 *	Name	Date		Description
 *	----	----		-----------
 *	stolcke	3/29/94		Dummy version
 *
 ***********************************************************************/
int
OS_Proc()
{
    return (0);
}


/***********************************************************************
 *				OS_Load
 ***********************************************************************
 * SYNOPSIS:	    Return the current load average in standard form
 * CALLED BY:	    Avail_Local
 * RETURN:	    The current load as a 32-bit fixed-point number
 * SIDE EFFECTS:    None
 *
 * STRATEGY:
 *	None yet.
 *
 * REVISION HISTORY:
 *	Name	Date		Description
 *	----	----		-----------
 *	stolcke	3/29/94		Dummy version
 *
 ***********************************************************************/
unsigned int
OS_Load()
{
    return (0);
}

/*
 * Use generic code for OS_Idle()
 */
#include "os-idle.c"
