/*-
 * customsAvail.c
 *	Set availability interval and criteria 
 *
 * Copyright (c) 1988, 1989 by the Regents of the University of California
 * Copyright (c) 1988, 1989 by Adam de Boor
 * Copyright (c) 1989 by Berkeley Softworks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any non-commercial purpose
 * and without fee is hereby granted, provided that the above copyright
 * notice appears in all copies.  The University of California,
 * Berkeley Softworks and Adam de Boor make no representations about
 * the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 */
#ifndef lint
static char *rcsid =
"$Id: customsAvail.c,v 1.2 1995/12/31 04:30:11 stolcke Exp $ ICSI (Berkeley)";
#endif /* not lint */

#include    "customs.h"


/*-
 *-----------------------------------------------------------------------
 * Customs_AvailInterval --
 *	Set the interval at which the local agent informs the master of
 *	its availability.
 *
 * Results:
 *	The status of the call.
 *
 * Side Effects:
 *	See above.
 *
 *-----------------------------------------------------------------------
 */
Rpc_Stat
Customs_AvailInterval(interval)
    struct timeval	*interval;
{
    Time_Interval myInterval;

    myInterval.tv_sec = interval->tv_sec;
    myInterval.tv_usec = interval->tv_usec;

    if (customs_Socket == -1) {
	Customs_Init();
    }
    customs_Status = Rpc_Call(customs_Socket, &customs_AgentAddr,
			  (Rpc_Proc)CUSTOMS_AVAILINTV,
			  sizeof(myInterval), (Rpc_Opaque)&myInterval,
			  0, (Rpc_Opaque)0,
			  CUSTOMS_NRETRY, &customs_RetryTimeOut);
    return(customs_Status);
}

/*-
 *-----------------------------------------------------------------------
 * Customs_SetAvail --
 *	Change the availability criteria for the local machine.
 *
 * Results:
 *	The status of the call. If RPC_SUCCESS, criteria is overwritten
 *	with the current/new criteria and criteria->changeMask contains
 *	bits to indicate which, if any, values of the passed criteria
 *	were out-of-bounds.
 *
 * Side Effects:
 *	The criteria are changed if all are acceptable.
 *
 *-----------------------------------------------------------------------
 */
Rpc_Stat
Customs_SetAvail(criteria)
    Avail_Data	  *criteria;
{
    if (customs_Socket == -1) {
	Customs_Init();
    }
    customs_Status = Rpc_Call(customs_Socket, &customs_AgentAddr,
			  (Rpc_Proc)CUSTOMS_SETAVAIL,
			  sizeof(Avail_Data), (Rpc_Opaque)criteria,
			  sizeof(Avail_Data), (Rpc_Opaque)criteria,
			  CUSTOMS_NRETRY, &customs_RetryTimeOut);
    return(customs_Status);
}
