/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2002 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks_mainwindow.c - callbacks for the main window
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "callbacks_mainwindow.h"
#include "interface.h"
#include "support.h"
#include "types.h"
#include "utils.h"
#include "types.h"
#include "log.h"
#include "hamlib-utils.h"

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern preferencestype preferences;
extern statetype state;
extern GList *logwindowlist;

#if WANT_HAMLIB
	extern GdkPixmap *pixmap;
#endif

/* catch keys for the main window, so we can have shortcuts */
gboolean on_mainwindow_key_press_event (GtkWidget *widget, GdkEventKey *event, gpointer user_data) {
	GtkWidget *abutton, *ubutton, *dbutton;
	GtkWidget *menubar, *save, *clear, *search, *new, *close;
	GtkAdjustment *adj;
	GList *selection;
	gint current_row;
	logtype *logwindow;


	switch (event->keyval) {
		case GDK_Control_L: /* did we push the control key ?*/
		case GDK_Control_R:
			state.controlkey = TRUE;
			return TRUE;
			break;
		case GDK_a: /* control a = add a QSO */
			if (state.controlkey) {
				abutton = lookup_widget(mainwindow, "abutton");
				gtk_signal_emit_by_name(GTK_OBJECT(abutton),"clicked");
			}
			return TRUE;
			break;
		case GDK_u: /* control u = update a selected QSO */
			if (state.controlkey) {
				ubutton = lookup_widget(mainwindow, "ubutton");
				gtk_signal_emit_by_name(GTK_OBJECT(ubutton),"clicked");
			}
			return TRUE;
			break;
		case GDK_d: /* control d = delete a selected QSO from the log */
			if (state.controlkey) {
				dbutton = lookup_widget(mainwindow, "dbutton");
				gtk_signal_emit_by_name(GTK_OBJECT(dbutton),"clicked");
			}
			return TRUE;
			break;
		case GDK_s: /* control s = save log */
			if (state.controlkey) {
				state.controlkey = FALSE;
				menubar = lookup_widget(mainwindow, "menubar");
				save = lookup_widget(menubar, "save");
				gtk_signal_emit_by_name(GTK_OBJECT(save),"activate");
			}
			return TRUE;
			break;
		case GDK_y: /* control y = clear qso frame */
			if (state.controlkey) {
				clear = lookup_widget(create_qsoframemenu(), "clearframe1");
				gtk_signal_emit_by_name(GTK_OBJECT(clear),"activate");
			}
			return TRUE;
			break;
		case GDK_f: /* control f = find QSO in the log */
			if (state.controlkey) {
				state.controlkey = FALSE;
				menubar = lookup_widget(mainwindow, "menubar");
				search = lookup_widget(menubar, "search");
				gtk_signal_emit_by_name(GTK_OBJECT(search),"activate");
			}
			return TRUE;
			break;
		case GDK_n: /* control n = new log */
			if (state.controlkey) {
				menubar = lookup_widget(mainwindow, "menubar");
				new = lookup_widget(menubar, "new");
				gtk_signal_emit_by_name(GTK_OBJECT(new),"activate");
			}
			return TRUE;
			break;
		case GDK_q: /* control q = close log */
			if (state.controlkey) {
				state.controlkey = FALSE;
				menubar = lookup_widget(mainwindow, "menubar");
				close = lookup_widget(menubar, "close");
				gtk_signal_emit_by_name(GTK_OBJECT(close),"activate");
			}
			return TRUE;
			break;
		case GDK_Page_Up: /* PgUp can scroll the log */
			logwindow =  g_list_nth_data(logwindowlist, 
				gtk_notebook_get_current_page(GTK_NOTEBOOK(mainnotebook)));
			adj = gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(logwindow->scrolledwindow));
			gtk_adjustment_set_value(adj,adj->value-adj->page_size);
		break;
		case GDK_Page_Down: /* PgDn can scroll the log */
			logwindow =  g_list_nth_data(logwindowlist, 
				gtk_notebook_get_current_page(GTK_NOTEBOOK(mainnotebook)));
			adj = gtk_scrolled_window_get_vadjustment(GTK_SCROLLED_WINDOW(logwindow->scrolledwindow));
			if (adj->value < adj->upper - adj->page_size)
				gtk_adjustment_set_value(adj, adj->value+adj->page_size);
		break;
		case GDK_Up: /* Up Arrow, select previous QSO */
			logwindow =  g_list_nth_data(logwindowlist, 
				gtk_notebook_get_current_page(GTK_NOTEBOOK(mainnotebook)));
			selection = GTK_CLIST(logwindow->clist)->selection;
			if (selection) {
				current_row = (gint)selection->data;
				if (current_row > 0) {
				if (gtk_clist_row_is_visible(GTK_CLIST(logwindow->clist), current_row - 1) != GTK_VISIBILITY_FULL)
					gtk_clist_moveto(GTK_CLIST(logwindow->clist), current_row - 1, -1, 0, 0);
					gtk_clist_select_row(GTK_CLIST(logwindow->clist), current_row - 1, 0);
				}
			}
		break;
		case GDK_Down: /* Down Arrow, select next QSO */
			logwindow =  g_list_nth_data(logwindowlist, 
                        gtk_notebook_get_current_page(GTK_NOTEBOOK(mainnotebook)));
			selection = GTK_CLIST(logwindow->clist)->selection;
			if (selection) {
				current_row = (gint)selection->data;
				if (current_row < GTK_CLIST(logwindow->clist)->rows - 1) {
				if (gtk_clist_row_is_visible(GTK_CLIST(logwindow->clist), current_row + 1) != GTK_VISIBILITY_FULL)
					gtk_clist_moveto(GTK_CLIST(logwindow->clist), current_row + 1, -1, 1, 0);
					gtk_clist_select_row(GTK_CLIST(logwindow->clist), current_row + 1, 0);
				}
			}
		break;
		default:
		break;
	}
	return FALSE;
}

/* did we release the control key ? */
gboolean on_mainwindow_key_release_event (GtkWidget *widget, GdkEventKey *event, gpointer user_data) {
	switch (event->keyval) {
		case GDK_Control_L:
		case GDK_Control_R:
			state.controlkey = FALSE;
			return TRUE;
			break;
		default:
			break;
	}
	return FALSE;
}

/* capture the delete event and display a warning in case the log has not been saved */
gboolean on_mainwindow_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data) {
	GtkWidget *savedialog;
	gint i;
	logtype *logwindow;
	gboolean logchanged = FALSE;

	for (i = 0; i < g_list_length(logwindowlist); i++)
	{
		logwindow = g_list_nth_data(logwindowlist, i);
		if (logwindow->logchanged) logchanged = TRUE;
	}

	if (logchanged) {
		savedialog = create_savedialog();
		gtk_widget_set_sensitive(mainwindow, 0);
		gtk_widget_show(savedialog);
		return(TRUE);
	}
	else {
		save_windowsize_and_cleanup();
		gtk_exit(0);
		return(FALSE);
	}
}
