/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.https;

import com.sun.net.ssl.internal.ssl.SSLSocketFactoryImpl;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import sun.misc.RegexpPool;
import sun.net.NetworkClient;
import sun.net.www.http.HttpClient;
import sun.security.action.GetPropertyAction;
import sun.security.x509.X500Name;

final class HttpsClient
extends HttpClient
implements HandshakeCompletedListener {
    private static final int a = 443;
    private HostnameVerifier b;
    private SSLSocketFactory c;
    private String d;
    private int e;
    private SSLSession f;

    protected int getDefaultPort() {
        return 443;
    }

    private String getProxyHost() {
        String string = AccessController.doPrivileged(new GetPropertyAction("https.proxyHost"));
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private int getProxyPort() {
        final int[] nArray = new int[]{0};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.getProperty("https.proxyHost") != null) {
                    nArray[0] = Integer.getInteger("https.proxyPort", 80);
                }
                return null;
            }
        });
        return nArray[0] < 0 ? super.getDefaultPort() : nArray[0];
    }

    private String[] e() {
        String[] stringArray;
        String string = AccessController.doPrivileged(new GetPropertyAction("https.cipherSuites"));
        if (string == null || "".equals(string)) {
            stringArray = null;
        } else {
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                vector.addElement(stringTokenizer.nextElement());
            }
            stringArray = new String[vector.size()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
        }
        return stringArray;
    }

    private String[] f() {
        String[] stringArray;
        String string = AccessController.doPrivileged(new GetPropertyAction("https.protocols"));
        if (string == null || "".equals(string)) {
            stringArray = null;
        } else {
            Vector<Object> vector = new Vector<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                vector.addElement(stringTokenizer.nextElement());
            }
            stringArray = new String[vector.size()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = (String)vector.elementAt(n);
                ++n;
            }
        }
        return stringArray;
    }

    private RegexpPool g() {
        RegexpPool regexpPool = new RegexpPool();
        String string = AccessController.doPrivileged(new GetPropertyAction("http.nonProxyHosts"));
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    regexpPool.add(stringTokenizer.nextToken().toLowerCase(), (Object)new Boolean(true));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return regexpPool;
    }

    private String h() {
        String string = AccessController.doPrivileged(new GetPropertyAction("https.agent"));
        if (string == null || string.length() == 0) {
            string = "JSSE";
        }
        return string;
    }

    private HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL) throws IOException {
        this(sSLSocketFactory, uRL, null, -1);
    }

    HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL, String string, int n) throws IOException {
        this.a(sSLSocketFactory);
        if (string != null) {
            this.a(string, n);
        }
        this.proxyDisabled = true;
        try {
            InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
            this.host = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            this.host = uRL.getHost();
        }
        this.url = uRL;
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.openServer();
    }

    static HttpClient a(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier) throws IOException {
        return HttpsClient.a(sSLSocketFactory, uRL, hostnameVerifier, true);
    }

    static HttpClient a(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, boolean bl) throws IOException {
        return HttpsClient.a(sSLSocketFactory, uRL, hostnameVerifier, null, -1, bl);
    }

    static HttpClient a(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, String string, int n) throws IOException {
        return HttpsClient.a(sSLSocketFactory, uRL, hostnameVerifier, string, n, true);
    }

    static HttpClient a(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, String string, int n, boolean bl) throws IOException {
        HttpsClient httpsClient = null;
        if (bl && (httpsClient = (HttpsClient)HttpClient.kac.get(uRL, sSLSocketFactory)) != null) {
            httpsClient.cachedHttpClient = true;
        }
        if (httpsClient == null) {
            httpsClient = new HttpsClient(sSLSocketFactory, uRL, string, n);
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
            }
            httpsClient.url = uRL;
        }
        httpsClient.a(hostnameVerifier);
        return httpsClient;
    }

    void a(HostnameVerifier hostnameVerifier) {
        this.b = hostnameVerifier;
    }

    void a(SSLSocketFactory sSLSocketFactory) {
        this.c = sSLSocketFactory;
    }

    void a(String string, int n) {
        this.d = string;
        this.e = n < 0 ? this.getDefaultPort() : n;
    }

    SSLSocketFactory a() {
        return this.c;
    }

    private boolean i() {
        RegexpPool regexpPool = this.g();
        if (regexpPool.match(this.url.getHost().toLowerCase()) != null) {
            return true;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(this.url.getHost());
            String string = inetAddress.getHostAddress();
            if (regexpPool.match(string) != null) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public boolean needsTunneling() {
        return this.d != null && !this.i();
    }

    protected Socket doConnect(String string, int n) throws IOException, UnknownHostException {
        this.d = this.d != null ? this.d : this.getProxyHost();
        this.e = this.e != 0 ? this.e : this.getProxyPort();
        Socket socket = null;
        SSLSocketFactory sSLSocketFactory = this.c;
        if (this.d == null || this.i()) {
            socket = sSLSocketFactory.createSocket(string, n);
        } else {
            try {
                socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new Socket(HttpsClient.this.d, HttpsClient.this.e);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (IOException)privilegedActionException.getException();
            }
            catch (IOException iOException) {
                try {
                    socket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
                }
                catch (IOException iOException2) {
                    throw iOException;
                }
            }
        }
        return socket;
    }

    public void afterConnect() throws IOException, UnknownHostException {
        if (!this.isCachedConnection()) {
            SSLSocket sSLSocket = null;
            SSLSocketFactory sSLSocketFactory = this.c;
            try {
                sSLSocket = !(this.serverSocket instanceof SSLSocket) ? (SSLSocket)sSLSocketFactory.createSocket(this.serverSocket, this.host, this.port, true) : (SSLSocket)this.serverSocket;
            }
            catch (IOException iOException) {
                try {
                    sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.host, this.port);
                }
                catch (IOException iOException2) {
                    throw iOException;
                }
            }
            SSLSocketFactoryImpl.checkCreate(sSLSocket);
            String[] stringArray = this.f();
            String[] stringArray2 = this.e();
            if (stringArray != null) {
                sSLSocket.setEnabledProtocols(stringArray);
            }
            if (stringArray2 != null) {
                sSLSocket.setEnabledCipherSuites(stringArray2);
            }
            sSLSocket.addHandshakeCompletedListener(this);
            sSLSocket.startHandshake();
            this.f = sSLSocket.getSession();
            this.serverSocket = sSLSocket;
            try {
                this.serverOutput = new PrintStream((OutputStream)new BufferedOutputStream(this.serverSocket.getOutputStream()), false, NetworkClient.encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError(NetworkClient.encoding + " encoding not found");
            }
            this.b(this.b);
        } else {
            this.f = ((SSLSocket)this.serverSocket).getSession();
        }
    }

    private void b(HostnameVerifier hostnameVerifier) throws IOException {
        Object object;
        boolean bl = false;
        String string = this.url.getHost();
        if (string != null && string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 1);
        }
        Certificate[] certificateArray = null;
        try {
            String string2;
            Object object2;
            Object object3;
            certificateArray = this.f.getPeerCertificates();
            if (!(certificateArray[0] instanceof java.security.cert.X509Certificate)) {
                throw new SSLPeerUnverifiedException("");
            }
            object = (java.security.cert.X509Certificate)certificateArray[0];
            Collection<List<?>> collection = ((java.security.cert.X509Certificate)object).getSubjectAlternativeNames();
            if (collection != null) {
                object3 = collection.iterator();
                while (object3.hasNext()) {
                    object2 = (List)object3.next();
                    if ((Integer)object2.get(0) == 7) {
                        string2 = (String)object2.get(1);
                        if (string.equalsIgnoreCase(string2)) {
                            return;
                        }
                        bl = true;
                        continue;
                    }
                    if ((Integer)object2.get(0) != 2) continue;
                    string2 = ((String)object2.get(1)).toLowerCase();
                    if (this.a(string, string2)) {
                        return;
                    }
                    bl = true;
                }
            }
            if (!bl && this.a(string, string2 = ((X500Name)(object2 = new X500Name((object3 = ((java.security.cert.X509Certificate)object).getSubjectDN()).getName()))).getCommonName())) {
                return;
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        object = this.f.getCipherSuite();
        if (object != null && ((String)object).indexOf("_anon_") != -1) {
            return;
        }
        if (hostnameVerifier != null && hostnameVerifier.verify(string, this.f)) {
            return;
        }
        this.serverSocket.close();
        this.f.invalidate();
        throw new IOException("HTTPS hostname wrong:  should be <" + this.url.getHost() + ">");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean a(String string, String string2) {
        try {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
            if (stringTokenizer.countTokens() != stringTokenizer2.countTokens()) {
                return false;
            }
            block2: while (true) {
                if (!stringTokenizer.hasMoreTokens()) {
                    return true;
                }
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer2.nextToken();
                String string5 = "";
                String string6 = string4;
                int n = string6.indexOf("*");
                while (true) {
                    if (n == -1) {
                        if (n >= 0 || string3.endsWith(string6)) continue block2;
                        return false;
                    }
                    string5 = string6.substring(0, n);
                    string6 = string6.substring(n + 1);
                    int n2 = string3.indexOf(string5);
                    if (n2 == -1) {
                        return false;
                    }
                    string3 = string3.substring(n2 + string5.length());
                    n = string6.indexOf("*");
                }
                break;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void putInKeepAliveCache() {
        HttpClient.kac.put(this.url, this.c, this);
    }

    String b() {
        return this.f.getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        return this.f.getLocalCertificates();
    }

    Certificate[] c() throws SSLPeerUnverifiedException {
        return this.f.getPeerCertificates();
    }

    X509Certificate[] d() throws SSLPeerUnverifiedException {
        return this.f.getPeerCertificateChain();
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        this.f = handshakeCompletedEvent.getSession();
    }

    public String getProxyHostUsed() {
        if (!this.needsTunneling()) {
            return null;
        }
        return this.d;
    }

    public int getProxyPortUsed() {
        return this.e;
    }
}

