/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.www.protocol.https;

import com.sun.net.ssl.HostnameVerifier;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import sun.security.x509.X500Name;

class VerifierWrapper
implements javax.net.ssl.HostnameVerifier {
    private HostnameVerifier a;

    VerifierWrapper(HostnameVerifier hostnameVerifier) {
        this.a = hostnameVerifier;
    }

    public boolean verify(String string, SSLSession sSLSession) {
        try {
            Certificate[] certificateArray = sSLSession.getPeerCertificates();
            if (certificateArray == null || certificateArray.length == 0) {
                return false;
            }
            if (!(certificateArray[0] instanceof X509Certificate)) {
                return false;
            }
            X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
            String string2 = VerifierWrapper.getServername(x509Certificate);
            if (string2 == null) {
                return false;
            }
            return this.a.verify(string, string2);
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
    }

    public static String getServername(X509Certificate x509Certificate) {
        try {
            Object object;
            Object object2;
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection != null) {
                object2 = collection.iterator();
                while (object2.hasNext()) {
                    object = (List)object2.next();
                    if ((Integer)object.get(0) != 2) continue;
                    String string = (String)object.get(1);
                    return string;
                }
            }
            object2 = x509Certificate.getSubjectDN();
            object = new X500Name(object2.getName());
            String string = ((X500Name)object).getCommonName();
            return string;
        }
        catch (CertificateParsingException certificateParsingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

