/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;
import sun.security.util.BigInt;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public final class DHParameters
extends AlgorithmParametersSpi {
    protected BigInteger a;
    protected BigInteger b;
    private int c;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.a = ((DHParameterSpec)algorithmParameterSpec).getP();
        this.b = ((DHParameterSpec)algorithmParameterSpec).getG();
        this.c = ((DHParameterSpec)algorithmParameterSpec).getL();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            DerValue derValue = new DerValue(byArray);
            if (derValue.tag != 48) {
                throw new IOException("DH params parsing error");
            }
            derValue.data.reset();
            this.a = derValue.data.getInteger().toBigInteger();
            this.b = derValue.data.getInteger().toBigInteger();
            if (derValue.data.available() != 0) {
                this.c = derValue.data.getInteger().toInt();
            }
            if (derValue.data.available() != 0) {
                throw new IOException("DH parameter parsing error: Extra data");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Private-value length too big");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName("javax.crypto.spec.DHParameterSpec");
            if (clazz2.isAssignableFrom(clazz)) {
                return new DHParameterSpec(this.a, this.b, this.c);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + classNotFoundException.getMessage());
        }
    }

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(new BigInt(this.a));
        derOutputStream2.putInteger(new BigInt(this.b));
        if (this.c > 0) {
            derOutputStream2.putInteger(new BigInt(BigInteger.valueOf(this.c)));
        }
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer("SunJCE Diffie-Hellman Parameters:\np:\n" + new BigInt(this.a).toString() + "\n" + "g:\n" + new BigInt(this.b).toString());
        if (this.c != 0) {
            stringBuffer.append("\nl:\n    " + this.c);
        }
        return stringBuffer.toString();
    }
}

