/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.DNSName;
import sun.security.x509.EDIPartyName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.OIDName;
import sun.security.x509.OtherName;
import sun.security.x509.RFC822Name;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

class ForwardState
implements State {
    private static final Debug debug = Debug.getInstance("certpath");
    String issuerDN;
    X509CertImpl cert;
    HashSet subjectNamesTraversed;
    int traversedCACerts;
    private boolean init = true;
    public CrlRevocationChecker crlChecker;
    ArrayList forwardCheckers;
    boolean keyParamsNeededFlag = false;

    ForwardState() {
    }

    public boolean isInitial() {
        return this.init;
    }

    public boolean keyParamsNeeded() {
        return this.keyParamsNeededFlag;
    }

    public String toString() {
        StringBuffer stringBuffer;
        block13: {
            stringBuffer = new StringBuffer();
            try {
                stringBuffer.append("State [");
                stringBuffer.append("\n  issuerDN of last cert: " + this.issuerDN);
                stringBuffer.append("\n  traversedCACerts: " + this.traversedCACerts);
                stringBuffer.append("\n  init: " + String.valueOf(this.init));
                stringBuffer.append("\n  keyParamsNeeded: " + String.valueOf(this.keyParamsNeededFlag));
                stringBuffer.append("\n  subjectNamesTraversed: \n");
                Iterator iterator = this.subjectNamesTraversed.iterator();
                while (iterator.hasNext()) {
                    String string;
                    List list = (List)iterator.next();
                    DerValue derValue = new DerValue((byte[])list.get(1));
                    int n2 = (Integer)list.get(0);
                    switch (n2) {
                        case 0: {
                            string = new OtherName(derValue).toString();
                            break;
                        }
                        case 1: {
                            string = new RFC822Name(derValue).toString();
                            break;
                        }
                        case 2: {
                            string = new DNSName(derValue).toString();
                            break;
                        }
                        case 4: {
                            string = new X500Name(derValue).toString();
                            break;
                        }
                        case 5: {
                            string = new EDIPartyName(derValue).toString();
                            break;
                        }
                        case 6: {
                            string = new URIName(derValue).toString();
                            break;
                        }
                        case 7: {
                            string = new IPAddressName(derValue).toString();
                            break;
                        }
                        case 8: {
                            string = new OIDName(derValue).toString();
                            break;
                        }
                        default: {
                            string = "name of unparsable type";
                        }
                    }
                    stringBuffer.append("    type " + n2 + ", name " + string + "\n");
                }
                stringBuffer.append("]\n");
            }
            catch (Exception exception) {
                if (debug == null) break block13;
                debug.println("ForwardState.toString() unexpected exception");
                exception.printStackTrace();
            }
        }
        return stringBuffer.toString();
    }

    public void initState(List list) throws CertPathValidatorException {
        this.subjectNamesTraversed = new HashSet();
        this.traversedCACerts = 0;
        this.forwardCheckers = new ArrayList();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)iterator.next();
                if (!pKIXCertPathChecker.isForwardCheckingSupported()) continue;
                pKIXCertPathChecker.init(true);
                this.forwardCheckers.add(pKIXCertPathChecker);
            }
        }
        this.init = true;
    }

    public void updateState(X509Certificate x509Certificate) throws CertificateException, IOException, CertPathValidatorException {
        if (x509Certificate == null) {
            return;
        }
        X509CertImpl x509CertImpl = new X509CertImpl(x509Certificate.getEncoded());
        PublicKey publicKey = x509CertImpl.getPublicKey();
        if (publicKey instanceof DSAPublicKey && ((DSAPublicKey)publicKey).getParams() == null) {
            this.keyParamsNeededFlag = true;
        }
        this.cert = x509CertImpl;
        this.issuerDN = x509Certificate.getIssuerX500Principal().getName("RFC2253");
        if (!x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN()) && !this.init && x509Certificate.getBasicConstraints() != -1) {
            ++this.traversedCACerts;
        }
        if (this.init || !x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) {
            ArrayList arrayList = new ArrayList();
            arrayList.add(new Integer(4));
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            arrayList.add(x500Principal.getEncoded());
            this.subjectNamesTraversed.add(arrayList);
            try {
                SubjectAlternativeNameExtension subjectAlternativeNameExtension = x509CertImpl.getSubjectAlternativeNameExtension();
                if (subjectAlternativeNameExtension != null) {
                    GeneralNames generalNames = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
                    Enumeration enumeration = generalNames.elements();
                    while (enumeration.hasMoreElements()) {
                        GeneralNameInterface generalNameInterface = ((GeneralName)enumeration.nextElement()).getName();
                        ArrayList arrayList2 = new ArrayList();
                        arrayList2.add(new Integer(generalNameInterface.getType()));
                        DerOutputStream derOutputStream = new DerOutputStream();
                        generalNameInterface.encode(derOutputStream);
                        arrayList2.add(derOutputStream.toByteArray());
                        this.subjectNamesTraversed.add(arrayList2);
                    }
                }
            }
            catch (Exception exception) {
                if (debug != null) {
                    debug.println("ForwardState.updateState() unexpected exception");
                    exception.printStackTrace();
                }
                throw new CertPathValidatorException(exception);
            }
        }
        this.init = false;
    }

    public Object clone() {
        try {
            ForwardState forwardState = (ForwardState)super.clone();
            forwardState.forwardCheckers = (ArrayList)this.forwardCheckers.clone();
            ListIterator listIterator = forwardState.forwardCheckers.listIterator();
            while (listIterator.hasNext()) {
                PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)listIterator.next();
                if (!(pKIXCertPathChecker instanceof Cloneable)) continue;
                listIterator.set(pKIXCertPathChecker.clone());
            }
            forwardState.subjectNamesTraversed = (HashSet)this.subjectNamesTraversed.clone();
            return forwardState;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }
}

