/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.Permission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import sun.security.util.ResourcesMgr;

class SelfPermission
extends Permission {
    private String type;
    private String name;
    private String actions;
    private Certificate[] certs;

    public SelfPermission(String string, String string2, String string3, Certificate[] certificateArray) {
        super(string);
        if (string == null) {
            throw new NullPointerException(ResourcesMgr.getString("type can't be null"));
        }
        this.type = string;
        this.name = string2;
        this.actions = string3;
        if (certificateArray != null) {
            int n2 = 0;
            while (n2 < certificateArray.length) {
                if (!(certificateArray[n2] instanceof X509Certificate)) {
                    this.certs = (Certificate[])certificateArray.clone();
                    break;
                }
                ++n2;
            }
            if (this.certs == null) {
                int n3 = 0;
                int n4 = 0;
                while (n3 < certificateArray.length) {
                    ++n4;
                    while (n3 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n3]).getIssuerDN().equals(((X509Certificate)certificateArray[n3 + 1]).getSubjectDN())) {
                        ++n3;
                    }
                    ++n3;
                }
                if (n4 == certificateArray.length) {
                    this.certs = (Certificate[])certificateArray.clone();
                }
                if (this.certs == null) {
                    ArrayList arrayList = new ArrayList();
                    n3 = 0;
                    while (n3 < certificateArray.length) {
                        arrayList.add(certificateArray[n3]);
                        while (n3 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n3]).getIssuerDN().equals(((X509Certificate)certificateArray[n3 + 1]).getSubjectDN())) {
                            ++n3;
                        }
                        ++n3;
                    }
                    this.certs = new Certificate[arrayList.size()];
                    arrayList.toArray(this.certs);
                }
            }
        }
    }

    public boolean implies(Permission permission) {
        return false;
    }

    public boolean equals(Object object) {
        int n2;
        boolean bl2;
        if (object == this) {
            return true;
        }
        if (!(object instanceof SelfPermission)) {
            return false;
        }
        SelfPermission selfPermission = (SelfPermission)object;
        if (!(this.type.equals(selfPermission.type) && this.name.equals(selfPermission.name) && this.actions.equals(selfPermission.actions))) {
            return false;
        }
        if (this.certs.length != selfPermission.certs.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.certs.length) {
            bl2 = false;
            n2 = 0;
            while (n2 < selfPermission.certs.length) {
                if (this.certs[n3].equals(selfPermission.certs[n2])) {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                return false;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < selfPermission.certs.length) {
            bl2 = false;
            n2 = 0;
            while (n2 < this.certs.length) {
                if (selfPermission.certs[n3].equals(this.certs[n2])) {
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.type.hashCode();
        if (this.name != null) {
            n2 ^= this.name.hashCode();
        }
        if (this.actions != null) {
            n2 ^= this.actions.hashCode();
        }
        return n2;
    }

    public String getActions() {
        return "";
    }

    public String getSelfType() {
        return this.type;
    }

    public String getSelfName() {
        return this.name;
    }

    public String getSelfActions() {
        return this.actions;
    }

    public Certificate[] getCerts() {
        return this.certs;
    }

    public String toString() {
        return "(SelfPermission " + this.type + " " + this.name + " " + this.actions + ")";
    }
}

