/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Enumeration;
import java.util.Properties;
import sun.security.action.GetPropertyAction;
import sun.security.util.Debug;

abstract class SeedGenerator {
    private static SeedGenerator myself;
    private static final Debug debug;

    SeedGenerator() {
    }

    public static byte getByte() {
        return myself._getByte();
    }

    abstract byte _getByte();

    static byte[] getSystemEntropy() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.");
        }
        byte by = (byte)System.currentTimeMillis();
        messageDigest.update(by);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Object object;
                Object object2;
                try {
                    object2 = System.getProperties();
                    Enumeration enumeration = ((Properties)object2).propertyNames();
                    while (enumeration.hasMoreElements()) {
                        object = (String)enumeration.nextElement();
                        messageDigest.update(((String)object).getBytes());
                        messageDigest.update(((Properties)object2).getProperty((String)object).getBytes());
                    }
                    messageDigest.update(InetAddress.getLocalHost().toString().getBytes());
                    File file = new File(((Properties)object2).getProperty("java.io.tmpdir"));
                    String[] stringArray = file.list();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        messageDigest.update(stringArray[n2].getBytes());
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    messageDigest.update((byte)exception.hashCode());
                }
                object = Runtime.getRuntime();
                object2 = SeedGenerator.longToByteArray(((Runtime)object).totalMemory());
                messageDigest.update((byte[])object2, 0, ((Object)object2).length);
                object2 = SeedGenerator.longToByteArray(((Runtime)object).freeMemory());
                messageDigest.update((byte[])object2, 0, ((Object)object2).length);
                return null;
            }
        });
        return messageDigest.digest();
    }

    private static byte[] longToByteArray(long l2) {
        byte[] byArray = new byte[8];
        int n2 = 0;
        while (n2 < 8) {
            byArray[n2] = (byte)l2;
            l2 >>= 8;
            ++n2;
        }
        return byArray;
    }

    static {
        debug = Debug.getInstance("provider");
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("java.security.egd"));
        if (string == null) {
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Security.getProperty("securerandom.source");
                }
            });
        }
        if (string == null) {
            myself = new ThreadedSeedGenerator();
        } else {
            try {
                myself = new DevSeedGenerator(string);
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.println("Failed to create seed generator with " + string + ", using default mechanism.");
                }
                myself = new ThreadedSeedGenerator();
            }
        }
    }

    private static class DevSeedGenerator
    extends SeedGenerator {
        private String deviceName;
        private BufferedInputStream devRandom;

        DevSeedGenerator(String string) throws IOException {
            if (string == null) {
                throw new IOException("No random source specified");
            }
            this.deviceName = string;
            this.init();
        }

        private DevSeedGenerator() throws IOException {
            throw new IOException("No random source specified");
        }

        private void init() throws IOException {
            URL uRL = new URL(this.deviceName);
            this.devRandom = (BufferedInputStream)AccessController.doPrivileged(new PrivilegedAction(this, uRL){
                private final /* synthetic */ URL val$device;
                private final /* synthetic */ DevSeedGenerator this$0;
                {
                    this.this$0 = devSeedGenerator;
                    this.val$device = uRL;
                }

                public Object run() {
                    try {
                        return new BufferedInputStream(this.val$device.openStream());
                    }
                    catch (IOException iOException) {
                        return null;
                    }
                }
            });
            if (this.devRandom == null) {
                throw new IOException("failed to open " + uRL);
            }
        }

        byte _getByte() {
            int n2;
            byte[] byArray = new byte[1];
            try {
                n2 = this.devRandom.read(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new InternalError("SeedGenerator " + this.deviceName + " generated exception: " + iOException.getMessage());
            }
            if (n2 == byArray.length) {
                return byArray[0];
            }
            if (n2 == -1) {
                throw new InternalError("SeedGenerator " + this.deviceName + " reached end of file");
            }
            throw new InternalError("SeedGenerator " + this.deviceName + " failed read");
        }
    }

    private static class ThreadedSeedGenerator
    extends SeedGenerator
    implements Runnable {
        private byte[] pool = new byte[20];
        private int start = 0;
        private int end = 0;
        private int count;
        ThreadGroup seedGroup;
        private static byte[] rndTab = new byte[]{56, 30, -107, -6, -86, 25, -83, 75, -12, -64, 5, -128, 78, 21, 16, 32, 70, -81, 37, -51, -43, -46, -108, 87, 29, 17, -55, 22, -11, -111, -115, 84, -100, 108, -45, -15, -98, 72, -33, -28, 31, -52, -37, -117, -97, -27, 93, -123, 47, 126, -80, -62, -93, -79, 61, -96, -65, -5, -47, -119, 14, 89, 81, -118, -88, 20, 67, -126, -113, 60, -102, 55, 110, 28, 85, 121, 122, -58, 2, 45, 43, 24, -9, 103, -13, 102, -68, -54, -101, -104, 19, 13, -39, -26, -103, 62, 77, 51, 44, 111, 73, 18, -127, -82, 4, -30, 11, -99, -74, 40, -89, 42, -76, -77, -94, -35, -69, 35, 120, 76, 33, -73, -7, 82, -25, -10, 88, 125, -112, 58, 83, 95, 6, 10, 98, -34, 80, 15, -91, 86, -19, 52, -17, 117, 49, -63, 118, -90, 36, -116, -40, -71, 97, -53, -109, -85, 109, -16, -3, 104, -95, 68, 54, 34, 26, 114, -1, 106, -121, 3, 66, 0, 100, -84, 57, 107, 119, -42, 112, -61, 1, 48, 38, 12, -56, -57, 39, -106, -72, 41, 7, 71, -29, -59, -8, -38, 79, -31, 124, -124, 8, 91, 116, 99, -4, 9, -36, -78, 63, -49, -67, -87, 59, 101, -32, 92, 94, 53, -41, 115, -66, -70, -122, 50, -50, -22, -20, -18, -21, 23, -2, -48, 96, 65, -105, 123, -14, -110, 69, -24, -120, -75, 74, 127, -60, 113, 90, -114, 105, 46, 27, -125, -23, -44, 64};

        ThreadedSeedGenerator() {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("internal error: SHA-1 not available.");
            }
            ThreadGroup[] threadGroupArray = new ThreadGroup[1];
            Thread thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(this, threadGroupArray){
                private final /* synthetic */ ThreadGroup[] val$finalsg;
                private final /* synthetic */ ThreadedSeedGenerator this$0;
                {
                    this.this$0 = threadedSeedGenerator;
                    this.val$finalsg = threadGroupArray;
                }

                public Object run() {
                    ThreadGroup threadGroup;
                    ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
                    while ((threadGroup = threadGroup2.getParent()) != null) {
                        threadGroup2 = threadGroup;
                    }
                    this.val$finalsg[0] = new ThreadGroup(threadGroup2, "SeedGenerator ThreadGroup");
                    Thread thread = new Thread(this.val$finalsg[0], this.this$0, "SeedGenerator Thread");
                    thread.setPriority(1);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            this.seedGroup = threadGroupArray[0];
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public final void run() {
            try {
                while (true) lbl-1000:
                // 2 sources

                {
                    var1_1 = this;
                    synchronized (var1_1) {
                        while (this.count >= this.pool.length) {
                            this.wait();
                        }
                    }
                    var4_6 = 0;
                    var3_5 = 0;
                    var2_3 = 0;
                    while (var2_3 < 64000 && var3_5 < 6) {
                        try {
                            var5_8 = new BogusThread();
                            var6_12 = new Thread(this.seedGroup, var5_8, "SeedGenerator Thread");
                            var6_12.start();
                        }
                        catch (Exception var5_9) {
                            throw new InternalError("internal error: SeedGenerator thread creation error.");
                        }
                        var5_10 = 0;
                        var5_10 = 0;
                        var6_11 = System.currentTimeMillis() + 250L;
                        while (System.currentTimeMillis() < var6_11) {
                            var8_13 = this;
                            synchronized (var8_13) {
                            }
                            ++var5_10;
                        }
                        var4_6 = (byte)(var4_6 ^ ThreadedSeedGenerator.rndTab[var5_10 % 255]);
                        var2_3 += var5_10;
                        ++var3_5;
                    }
                    var5_7 = this;
                    synchronized (var5_7) {
                        this.pool[this.end] = var4_6;
                        ++this.end;
                        ++this.count;
                        if (this.end >= this.pool.length) {
                            this.end = 0;
                        }
                        this.notifyAll();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception var1_2) {
                throw new InternalError("internal error: SeedGenerator thread generated an exception.");
            }
            {
                ** while (true)
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte _getByte() {
            ThreadedSeedGenerator threadedSeedGenerator;
            byte by;
            block10: {
                by = 0;
                try {
                    threadedSeedGenerator = this;
                    synchronized (threadedSeedGenerator) {
                        while (this.count <= 0) {
                            this.wait();
                        }
                    }
                }
                catch (Exception exception) {
                    if (this.count > 0) break block10;
                    throw new InternalError("internal error: SeedGenerator thread generated an exception.");
                }
            }
            threadedSeedGenerator = this;
            synchronized (threadedSeedGenerator) {
                by = this.pool[this.start];
                this.pool[this.start] = 0;
                ++this.start;
                --this.count;
                if (this.start == this.pool.length) {
                    this.start = 0;
                }
                this.notifyAll();
            }
            return by;
        }

        private class BogusThread
        implements Runnable {
            private BogusThread() {
            }

            public final void run() {
                try {
                    int n2 = 0;
                    while (n2 < 5) {
                        Thread.sleep(50L);
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

