/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.IOException;
import java.io.OutputStream;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.MultiplexConnectionInfo;

final class MultiplexOutputStream
extends OutputStream {
    private ConnectionMultiplexer manager;
    private MultiplexConnectionInfo info;
    private byte[] buffer;
    private int pos = 0;
    private int requested = 0;
    private boolean disconnected = false;
    private Object lock = new Object();

    MultiplexOutputStream(ConnectionMultiplexer connectionMultiplexer, MultiplexConnectionInfo multiplexConnectionInfo, int n2) {
        this.manager = connectionMultiplexer;
        this.info = multiplexConnectionInfo;
        this.buffer = new byte[n2];
        this.pos = 0;
    }

    public synchronized void write(int n2) throws IOException {
        while (this.pos >= this.buffer.length) {
            this.push();
        }
        this.buffer[this.pos++] = (byte)n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 <= 0) {
            return;
        }
        int n4 = this.buffer.length - this.pos;
        if (n3 <= n4) {
            System.arraycopy(byArray, n2, this.buffer, this.pos, n3);
            this.pos += n3;
            return;
        }
        this.flush();
        while (true) {
            Object object;
            int n5;
            Object object2 = this.lock;
            // MONITORENTER : object2
            while ((n5 = this.requested) < 1 && !this.disconnected) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.disconnected) {
                throw new IOException("Connection closed");
            }
            // MONITOREXIT : object2
            if (n5 >= n3) {
                this.manager.sendTransmit(this.info, byArray, n2, n3);
                object = this.lock;
                // MONITORENTER : object
                this.requested -= n3;
                // MONITOREXIT : object
                return;
            }
            this.manager.sendTransmit(this.info, byArray, n2, n5);
            n2 += n5;
            n3 -= n5;
            object = this.lock;
            // MONITORENTER : object
            this.requested -= n5;
            // MONITOREXIT : object
        }
    }

    public synchronized void flush() throws IOException {
        while (this.pos > 0) {
            this.push();
        }
    }

    public void close() throws IOException {
        this.manager.sendClose(this.info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void request(int n2) {
        Object object = this.lock;
        synchronized (object) {
            this.requested += n2;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            this.disconnected = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void push() throws IOException {
        int n2;
        Object object = this.lock;
        // MONITORENTER : object
        while ((n2 = this.requested) < 1 && !this.disconnected) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.disconnected) {
            throw new IOException("Connection closed");
        }
        // MONITOREXIT : object
        if (n2 < this.pos) {
            this.manager.sendTransmit(this.info, this.buffer, 0, n2);
            System.arraycopy(this.buffer, n2, this.buffer, 0, this.pos - n2);
            this.pos -= n2;
            Object object2 = this.lock;
            // MONITORENTER : object2
            this.requested -= n2;
            // MONITOREXIT : object2
            return;
        }
        this.manager.sendTransmit(this.info, this.buffer, 0, this.pos);
        Object object3 = this.lock;
        // MONITORENTER : object3
        this.requested -= this.pos;
        // MONITOREXIT : object3
        this.pos = 0;
    }
}

