/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.Util;

public class FileChannelImpl
extends FileChannel {
    private FileDescriptor fd;
    private boolean writable;
    private boolean readable;
    private boolean appending;
    List lockList = new ArrayList();
    private Object parent;
    private static NativeDispatcher nd;
    private Object lock = new Object();
    private static long allocationGranularity;
    private static volatile boolean transferSupported;
    private static final int TRANSFER_SIZE = 8192;
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    public static final int NO_LOCK = -1;
    public static final int LOCKED = 0;
    public static final int RET_EX_LOCK = 1;
    public static final int INTERRUPTED = 2;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$FileChannelImpl;

    private FileChannelImpl(FileDescriptor fileDescriptor, boolean bl2, boolean bl3, Object object, boolean bl4) {
        this.fd = fileDescriptor;
        this.readable = bl2;
        this.writable = bl3;
        this.parent = object;
        this.appending = bl4;
    }

    public static FileChannel open(FileDescriptor fileDescriptor, boolean bl2, boolean bl3, Object object) {
        return new FileChannelImpl(fileDescriptor, bl2, bl3, object, false);
    }

    public static FileChannel open(FileDescriptor fileDescriptor, boolean bl2, boolean bl3, Object object, boolean bl4) {
        return new FileChannelImpl(fileDescriptor, bl2, bl3, object, bl4);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseChannel() throws IOException {
        List list = this.lockList;
        synchronized (list) {
            Iterator iterator = this.lockList.iterator();
            while (iterator.hasNext()) {
                FileLockImpl fileLockImpl = (FileLockImpl)iterator.next();
                fileLockImpl.invalidate();
                this.release0(this.fd, fileLockImpl.position(), fileLockImpl.size());
            }
            this.lockList.clear();
        }
        if (this.parent == null && this.fd != null) {
            nd.close(this.fd);
            this.fd = null;
        }
    }

    protected void finalize() throws IOException {
        this.implCloseChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            int n3;
            int n2 = 0;
            try {
                this.begin();
                n3 = n2 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.lock);
                Object var6_5 = null;
                bl2 = n2 > 0;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.end(n2 > 0);
                throw throwable;
            }
            this.end(bl2);
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int read0(ByteBuffer[] byteBufferArray) throws IOException {
        this.ensureOpen();
        if (!this.readable) {
            throw new NonReadableChannelException();
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            int n3;
            int n2 = 0;
            try {
                this.begin();
                n3 = n2 = IOUtil.read(this.fd, byteBufferArray, nd);
                Object var6_5 = null;
                bl2 = n2 > 0;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.end(n2 > 0);
                throw throwable;
            }
            this.end(bl2);
            return n3;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.read0(Util.subsequence(byteBufferArray, n2, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            int n3;
            int n2 = 0;
            try {
                this.begin();
                if (this.appending) {
                    this.position(this.size());
                }
                n3 = n2 = IOUtil.write(this.fd, byteBuffer, -1L, nd, this.lock);
                Object var6_5 = null;
                bl2 = n2 > 0;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.end(n2 > 0);
                throw throwable;
            }
            this.end(bl2);
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int write0(ByteBuffer[] byteBufferArray) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            int n3;
            int n2 = 0;
            try {
                this.begin();
                if (this.appending) {
                    this.position(this.size());
                }
                n3 = n2 = IOUtil.write(this.fd, byteBufferArray, nd);
                Object var6_5 = null;
                bl2 = n2 > 0;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.end(n2 > 0);
                throw throwable;
            }
            this.end(bl2);
            return n3;
        }
    }

    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.write0(Util.subsequence(byteBufferArray, n2, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long position() throws IOException {
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            long l3;
            long l2 = -1L;
            try {
                this.begin();
                l3 = l2 = this.position0(this.fd, -1L);
                Object var7_4 = null;
                bl2 = l2 > -1L;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                this.end(l2 > -1L);
                throw throwable;
            }
            this.end(bl2);
            return l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel position(long l2) throws IOException {
        this.ensureOpen();
        if (l2 < 0L) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl2 = false;
            try {
                this.begin();
                this.position0(this.fd, l2);
                bl2 = true;
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                this.end(bl2);
                throw throwable;
            }
            this.end(bl2);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long size() throws IOException {
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            boolean bl2;
            long l3;
            long l2 = -1L;
            try {
                this.begin();
                l3 = l2 = this.size0(this.fd);
                Object var7_4 = null;
                bl2 = l2 > -1L;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                this.end(l2 > -1L);
                throw throwable;
            }
            this.end(bl2);
            return l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel truncate(long l2) throws IOException {
        this.ensureOpen();
        if (l2 < 0L) {
            throw new IllegalArgumentException();
        }
        if (l2 > this.size()) {
            return this;
        }
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl2 = false;
            try {
                this.begin();
                this.truncate0(this.fd, l2);
                bl2 = true;
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                this.end(bl2);
                throw throwable;
            }
            this.end(bl2);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void force(boolean bl2) throws IOException {
        this.ensureOpen();
        boolean bl3 = false;
        try {
            this.begin();
            this.force0(this.fd, bl2);
            bl3 = true;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.end(bl3);
            throw throwable;
        }
        this.end(bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long transferTo(long l2, long l3, WritableByteChannel writableByteChannel) throws IOException {
        long l4;
        block10: {
            Object object;
            this.ensureOpen();
            if (!this.readable) {
                throw new NonReadableChannelException();
            }
            if (l2 < 0L || l3 < 0L) {
                throw new IllegalArgumentException();
            }
            int n2 = (int)Math.min(l3, Integer.MAX_VALUE);
            if (transferSupported) {
                object = null;
                if (writableByteChannel instanceof FileChannelImpl) {
                    object = ((FileChannelImpl)writableByteChannel).fd;
                } else if (writableByteChannel instanceof SelChImpl) {
                    object = ((SelChImpl)((Object)writableByteChannel)).getFD();
                }
                if (object != null) {
                    int n3 = this.transferTo0(IOUtil.fdVal(this.fd), l2, n2, IOUtil.fdVal((FileDescriptor)object));
                    if (n3 != -2) {
                        return n3;
                    }
                    transferSupported = false;
                }
            }
            object = null;
            try {
                object = this.map(FileChannel.MapMode.READ_ONLY, l2, n2);
                l4 = writableByteChannel.write((ByteBuffer)object);
                Object var11_8 = null;
                if (object == null) break block10;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var11_9 = null;
                    if (object == null) break block11;
                    FileChannelImpl.unmap((MappedByteBuffer)object);
                }
                throw throwable;
            }
            FileChannelImpl.unmap((MappedByteBuffer)object);
        }
        return l4;
    }

    public long transferFrom(ReadableByteChannel readableByteChannel, long l2, long l3) throws IOException {
        this.ensureOpen();
        if (!this.writable) {
            throw new NonWritableChannelException();
        }
        if (l2 < 0L || l3 < 0L) {
            throw new IllegalArgumentException();
        }
        if (l2 > this.size()) {
            return 0L;
        }
        int n2 = (int)Math.min(l3, Integer.MAX_VALUE);
        if (readableByteChannel instanceof FileChannelImpl) {
            return this.transfer((FileChannelImpl)readableByteChannel, l2, n2);
        }
        return this.transfer(readableByteChannel, l2, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transfer(FileChannelImpl fileChannelImpl, long l2, int n2) throws IOException {
        int n3;
        block5: {
            MappedByteBuffer mappedByteBuffer = null;
            try {
                int n4 = 0;
                Object object = fileChannelImpl.lock;
                synchronized (object) {
                    long l3 = fileChannelImpl.position();
                    mappedByteBuffer = fileChannelImpl.map(FileChannel.MapMode.READ_ONLY, l3, n2);
                    n4 = this.write(mappedByteBuffer, l2);
                    fileChannelImpl.position(l3 + (long)n4);
                }
                n3 = n4;
                Object var12_10 = null;
                if (mappedByteBuffer == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var12_11 = null;
                    if (mappedByteBuffer == null) break block6;
                    FileChannelImpl.unmap(mappedByteBuffer);
                }
                throw throwable;
            }
            FileChannelImpl.unmap(mappedByteBuffer);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transfer(ReadableByteChannel readableByteChannel, long l2, int n2) throws IOException {
        int n3 = 0;
        int n4 = n2;
        int n5 = 0;
        int n6 = n4 > 8192 ? 8192 : n4;
        ByteBuffer byteBuffer = Util.getTemporaryDirectBuffer(n6);
        try {
            int n7;
            this.begin();
            long l3 = l2;
            while ((n7 = readableByteChannel.read(byteBuffer)) > 0) {
                byteBuffer.flip();
                n5 = IOUtil.write(this.fd, byteBuffer, l3, nd, this.lock);
                if (n5 != n7) {
                    throw new IOException("transferFrom failed to write all bytes read");
                }
                l3 += (long)n5;
                n3 += n5;
                byteBuffer.clear();
                n6 = (n4 -= n5) > 8192 ? 8192 : n4;
                byteBuffer.limit(n6);
                if (n3 < n2) continue;
                break;
            }
            Object var14_11 = null;
            this.end(n3 > 0);
        }
        catch (Throwable throwable) {
            Object var14_12 = null;
            this.end(n3 > 0);
            throw throwable;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer, long l2) throws IOException {
        int n2;
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        this.ensureOpen();
        int n3 = 0;
        try {
            this.begin();
            n2 = n3 = IOUtil.read(this.fd, byteBuffer, l2, nd, this.lock);
            Object var7_5 = null;
            this.end(n3 > 0);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.end(n3 > 0);
            throw throwable;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer, long l2) throws IOException {
        int n2;
        if (byteBuffer == null) {
            throw new NullPointerException();
        }
        this.ensureOpen();
        int n3 = 0;
        try {
            this.begin();
            n2 = n3 = IOUtil.write(this.fd, byteBuffer, l2, nd, this.lock);
            Object var7_5 = null;
            this.end(n3 > 0);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.end(n3 > 0);
            throw throwable;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedByteBuffer map(FileChannel.MapMode mapMode, long l2, long l3) throws IOException {
        int n2;
        int n3;
        long l4;
        block19: {
            int n4;
            block17: {
                block18: {
                    MappedByteBuffer mappedByteBuffer;
                    this.ensureOpen();
                    if (l2 < 0L) {
                        throw new IllegalArgumentException("Negative position");
                    }
                    if (l3 < 0L) {
                        throw new IllegalArgumentException("Negative size");
                    }
                    if (l3 > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("Size exceeds Integer.MAX_VALUE");
                    }
                    n4 = -1;
                    if (mapMode == FileChannel.MapMode.READ_ONLY) {
                        n4 = 0;
                    } else if (mapMode == FileChannel.MapMode.READ_WRITE) {
                        n4 = 1;
                    } else if (mapMode == FileChannel.MapMode.PRIVATE) {
                        n4 = 2;
                    }
                    if (!$assertionsDisabled && n4 < 0) {
                        throw new AssertionError();
                    }
                    if (mapMode != FileChannel.MapMode.READ_ONLY && !this.writable) {
                        throw new NonWritableChannelException();
                    }
                    if (!this.readable) {
                        throw new NonReadableChannelException();
                    }
                    l4 = -1L;
                    try {
                        this.begin();
                        if (this.size() < l2 + l3) {
                            this.truncate0(this.fd, l2 + l3);
                        }
                        if (l3 != 0L) break block17;
                        l4 = 0L;
                        if (this.writable && n4 != 0) break block18;
                        mappedByteBuffer = Util.newMappedByteBufferR(0, 0L, 0);
                        Object var14_8 = null;
                        this.end(l4 != -1L);
                    }
                    catch (Throwable throwable) {
                        Object var14_12 = null;
                        this.end(l4 != -1L);
                        throw throwable;
                    }
                    return mappedByteBuffer;
                }
                MappedByteBuffer mappedByteBuffer = Util.newMappedByteBuffer(0, 0L, 0);
                Object var14_9 = null;
                this.end(l4 != -1L);
                return mappedByteBuffer;
            }
            n3 = (int)(l2 % allocationGranularity);
            l4 = this.map0(n4, l2 - (long)n3, l3 + (long)n3);
            n2 = (int)l3;
            if (this.writable && n4 != 0) break block19;
            MappedByteBuffer mappedByteBuffer = Util.newMappedByteBufferR(n2, l4, n3);
            Object var14_10 = null;
            this.end(l4 != -1L);
            return mappedByteBuffer;
        }
        MappedByteBuffer mappedByteBuffer = Util.newMappedByteBuffer(n2, l4, n3);
        Object var14_11 = null;
        this.end(l4 != -1L);
        return mappedByteBuffer;
    }

    public static void unmap(MappedByteBuffer mappedByteBuffer) {
        DirectBuffer directBuffer = (DirectBuffer)((Object)mappedByteBuffer);
        while (directBuffer.viewedBuffer() != null) {
            directBuffer = (DirectBuffer)directBuffer.viewedBuffer();
        }
        long l2 = directBuffer.address();
        if (l2 != 0L) {
            FileChannelImpl.unmap0(l2, ((MappedByteBuffer)((Object)directBuffer)).capacity());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileLock lock(long l2, long l3, boolean bl2) throws IOException {
        boolean bl3;
        FileLockImpl fileLockImpl;
        block14: {
            FileLockImpl fileLockImpl3;
            block13: {
                this.ensureOpen();
                if (bl2 && !this.readable) {
                    throw new NonReadableChannelException();
                }
                if (!bl2 && !this.writable) {
                    throw new NonWritableChannelException();
                }
                fileLockImpl = new FileLockImpl(this, l2, l3, bl2);
                this.checkList(l2, l3);
                this.addList(fileLockImpl);
                bl3 = true;
                try {
                    try {
                        this.begin();
                        int n2 = this.lock0(this.fd, true, l2, l3, bl2);
                        if (n2 == 1) {
                            if (!$assertionsDisabled && !bl2) {
                                throw new AssertionError();
                            }
                            FileLockImpl fileLockImpl2 = new FileLockImpl(this, l2, l3, false);
                            this.addList(fileLockImpl2);
                            this.removeList(fileLockImpl);
                            fileLockImpl3 = fileLockImpl2;
                            Object var12_10 = null;
                            break block13;
                        }
                        if (n2 == 2 || n2 == -1) {
                            this.removeList(fileLockImpl);
                            bl3 = false;
                        }
                        break block14;
                    }
                    catch (IOException iOException) {
                        this.removeList(fileLockImpl);
                        throw iOException;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_12 = null;
                    try {
                        this.end(bl3);
                        throw throwable;
                    }
                    catch (ClosedByInterruptException closedByInterruptException) {
                        throw new FileLockInterruptionException();
                    }
                }
            }
            try {}
            catch (ClosedByInterruptException closedByInterruptException) {
                throw new FileLockInterruptionException();
            }
            this.end(bl3);
            return fileLockImpl3;
        }
        Object var12_11 = null;
        try {}
        catch (ClosedByInterruptException closedByInterruptException) {
            throw new FileLockInterruptionException();
        }
        this.end(bl3);
        return fileLockImpl;
    }

    public FileLock tryLock(long l2, long l3, boolean bl2) throws IOException {
        this.ensureOpen();
        if (bl2 && !this.readable) {
            throw new NonReadableChannelException();
        }
        if (!bl2 && !this.writable) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fileLockImpl = new FileLockImpl(this, l2, l3, bl2);
        this.checkList(l2, l3);
        this.addList(fileLockImpl);
        int n2 = this.lock0(this.fd, false, l2, l3, bl2);
        if (n2 == -1) {
            this.removeList(fileLockImpl);
            return null;
        }
        if (n2 == 1) {
            if (!$assertionsDisabled && !bl2) {
                throw new AssertionError();
            }
            FileLockImpl fileLockImpl2 = new FileLockImpl(this, l2, l3, false);
            this.addList(fileLockImpl2);
            this.removeList(fileLockImpl);
            return fileLockImpl2;
        }
        return fileLockImpl;
    }

    void release(FileLockImpl fileLockImpl) throws IOException {
        this.ensureOpen();
        this.release0(this.fd, fileLockImpl.position(), fileLockImpl.size());
        this.removeList(fileLockImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkList(long l2, long l3) throws OverlappingFileLockException {
        List list = this.lockList;
        synchronized (list) {
            Iterator iterator = this.lockList.iterator();
            while (iterator.hasNext()) {
                FileLock fileLock = (FileLock)iterator.next();
                if (!fileLock.overlaps(l2, l3)) continue;
                throw new OverlappingFileLockException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addList(FileLock fileLock) {
        List list = this.lockList;
        synchronized (list) {
            this.lockList.add(fileLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeList(FileLock fileLock) {
        List list = this.lockList;
        synchronized (list) {
            this.lockList.remove(fileLock);
        }
    }

    native int lock0(FileDescriptor var1, boolean var2, long var3, long var5, boolean var7) throws IOException;

    native void release0(FileDescriptor var1, long var2, long var4) throws IOException;

    private native long map0(int var1, long var2, long var4) throws IOException;

    private static native void unmap0(long var0, long var2);

    private native void force0(FileDescriptor var1, boolean var2);

    private native void truncate0(FileDescriptor var1, long var2);

    private native int transferTo0(int var1, long var2, int var4, int var5);

    private native long position0(FileDescriptor var1, long var2);

    private native long size0(FileDescriptor var1);

    private static native long initIDs();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$FileChannelImpl == null ? (class$sun$nio$ch$FileChannelImpl = FileChannelImpl.class$("sun.nio.ch.FileChannelImpl")) : class$sun$nio$ch$FileChannelImpl).desiredAssertionStatus();
        transferSupported = true;
        Util.load();
        allocationGranularity = FileChannelImpl.initIDs();
        nd = new FileDispatcher();
    }
}

