/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;

public abstract class CustomCursor
extends Cursor {
    protected Image image;

    public CustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        super(string);
        this.image = image;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Canvas canvas = new Canvas();
        MediaTracker mediaTracker = new MediaTracker(canvas);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n2 = image.getWidth(canvas);
        int n3 = image.getHeight(canvas);
        if (mediaTracker.isErrorAny() || n2 < 0 || n3 < 0) {
            point.y = 0;
            point.x = 0;
        }
        Dimension dimension = toolkit.getBestCursorSize(n2, n3);
        if (dimension.width != n2 || dimension.height != n3) {
            image = image.getScaledInstance(dimension.width, dimension.height, 1);
            n2 = dimension.width;
            n3 = dimension.height;
        }
        if (point.x >= n2 || point.y >= n3 || point.x < 0 || point.y < 0) {
            throw new IndexOutOfBoundsException("invalid hotSpot");
        }
        int[] nArray = new int[n2 * n3];
        ImageProducer imageProducer = image.getSource();
        PixelGrabber pixelGrabber = new PixelGrabber(imageProducer, 0, 0, n2, n3, nArray, 0, n2);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.createNativeCursor(this.image, nArray, n2, n3, point.x, point.y);
    }

    protected abstract void createNativeCursor(Image var1, int[] var2, int var3, int var4, int var5, int var6);
}

