/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.transform.Source;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.dtm.Axis;
import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xml.dtm.DTMAxisTraverser;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMAxisIteratorBase;
import org.apache.xml.dtm.ref.DTMDefaultBaseTraversers;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.utils.NodeVector;
import org.apache.xml.utils.XMLStringFactory;

public abstract class DTMDefaultBaseIterators
extends DTMDefaultBaseTraversers {
    public DTMDefaultBaseIterators(DTMManager dTMManager, Source source, int n2, DTMWSFilter dTMWSFilter, XMLStringFactory xMLStringFactory, boolean bl2) {
        super(dTMManager, source, n2, dTMWSFilter, xMLStringFactory, bl2);
    }

    public DTMAxisIterator getTypedAxisIterator(int n2, int n3) {
        DTMAxisIterator dTMAxisIterator = null;
        switch (n2) {
            case 13: {
                dTMAxisIterator = new TypedSingletonIterator(n3);
                break;
            }
            case 3: {
                dTMAxisIterator = new TypedChildrenIterator(n3);
                break;
            }
            case 10: {
                return new ParentIterator().setNodeType(n3);
            }
            case 0: {
                return new TypedAncestorIterator(n3);
            }
            case 1: {
                return new TypedAncestorIterator(n3).includeSelf();
            }
            case 2: {
                return new TypedAttributeIterator(n3);
            }
            case 4: {
                dTMAxisIterator = new TypedDescendantIterator(n3);
                break;
            }
            case 5: {
                dTMAxisIterator = new TypedDescendantIterator(n3).includeSelf();
                break;
            }
            case 6: {
                dTMAxisIterator = new TypedFollowingIterator(n3);
                break;
            }
            case 11: {
                dTMAxisIterator = new TypedPrecedingIterator(n3);
                break;
            }
            case 7: {
                dTMAxisIterator = new TypedFollowingSiblingIterator(n3);
                break;
            }
            case 12: {
                dTMAxisIterator = new TypedPrecedingSiblingIterator(n3);
                break;
            }
            case 9: {
                dTMAxisIterator = new TypedNamespaceIterator(n3);
                break;
            }
            case 19: {
                dTMAxisIterator = new TypedRootIterator(n3);
                break;
            }
            default: {
                throw new DTMException(XSLMessages.createMessage(165, new Object[]{Axis.names[n2]}));
            }
        }
        return dTMAxisIterator;
    }

    public DTMAxisIterator getAxisIterator(int n2) {
        DTMAxisIterator dTMAxisIterator = null;
        switch (n2) {
            case 13: {
                dTMAxisIterator = new SingletonIterator();
                break;
            }
            case 3: {
                dTMAxisIterator = new ChildrenIterator();
                break;
            }
            case 10: {
                return new ParentIterator();
            }
            case 0: {
                return new AncestorIterator();
            }
            case 1: {
                return new AncestorIterator().includeSelf();
            }
            case 2: {
                return new AttributeIterator();
            }
            case 4: {
                dTMAxisIterator = new DescendantIterator();
                break;
            }
            case 5: {
                dTMAxisIterator = new DescendantIterator().includeSelf();
                break;
            }
            case 6: {
                dTMAxisIterator = new FollowingIterator();
                break;
            }
            case 11: {
                dTMAxisIterator = new PrecedingIterator();
                break;
            }
            case 7: {
                dTMAxisIterator = new FollowingSiblingIterator();
                break;
            }
            case 12: {
                dTMAxisIterator = new PrecedingSiblingIterator();
                break;
            }
            case 9: {
                dTMAxisIterator = new NamespaceIterator();
                break;
            }
            case 19: {
                dTMAxisIterator = new RootIterator();
                break;
            }
            default: {
                throw new DTMException(XSLMessages.createMessage(166, new Object[]{Axis.names[n2]}));
            }
        }
        return dTMAxisIterator;
    }

    private final class TypedSingletonIterator
    extends SingletonIterator {
        private final int _nodeType;

        public TypedSingletonIterator(int n2) {
            this._nodeType = n2;
        }

        public int next() {
            int n2 = super.next();
            return DTMDefaultBaseIterators.this.getExpandedTypeID(n2) == this._nodeType ? n2 : -1;
        }
    }

    private class SingletonIterator
    extends InternalAxisIteratorBase {
        private boolean _isConstant;

        public SingletonIterator() {
            this(Integer.MIN_VALUE, false);
        }

        public SingletonIterator(int n2) {
            this(n2, false);
        }

        public SingletonIterator(int n2, boolean bl2) {
            this._currentNode = this._startNode = n2;
            this._isConstant = bl2;
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isConstant) {
                this._currentNode = this._startNode;
                return this.resetPosition();
            }
            if (this._isRestartable) {
                if (this._currentNode == Integer.MIN_VALUE) {
                    this._currentNode = this._startNode = n2;
                }
                return this.resetPosition();
            }
            return this;
        }

        public DTMAxisIterator reset() {
            if (this._isConstant) {
                this._currentNode = this._startNode;
                return this.resetPosition();
            }
            boolean bl2 = this._isRestartable;
            this._isRestartable = true;
            this.setStartNode(this._startNode);
            this._isRestartable = bl2;
            return this;
        }

        public int next() {
            int n2 = this._currentNode;
            this._currentNode = -1;
            return this.returnNode(n2);
        }
    }

    private class NthDescendantIterator
    extends DescendantIterator {
        int _pos;

        public NthDescendantIterator(int n2) {
            this._pos = n2;
        }

        public int next() {
            int n2;
            while ((n2 = super.next()) != -1) {
                int n3 = DTMDefaultBaseIterators.this._parent(n2 &= 0x3FFFFF);
                int n4 = DTMDefaultBaseIterators.this._firstch(n3);
                int n5 = 0;
                do {
                    short s2;
                    if (1 != (s2 = DTMDefaultBaseIterators.this._type(n4))) continue;
                    ++n5;
                } while (n5 < this._pos && (n4 = DTMDefaultBaseIterators.this._nextsib(n4)) != -1);
                if (n2 != n4) continue;
                return n2;
            }
            return -1;
        }
    }

    private final class TypedDescendantIterator
    extends DescendantIterator {
        private final int _nodeType;

        public TypedDescendantIterator(int n2) {
            this._nodeType = n2;
        }

        public int next() {
            int n2;
            while ((n2 = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(n2) != this._nodeType) {
            }
            return n2;
        }
    }

    private class DescendantIterator
    extends InternalAxisIteratorBase {
        private DescendantIterator() {
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                n2 &= 0x3FFFFF;
                this._startNode = n2--;
                if (this._includeSelf) {
                    // empty if block
                }
                this._currentNode = n2;
                return this.resetPosition();
            }
            return this;
        }

        protected boolean isDescendant(int n2) {
            return this._startNode == n2 || DTMDefaultBaseIterators.this._parent(n2) >= this._startNode;
        }

        public int next() {
            int n2;
            short s2;
            do {
                if (-1 != (s2 = DTMDefaultBaseIterators.this._type(n2 = ++this._currentNode)) && this.isDescendant(n2)) continue;
                return -1;
            } while (2 == s2 || 13 == s2);
            return this.returnNode(n2 | DTMDefaultBaseIterators.this.m_dtmIdent);
        }
    }

    private final class TypedAncestorIterator
    extends AncestorIterator {
        private final int _nodeType;

        public TypedAncestorIterator(int n2) {
            this._nodeType = n2;
        }

        public int next() {
            int n2;
            while ((n2 = super.next()) != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(n2) != this._nodeType) continue;
                return this.returnNode(n2);
            }
            return -1;
        }

        public int getLast() {
            int n2 = -1;
            int n3 = this._startNode;
            while (n3 != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(n3) == this._nodeType) {
                    n2 = n3;
                }
                n3 = DTMDefaultBaseIterators.this.getParent(n3);
            }
            return n2;
        }
    }

    private class AncestorIterator
    extends InternalAxisIteratorBase {
        NodeVector m_ancestors = new NodeVector();
        int m_ancestorsPos;
        int m_realStartNode;

        private AncestorIterator() {
        }

        public int getStartNode() {
            return this.m_realStartNode;
        }

        public final boolean isReverse() {
            return true;
        }

        public int getLast() {
            return this._startNode;
        }

        public DTMAxisIterator cloneIterator() {
            this._isRestartable = false;
            try {
                AncestorIterator ancestorIterator = (AncestorIterator)super.clone();
                ancestorIterator._startNode = this._startNode;
                return ancestorIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new DTMException(XSLMessages.createMessage(167, null));
            }
        }

        public DTMAxisIterator setStartNode(int n2) {
            this.m_realStartNode = n2;
            if (this._isRestartable) {
                this._startNode = this._includeSelf ? n2 : DTMDefaultBaseIterators.this.getParent(n2);
                this._currentNode = DTMDefaultBaseIterators.this.getDocument();
                n2 = this._startNode;
                while (n2 != -1) {
                    this.m_ancestors.addElement(n2);
                    n2 = DTMDefaultBaseIterators.this.getParent(n2);
                }
                this.m_ancestorsPos = this.m_ancestors.size() - 1;
                return this.resetPosition();
            }
            return this;
        }

        public DTMAxisIterator reset() {
            this._currentNode = DTMDefaultBaseIterators.this.getDocument();
            this.m_ancestorsPos = this.m_ancestors.size() - 1;
            return this.resetPosition();
        }

        public int next() {
            int n2;
            int n3 = this._currentNode;
            this._currentNode = (n2 = this.m_ancestorsPos--) < 0 ? -1 : this.m_ancestors.elementAt(n2);
            return this.returnNode(n3);
        }
    }

    private final class TypedFollowingIterator
    extends FollowingIterator {
        private final int _nodeType;

        public TypedFollowingIterator(int n2) {
            this._nodeType = n2;
        }

        public int next() {
            int n2;
            while ((n2 = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(n2) != this._nodeType) {
            }
            return this.returnNode(n2);
        }
    }

    private class FollowingIterator
    extends InternalAxisIteratorBase {
        DTMAxisTraverser m_traverser;

        public FollowingIterator() {
            this.m_traverser = DTMDefaultBaseIterators.this.getAxisTraverser(6);
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._startNode = n2;
                this._currentNode = this.m_traverser.first(n2);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n2 = this._currentNode;
            this._currentNode = this.m_traverser.next(this._startNode, this._currentNode);
            return this.returnNode(n2);
        }
    }

    private final class TypedPrecedingIterator
    extends PrecedingIterator {
        private final int _nodeType;

        public TypedPrecedingIterator(int n2) {
            this._nodeType = n2;
        }

        public int next() {
            int n2;
            while ((n2 = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(n2) != this._nodeType) {
            }
            return n2;
        }
    }

    private class PrecedingIterator
    extends InternalAxisIteratorBase {
        private final int _maxAncestors = 8;
        private int[] _stack = new int[8];
        private int _sp;
        private int _oldsp;

        private PrecedingIterator() {
        }

        public boolean isReverse() {
            return true;
        }

        public DTMAxisIterator cloneIterator() {
            this._isRestartable = false;
            try {
                PrecedingIterator precedingIterator = (PrecedingIterator)super.clone();
                int[] nArray = new int[this._stack.length];
                System.arraycopy(this._stack, 0, nArray, 0, this._stack.length);
                precedingIterator._stack = nArray;
                return precedingIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new DTMException(XSLMessages.createMessage(167, null));
            }
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._startNode = n2 &= 0x3FFFFF;
                this._currentNode = 0;
                int n3 = 0;
                this._stack[0] = n2;
                if (n2 > 0) {
                    int n4;
                    while ((n4 = DTMDefaultBaseIterators.this._parent(n2)) != 0) {
                        if (++n3 == this._stack.length) {
                            int[] nArray = new int[n3 + 4];
                            System.arraycopy(this._stack, 0, nArray, 0, n3);
                            this._stack = nArray;
                        }
                        this._stack[n3] = n2 = n4;
                    }
                }
                this._oldsp = this._sp = n3;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n2 = this._currentNode + 1;
            if (this._sp >= 0 && n2 < this._stack[this._sp]) {
                this._currentNode = n2;
                return this.returnNode(this._currentNode | DTMDefaultBaseIterators.this.m_dtmIdent);
            }
            this._currentNode = n2;
            return --this._sp >= 0 ? this.next() : -1;
        }

        public DTMAxisIterator reset() {
            this._sp = this._oldsp;
            return this.resetPosition();
        }
    }

    private final class TypedPrecedingSiblingIterator
    extends PrecedingSiblingIterator {
        private final int _nodeType;

        public TypedPrecedingSiblingIterator(int n2) {
            this._nodeType = n2;
        }

        public int next() {
            int n2;
            while ((n2 = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(n2) != this._nodeType) {
            }
            return n2;
        }
    }

    private class PrecedingSiblingIterator
    extends InternalAxisIteratorBase {
        private PrecedingSiblingIterator() {
        }

        public boolean isReverse() {
            return true;
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._startNode = n2;
                if (n2 == -1) {
                    this._currentNode = n2;
                    return this.resetPosition();
                }
                int n3 = DTMDefaultBaseIterators.this.getExpandedTypeID(n2) & ExpandedNameTable.MASK_NODETYPE;
                this._currentNode = ExpandedNameTable.ATTRIBUTE == n3 || ExpandedNameTable.NAMESPACE == n3 ? n2 : DTMDefaultBaseIterators.this.getFirstChild(DTMDefaultBaseIterators.this.getParent(n2));
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            if (this._currentNode == this._startNode) {
                return -1;
            }
            int n2 = this._currentNode;
            this._currentNode = DTMDefaultBaseIterators.this.getNextSibling(n2);
            return this.returnNode(n2);
        }
    }

    private final class TypedAttributeIterator
    extends InternalAxisIteratorBase {
        private final int _nodeType;

        public TypedAttributeIterator(int n2) {
            this._nodeType = n2;
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._startNode = n2;
                n2 = DTMDefaultBaseIterators.this.getFirstAttribute(n2);
                while (n2 != -1) {
                    if (DTMDefaultBaseIterators.this.getExpandedTypeID(n2) == this._nodeType) break;
                    n2 = DTMDefaultBaseIterators.this.getNextAttribute(n2);
                }
                this._currentNode = n2;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n2 = this._currentNode;
            this._currentNode = -1;
            return this.returnNode(n2);
        }
    }

    private final class AttributeIterator
    extends InternalAxisIteratorBase {
        private AttributeIterator() {
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._startNode = n2;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstAttribute(n2);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n2 = this._currentNode;
            this._currentNode = DTMDefaultBaseIterators.this.getNextAttribute(n2);
            return this.returnNode(n2);
        }
    }

    private final class TypedFollowingSiblingIterator
    extends FollowingSiblingIterator {
        private final int _nodeType;

        public TypedFollowingSiblingIterator(int n2) {
            this._nodeType = n2;
        }

        public int next() {
            int n2;
            while ((n2 = super.next()) != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(n2) != this._nodeType) {
            }
            return n2;
        }
    }

    private class FollowingSiblingIterator
    extends InternalAxisIteratorBase {
        private FollowingSiblingIterator() {
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._currentNode = this._startNode = n2;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            this._currentNode = DTMDefaultBaseIterators.this.getNextSibling(this._currentNode);
            return this.returnNode(this._currentNode);
        }
    }

    private final class NamespaceAttributeIterator
    extends InternalAxisIteratorBase {
        private final int _nsType;

        public NamespaceAttributeIterator(int n2) {
            this._nsType = n2;
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._startNode = n2;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstNamespaceNode(n2, false);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n2 = this._currentNode;
            if (-1 != n2) {
                this._currentNode = DTMDefaultBaseIterators.this.getNextNamespaceNode(this._startNode, n2, false);
            }
            return this.returnNode(n2);
        }
    }

    private class TypedRootIterator
    extends RootIterator {
        private final int _nodeType;

        public TypedRootIterator(int n2) {
            this._nodeType = n2;
        }

        public int next() {
            int n2 = super.next();
            while (n2 != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(n2) == this._nodeType) {
                    this._currentNode = n2;
                    return this.returnNode(n2);
                }
                n2 = super.next();
            }
            return -1;
        }
    }

    private class RootIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._startNode = DTMDefaultBaseIterators.this.getDocument();
                this._currentNode = -1;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            if (this._startNode == this._currentNode) {
                return -1;
            }
            this._currentNode = this._startNode;
            return this.returnNode(this._startNode);
        }
    }

    private class TypedNamespaceIterator
    extends NamespaceIterator {
        private final int _nodeType;

        public TypedNamespaceIterator(int n2) {
            this._nodeType = n2;
        }

        public int next() {
            int n2 = super.next();
            while (n2 != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(n2) == this._nodeType) {
                    this._currentNode = n2;
                    return this.returnNode(n2);
                }
                n2 = super.next();
            }
            return -1;
        }
    }

    private class NamespaceIterator
    extends InternalAxisIteratorBase {
        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._startNode = n2;
                this._currentNode = DTMDefaultBaseIterators.this.getFirstNamespaceNode(n2, true);
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n2 = this._currentNode;
            if (-1 != n2) {
                this._currentNode = DTMDefaultBaseIterators.this.getNextNamespaceNode(this._startNode, n2, true);
            }
            return this.returnNode(n2);
        }
    }

    private final class NamespaceChildrenIterator
    extends InternalAxisIteratorBase {
        private final int _nsType;

        public NamespaceChildrenIterator(int n2) {
            this._nsType = n2;
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._startNode = n2;
                this._currentNode = -2;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n2 = -2 == this._currentNode ? DTMDefaultBaseIterators.this.getFirstChild(this._startNode) : DTMDefaultBaseIterators.this.getNextSibling(this._currentNode);
            while (n2 != -1) {
                if (DTMDefaultBaseIterators.this.getNamespaceType(n2) == this._nsType) {
                    this._currentNode = n2;
                    return this.returnNode(n2);
                }
                n2 = DTMDefaultBaseIterators.this.getNextSibling(n2);
            }
            return -1;
        }
    }

    private final class TypedChildrenIterator
    extends InternalAxisIteratorBase {
        private final int _nodeType;

        public TypedChildrenIterator(int n2) {
            this._nodeType = n2;
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._startNode = n2;
                this._currentNode = -2;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            int n2 = -2 == this._currentNode ? DTMDefaultBaseIterators.this.getFirstChild(this._startNode) : DTMDefaultBaseIterators.this.getNextSibling(this._currentNode);
            while (n2 != -1) {
                if (DTMDefaultBaseIterators.this.getExpandedTypeID(n2) == this._nodeType) {
                    this._currentNode = n2;
                    return this.returnNode(n2);
                }
                n2 = DTMDefaultBaseIterators.this.getNextSibling(n2);
            }
            return -1;
        }
    }

    private final class ParentIterator
    extends InternalAxisIteratorBase {
        private int _nodeType = -1;

        private ParentIterator() {
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._startNode = n2;
                this._currentNode = DTMDefaultBaseIterators.this.getParent(n2);
                return this.resetPosition();
            }
            return this;
        }

        public DTMAxisIterator setNodeType(int n2) {
            this._nodeType = n2;
            return this;
        }

        public int next() {
            int n2 = this._currentNode;
            n2 = this._nodeType != -1 && DTMDefaultBaseIterators.this.getExpandedTypeID(this._currentNode) != this._nodeType ? -1 : this._currentNode;
            this._currentNode = -1;
            return this.returnNode(n2);
        }
    }

    private final class ChildrenIterator
    extends InternalAxisIteratorBase {
        private ChildrenIterator() {
        }

        public DTMAxisIterator setStartNode(int n2) {
            if (this._isRestartable) {
                this._startNode = n2;
                this._currentNode = -2;
                return this.resetPosition();
            }
            return this;
        }

        public int next() {
            this._currentNode = -2 == this._currentNode ? DTMDefaultBaseIterators.this.getFirstChild(this._startNode) : DTMDefaultBaseIterators.this.getNextSibling(this._currentNode);
            return this.returnNode(this._currentNode);
        }
    }

    private abstract class InternalAxisIteratorBase
    extends DTMAxisIteratorBase {
        protected int _currentNode;

        private InternalAxisIteratorBase() {
        }

        public void setMark() {
            this._markedNode = this._currentNode;
        }

        public void gotoMark() {
            this._currentNode = this._markedNode;
        }
    }
}

